/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.dynamo.db.lib.exceptions.DuplicateRequestException;
import ru.quadcom.dynamo.db.lib.exceptions.InvalidRequestException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionAssertionException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionNotFoundException;
import ru.quadcom.dynamo.db.lib.transactions.ImmutableKey;
import ru.quadcom.dynamo.db.lib.transactions.Request;
import ru.quadcom.dynamo.db.lib.transactions.Transaction;
import ru.quadcom.dynamo.db.lib.transactions.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionItem {
    private static final String STATE_PENDING = "P";
    private static final String STATE_COMMITTED = "C";
    private static final String STATE_ROLLED_BACK = "R";
    protected final String txId;
    private final TransactionManager txManager;
    private Map<String, AttributeValue> txItem;
    private int version;
    private final Map<String, AttributeValue> txKey;
    private final Map<String, HashMap<ImmutableKey, Request>> requestsMap = new HashMap<String, HashMap<ImmutableKey, Request>>();

    public TransactionItem(String txId, TransactionManager txManager, boolean insert) throws TransactionNotFoundException {
        this(txId, txManager, insert, null);
    }

    public TransactionItem(Map<String, AttributeValue> txItem, TransactionManager txManager) throws TransactionNotFoundException {
        this(null, txManager, false, txItem);
    }

    protected TransactionItem(String txId, TransactionManager txManager, boolean insert, Map<String, AttributeValue> txItem) throws TransactionNotFoundException {
        HashMap<String, AttributeValue> txKeyMap;
        this.txManager = txManager;
        if (txId != null) {
            if (txItem != null) {
                throw new TransactionException(txId, "When providing txId, txItem must be null");
            }
            this.txId = txId;
            txKeyMap = new HashMap<String, AttributeValue>(1);
            txKeyMap.put(Transaction.AttributeName.TXID.toString(), new AttributeValue(txId));
            this.txKey = Collections.unmodifiableMap(txKeyMap);
            if (insert) {
                this.txItem = this.insert();
            } else {
                this.txItem = this.get();
                if (this.txItem == null) {
                    throw new TransactionNotFoundException(this.txId);
                }
            }
        } else if (txItem != null) {
            if (insert) {
                throw new TransactionException(txId, "When providing a txItem, insert must be false");
            }
            this.txItem = txItem;
            if (!TransactionItem.isTransactionItem(txItem)) {
                throw new TransactionException(txId, "txItem is not a transaction item");
            }
            this.txId = txItem.get(Transaction.AttributeName.TXID.toString()).getS();
            txKeyMap = new HashMap(1);
            txKeyMap.put(Transaction.AttributeName.TXID.toString(), new AttributeValue(this.txId));
            this.txKey = Collections.unmodifiableMap(txKeyMap);
        } else {
            throw new TransactionException(null, "Either txId or txItem must be specified");
        }
        AttributeValue txVersionVal = this.txItem.get(Transaction.AttributeName.VERSION.toString());
        if (txVersionVal == null || txVersionVal.getN() == null) {
            throw new TransactionException(this.txId, "Version number is not present in TX record");
        }
        this.version = Integer.parseInt(txVersionVal.getN());
        this.loadRequests();
    }

    private Map<String, AttributeValue> insert() {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(Transaction.AttributeName.STATE.toString(), new AttributeValue(STATE_PENDING));
        item.put(Transaction.AttributeName.VERSION.toString(), new AttributeValue().withN(Integer.toString(1)));
        item.put(Transaction.AttributeName.DATE.toString(), this.txManager.getCurrentTimeAttribute());
        item.putAll(this.txKey);
        HashMap<String, ExpectedAttributeValue> expectNotExists = new HashMap<String, ExpectedAttributeValue>(2);
        expectNotExists.put(Transaction.AttributeName.TXID.toString(), new ExpectedAttributeValue(Boolean.valueOf(false)));
        expectNotExists.put(Transaction.AttributeName.STATE.toString(), new ExpectedAttributeValue(Boolean.valueOf(false)));
        PutItemRequest request = new PutItemRequest().withTableName(this.txManager.getTransactionTableName()).withItem(item).withExpected(expectNotExists);
        try {
            this.txManager.getClient().putItem(request);
            return item;
        }
        catch (ConditionalCheckFailedException e) {
            throw new TransactionException("Failed to create new transaction with id " + this.txId, e);
        }
    }

    private Map<String, AttributeValue> get() {
        GetItemRequest getRequest = new GetItemRequest().withTableName(this.txManager.getTransactionTableName()).withKey(this.txKey).withConsistentRead(Boolean.valueOf(true));
        return this.txManager.getClient().getItem(getRequest).getItem();
    }

    public int getVersion() {
        return this.version;
    }

    public static boolean isTransactionItem(Map<String, AttributeValue> txItem) {
        if (txItem == null) {
            throw new TransactionException(null, "txItem must not be null");
        }
        if (!txItem.containsKey(Transaction.AttributeName.TXID.toString())) {
            return false;
        }
        return txItem.get(Transaction.AttributeName.TXID.toString()).getS() != null;
    }

    public long getLastUpdateTimeMillis() {
        AttributeValue requestsVal = this.txItem.get(Transaction.AttributeName.DATE.toString());
        if (requestsVal == null || requestsVal.getN() == null) {
            throw new TransactionAssertionException(this.txId, "Expected date attribute to be defined");
        }
        try {
            double date = Double.parseDouble(requestsVal.getN());
            return (long)(date * 1000.0);
        }
        catch (NumberFormatException e) {
            throw new TransactionException("Excpected valid date attribute, was: " + requestsVal.getN(), e);
        }
    }

    public ArrayList<Request> getRequests() {
        ArrayList<Request> requests = new ArrayList<Request>();
        for (Map.Entry<String, HashMap<ImmutableKey, Request>> tableRequests : this.requestsMap.entrySet()) {
            for (Map.Entry<ImmutableKey, Request> keyRequests : tableRequests.getValue().entrySet()) {
                requests.add(keyRequests.getValue());
            }
        }
        return requests;
    }

    public Request getRequestForKey(String tableName, Map<String, AttributeValue> key) {
        Request request;
        HashMap<ImmutableKey, Request> tableRequests = this.requestsMap.get(tableName);
        if (tableRequests != null && (request = tableRequests.get(new ImmutableKey(key))) != null) {
            return request;
        }
        return null;
    }

    public synchronized boolean addRequest(Request callerRequest) throws ConditionalCheckFailedException, DuplicateRequestException {
        this.addRequestToMap(callerRequest);
        callerRequest.setRid(this.version);
        ByteBuffer requestBytes = Request.serialize(this.txId, callerRequest);
        AttributeValueUpdate txItemUpdate = new AttributeValueUpdate().withAction(AttributeAction.ADD).withValue(new AttributeValue().withBS(Arrays.asList(requestBytes)));
        HashMap<String, AttributeValueUpdate> txItemUpdates = new HashMap<String, AttributeValueUpdate>();
        txItemUpdates.put(Transaction.AttributeName.REQUESTS.toString(), txItemUpdate);
        txItemUpdates.put(Transaction.AttributeName.VERSION.toString(), new AttributeValueUpdate().withAction(AttributeAction.ADD).withValue(new AttributeValue().withN("1")));
        txItemUpdates.put(Transaction.AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(this.txManager.getCurrentTimeAttribute()));
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
        expected.put(Transaction.AttributeName.STATE.toString(), new ExpectedAttributeValue(new AttributeValue(STATE_PENDING)));
        expected.put(Transaction.AttributeName.VERSION.toString(), new ExpectedAttributeValue(new AttributeValue().withN(Integer.toString(this.version))));
        UpdateItemRequest txItemUpdateRequest = new UpdateItemRequest().withTableName(this.txManager.getTransactionTableName()).withKey(this.txKey).withExpected(expected).withReturnValues(ReturnValue.ALL_NEW).withAttributeUpdates(txItemUpdates);
        try {
            this.txItem = this.txManager.getClient().updateItem(txItemUpdateRequest).getAttributes();
            int newVersion = Integer.parseInt(this.txItem.get(Transaction.AttributeName.VERSION.toString()).getN());
            TransactionAssertionException.txAssert(newVersion == this.version + 1, this.txId, "Unexpected version number from update result", new Object[0]);
            this.version = newVersion;
        }
        catch (AmazonServiceException e) {
            if ("ValidationException".equals(e.getErrorCode())) {
                this.removeRequestFromMap(callerRequest);
                throw new InvalidRequestException("The amount of data in the transaction cannot exceed the DynamoDB item size limit", this.txId, callerRequest.getTableName(), callerRequest.getKey(this.txManager), callerRequest);
            }
            throw e;
        }
        return true;
    }

    private void loadRequests() {
        AttributeValue requestsVal = this.txItem.get(Transaction.AttributeName.REQUESTS.toString());
        List rawRequests = requestsVal != null && requestsVal.getBS() != null ? requestsVal.getBS() : new ArrayList(0);
        for (ByteBuffer rawRequest : rawRequests) {
            Request request = Request.deserialize(this.txId, rawRequest);
            this.addRequestToMap(request);
        }
    }

    private boolean addRequestToMap(Request request) throws DuplicateRequestException {
        Request existingRequest;
        Map<String, AttributeValue> key = request.getKey(this.txManager);
        ImmutableKey immutableKey = new ImmutableKey(key);
        HashMap<ImmutableKey, Request> pkToRequestMap = this.requestsMap.get(request.getTableName());
        if (pkToRequestMap == null) {
            pkToRequestMap = new HashMap();
            this.requestsMap.put(request.getTableName(), pkToRequestMap);
        }
        if ((existingRequest = pkToRequestMap.get(immutableKey)) != null) {
            if (request instanceof Request.GetItem) {
                return false;
            }
            if (!(existingRequest instanceof Request.GetItem)) {
                throw new DuplicateRequestException(this.txId, request.getTableName(), key.toString());
            }
        }
        pkToRequestMap.put(immutableKey, request);
        return true;
    }

    private void removeRequestFromMap(Request request) {
        ImmutableKey key = new ImmutableKey(request.getKey(this.txManager));
        this.requestsMap.get(request.getTableName()).remove(key);
    }

    public void saveItemImage(Map<String, AttributeValue> item, int rid) {
        TransactionAssertionException.txAssert(!item.containsKey(Transaction.AttributeName.APPLIED.toString()), this.txId, "The transaction has already applied this item image, it should not be saving over the item image with it", new Object[0]);
        AttributeValue existingTxId = item.put(Transaction.AttributeName.TXID.toString(), new AttributeValue(this.txId));
        if (existingTxId != null && !this.txId.equals(existingTxId.getS())) {
            throw new TransactionException(this.txId, "Items in transactions may not contain the attribute named " + Transaction.AttributeName.TXID.toString());
        }
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(1);
        expected.put(Transaction.AttributeName.IMAGE_ID.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        AttributeValue existingImageId = item.put(Transaction.AttributeName.IMAGE_ID.toString(), new AttributeValue(this.txId + "#" + rid));
        if (existingImageId != null) {
            throw new TransactionException(this.txId, "Items in transactions may not contain the attribute named " + Transaction.AttributeName.IMAGE_ID.toString() + ", value was already " + existingImageId);
        }
        try {
            this.txManager.getClient().putItem(new PutItemRequest().withTableName(this.txManager.getItemImageTableName()).withExpected(expected).withItem(item));
        }
        catch (ConditionalCheckFailedException e) {
            // empty catch block
        }
        item.remove(Transaction.AttributeName.IMAGE_ID.toString());
    }

    public Map<String, AttributeValue> loadItemImage(int rid) {
        TransactionAssertionException.txAssert(rid > 0, this.txId, "Expected rid > 0", new Object[0]);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>(1);
        key.put(Transaction.AttributeName.IMAGE_ID.toString(), new AttributeValue(this.txId + "#" + rid));
        Map item = this.txManager.getClient().getItem(new GetItemRequest().withTableName(this.txManager.getItemImageTableName()).withKey(key).withConsistentRead(Boolean.valueOf(true))).getItem();
        if (item != null) {
            item.remove(Transaction.AttributeName.IMAGE_ID.toString());
        }
        return item;
    }

    public void deleteItemImage(int rid) {
        TransactionAssertionException.txAssert(rid > 0, this.txId, "Expected rid > 0", new Object[0]);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>(1);
        key.put(Transaction.AttributeName.IMAGE_ID.toString(), new AttributeValue(this.txId + "#" + rid));
        this.txManager.getClient().deleteItem(new DeleteItemRequest().withTableName(this.txManager.getItemImageTableName()).withKey(key));
    }

    public void finish(State targetState, Integer expectedVersion) throws ConditionalCheckFailedException {
        TransactionAssertionException.txAssert(State.COMMITTED.equals((Object)targetState) || State.ROLLED_BACK.equals((Object)targetState), "Illegal state in finish(): " + (Object)((Object)targetState), "txItem", this.txItem);
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(2);
        expected.put(Transaction.AttributeName.STATE.toString(), new ExpectedAttributeValue().withValue(new AttributeValue().withS(STATE_PENDING)));
        expected.put(Transaction.AttributeName.FINALIZED.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        if (expectedVersion != null) {
            expected.put(Transaction.AttributeName.VERSION.toString(), new ExpectedAttributeValue().withValue(new AttributeValue().withN(expectedVersion.toString())));
        }
        HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
        updates.put(Transaction.AttributeName.STATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue(TransactionItem.stateToString(targetState))));
        updates.put(Transaction.AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(this.txManager.getCurrentTimeAttribute()));
        UpdateItemRequest finishRequest = new UpdateItemRequest().withTableName(this.txManager.getTransactionTableName()).withKey(this.txKey).withAttributeUpdates(updates).withReturnValues(ReturnValue.ALL_NEW).withExpected(expected);
        UpdateItemResult finishResult = this.txManager.getClient().updateItem(finishRequest);
        this.txItem = finishResult.getAttributes();
        if (this.txItem == null) {
            throw new TransactionAssertionException(this.txId, "Unexpected null tx item after committing " + (Object)((Object)targetState));
        }
    }

    public void complete(State expectedCurrentState) throws ConditionalCheckFailedException {
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(2);
        if (State.COMMITTED.equals((Object)expectedCurrentState)) {
            expected.put(Transaction.AttributeName.STATE.toString(), new ExpectedAttributeValue(new AttributeValue(STATE_COMMITTED)));
        } else if (State.ROLLED_BACK.equals((Object)expectedCurrentState)) {
            expected.put(Transaction.AttributeName.STATE.toString(), new ExpectedAttributeValue(new AttributeValue(STATE_ROLLED_BACK)));
        } else {
            throw new TransactionAssertionException(this.txId, "Illegal state in finish(): " + (Object)((Object)expectedCurrentState) + " txItem " + this.txItem);
        }
        HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
        updates.put(Transaction.AttributeName.FINALIZED.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue("1")));
        updates.put(Transaction.AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(this.txManager.getCurrentTimeAttribute()));
        UpdateItemRequest completeRequest = new UpdateItemRequest().withTableName(this.txManager.getTransactionTableName()).withKey(this.txKey).withAttributeUpdates(updates).withReturnValues(ReturnValue.ALL_NEW).withExpected(expected);
        this.txItem = this.txManager.getClient().updateItem(completeRequest).getAttributes();
    }

    public void delete() throws ConditionalCheckFailedException {
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(1);
        expected.put(Transaction.AttributeName.FINALIZED.toString(), new ExpectedAttributeValue().withValue(new AttributeValue("1")));
        DeleteItemRequest completeRequest = new DeleteItemRequest().withTableName(this.txManager.getTransactionTableName()).withKey(this.txKey).withExpected(expected);
        this.txManager.getClient().deleteItem(completeRequest);
    }

    public boolean isCompleted() {
        boolean isCompleted = this.txItem.containsKey(Transaction.AttributeName.FINALIZED.toString());
        if (isCompleted) {
            TransactionAssertionException.txAssert(State.COMMITTED.equals((Object)this.getState()) || State.ROLLED_BACK.equals((Object)this.getState()), this.txId, "Unexpected terminal state for completed transaction", new Object[]{"state", this.getState()});
        }
        return isCompleted;
    }

    protected Map<String, HashMap<ImmutableKey, Request>> getRequestMap() {
        return this.requestsMap;
    }

    public State getState() {
        String txState;
        AttributeValue stateVal = this.txItem.get(Transaction.AttributeName.STATE.toString());
        String string = txState = stateVal != null ? stateVal.getS() : null;
        if (STATE_COMMITTED.equals(txState)) {
            return State.COMMITTED;
        }
        if (STATE_ROLLED_BACK.equals(txState)) {
            return State.ROLLED_BACK;
        }
        if (STATE_PENDING.equals(txState)) {
            return State.PENDING;
        }
        throw new TransactionAssertionException(this.txId, "Unrecognized transaction state: " + txState);
    }

    public static String stateToString(State state) {
        switch (state) {
            case PENDING: {
                return STATE_PENDING;
            }
            case COMMITTED: {
                return STATE_COMMITTED;
            }
            case ROLLED_BACK: {
                return STATE_ROLLED_BACK;
            }
        }
        throw new TransactionAssertionException(null, "Unrecognized transaction state: " + (Object)((Object)state));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PENDING,
        COMMITTED,
        State,
        ROLLED_BACK;

    }
}

