/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ru.quadcom.dynamo.db.lib.exceptions.DuplicateRequestException;
import ru.quadcom.dynamo.db.lib.exceptions.ItemNotLockedException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionAssertionException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionCommittedException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionCompletedException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionNotFoundException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionRolledBackException;
import ru.quadcom.dynamo.db.lib.exceptions.UnknownCompletedTransactionException;
import ru.quadcom.dynamo.db.lib.transactions.Request;
import ru.quadcom.dynamo.db.lib.transactions.TransactionDynamoDBFacade;
import ru.quadcom.dynamo.db.lib.transactions.TransactionItem;
import ru.quadcom.dynamo.db.lib.transactions.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private static final Log LOG = LogFactory.getLog(Transaction.class);
    private static final int ITEM_LOCK_ACQUIRE_ATTEMPTS = 3;
    private static final int ITEM_COMMIT_ATTEMPTS = 2;
    private static final int TX_LOCK_ACQUIRE_ATTEMPTS = 2;
    private static final int TX_LOCK_CONTENTION_RESOLUTION_ATTEMPTS = 3;
    protected static final String BOOLEAN_TRUE_ATTR_VAL = "1";
    protected static final String TX_ATTR_PREFIX = "_Tx";
    public static final Set<String> SPECIAL_ATTR_NAMES;
    private final TransactionManager txManager;
    private TransactionItem txItem;
    private final String txId;
    private final TreeSet<Integer> fullyAppliedRequests = new TreeSet();

    protected Transaction(String txId, TransactionManager txManager, boolean insert) throws TransactionNotFoundException {
        this.txManager = txManager;
        this.txItem = new TransactionItem(txId, txManager, insert);
        this.txId = txId;
    }

    protected Transaction(Map<String, AttributeValue> txItem, TransactionManager txManager) throws TransactionNotFoundException {
        this.txManager = txManager;
        this.txItem = new TransactionItem(txItem, txManager);
        this.txId = this.txItem.txId;
    }

    public String getId() {
        return this.txId;
    }

    public PutItemResult putItem(PutItemRequest request) throws DuplicateRequestException, ItemNotLockedException, TransactionCompletedException, TransactionNotFoundException, TransactionException {
        Request.PutItem wrappedRequest = new Request.PutItem();
        wrappedRequest.setRequest(request);
        Map<String, AttributeValue> item = this.driveRequest(wrappedRequest);
        Transaction.stripSpecialAttributes(item);
        return new PutItemResult().withAttributes(item);
    }

    public UpdateItemResult updateItem(UpdateItemRequest request) throws DuplicateRequestException, ItemNotLockedException, TransactionCompletedException, TransactionNotFoundException, TransactionException {
        Request.UpdateItem wrappedRequest = new Request.UpdateItem();
        wrappedRequest.setRequest(request);
        Map<String, AttributeValue> item = this.driveRequest(wrappedRequest);
        Transaction.stripSpecialAttributes(item);
        return new UpdateItemResult().withAttributes(item);
    }

    public DeleteItemResult deleteItem(DeleteItemRequest request) throws DuplicateRequestException, ItemNotLockedException, TransactionCompletedException, TransactionNotFoundException, TransactionException {
        Request.DeleteItem wrappedRequest = new Request.DeleteItem();
        wrappedRequest.setRequest(request);
        Map<String, AttributeValue> item = this.driveRequest(wrappedRequest);
        Transaction.stripSpecialAttributes(item);
        return new DeleteItemResult().withAttributes(item);
    }

    public GetItemResult getItem(GetItemRequest request) throws DuplicateRequestException, ItemNotLockedException, TransactionCompletedException, TransactionNotFoundException, TransactionException {
        Request.GetItem wrappedRequest = new Request.GetItem();
        wrappedRequest.setRequest(request);
        Map<String, AttributeValue> item = this.driveRequest(wrappedRequest);
        Transaction.stripSpecialAttributes(item);
        GetItemResult result = new GetItemResult().withItem(item);
        return result;
    }

    protected static GetItemResult getItem(GetItemRequest request, IsolationLevel isolationLevel, TransactionManager txManager) {
        if (isolationLevel == null) {
            throw new IllegalArgumentException("isolation level is required");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is required");
        }
        List attributesToGet = request.getAttributesToGet();
        if (attributesToGet != null) {
            attributesToGet.addAll(SPECIAL_ATTR_NAMES);
        }
        GetItemResult result = null;
        switch (isolationLevel) {
            case UNCOMMITTED: {
                result = Transaction.getItemUncommitted(request, txManager);
                break;
            }
            case COMMITTED: {
                result = Transaction.getItemCommitted(request, txManager);
                break;
            }
            case READ_LOCK: {
                throw new IllegalArgumentException("Cannot call getItem at the READ_LOCK isolation level outside of a transaction. Call getItem on a transaction directly instead.");
            }
            default: {
                throw new IllegalArgumentException("Unrecognized isolation level: " + (Object)((Object)isolationLevel));
            }
        }
        Transaction.stripSpecialAttributes(result.getItem());
        return result;
    }

    protected static GetItemResult getItemUncommitted(GetItemRequest request, TransactionManager txManager) {
        GetItemResult getResult = txManager.getClient().getItem(request);
        Map item = getResult.getItem();
        if (item == null) {
            return getResult;
        }
        if (Transaction.isTransient(item) && !Transaction.isApplied(item)) {
            getResult.setItem(null);
            return getResult;
        }
        return getResult;
    }

    protected static GetItemResult getItemCommitted(GetItemRequest request, TransactionManager txManager) {
        int attempts = 3;
        for (int i = 0; i < attempts; ++i) {
            GetItemResult getResult = txManager.getClient().getItem(request);
            Map item = getResult.getItem();
            if (item == null) {
                return getResult;
            }
            if (Transaction.isTransient(item)) {
                getResult.setItem(null);
                return getResult;
            }
            if (!Transaction.isApplied(item)) {
                return getResult;
            }
            String lockingTxId = Transaction.getOwner(item);
            if (lockingTxId == null) {
                return getResult;
            }
            try {
                Transaction lockingTx = new Transaction(lockingTxId, txManager, false);
                if (TransactionItem.State.COMMITTED.equals((Object)lockingTx.getTxItem().getState())) {
                    return getResult;
                }
                Request lockingRequest = lockingTx.getTxItem().getRequestForKey(request.getTableName(), request.getKey());
                TransactionAssertionException.txAssert(lockingRequest != null, null, "Expected transaction to be locking request, but no request found for tx", lockingTx.getId(), "table", request.getTableName(), "key ", request.getKey());
                Map<String, AttributeValue> oldItem = lockingTx.getTxItem().loadItemImage(lockingRequest.getRid());
                if (oldItem == null) {
                    LOG.debug((Object)("Item image " + lockingRequest.getRid() + " missing for transaction " + lockingTx.getId()));
                    request.setConsistentRead(Boolean.valueOf(true));
                    throw new UnknownCompletedTransactionException(lockingTx.getId(), "Transaction must have completed since the old copy of the image is missing");
                }
                return new GetItemResult().withItem(oldItem);
            }
            catch (UnknownCompletedTransactionException e) {
                continue;
            }
            catch (TransactionNotFoundException e) {
                request.setConsistentRead(Boolean.valueOf(true));
            }
        }
        throw new TransactionException(null, "Ran out of attempts to get a committed image of the item");
    }

    public static void stripSpecialAttributes(Map<String, AttributeValue> item) {
        if (item == null) {
            return;
        }
        for (String specialAttribute : SPECIAL_ATTR_NAMES) {
            item.remove(specialAttribute);
        }
    }

    public static boolean isLocked(Map<String, AttributeValue> item) {
        if (item == null) {
            return false;
        }
        return item.containsKey(AttributeName.TXID.toString());
    }

    public static boolean isApplied(Map<String, AttributeValue> item) {
        if (item == null) {
            return false;
        }
        return item.containsKey(AttributeName.APPLIED.toString());
    }

    public static boolean isTransient(Map<String, AttributeValue> item) {
        if (item == null) {
            return false;
        }
        return item.containsKey(AttributeName.TRANSIENT.toString());
    }

    public boolean delete() throws TransactionException {
        return this.deleteIfAfter(null);
    }

    public boolean delete(long deleteIfAfterMillis) throws TransactionException {
        return this.deleteIfAfter(deleteIfAfterMillis);
    }

    private synchronized boolean deleteIfAfter(Long deleteIfAfterMillis) throws TransactionException {
        if (!this.txItem.isCompleted()) {
            try {
                this.txItem = new TransactionItem(this.txId, this.txManager, false);
            }
            catch (TransactionNotFoundException e) {
                return true;
            }
            if (!this.txItem.isCompleted()) {
                throw new TransactionException(this.txId, "You can only delete a transaction that is completed");
            }
        }
        try {
            if (deleteIfAfterMillis == null || this.txItem.getLastUpdateTimeMillis() + deleteIfAfterMillis < System.currentTimeMillis()) {
                this.txItem.delete();
                return true;
            }
        }
        catch (ConditionalCheckFailedException e) {
            try {
                this.txItem = new TransactionItem(this.txId, this.txManager, false);
                throw new TransactionException(this.txId, "Transaction was completed but could not be deleted. " + this.txItem);
            }
            catch (TransactionNotFoundException tnfe) {
                return true;
            }
        }
        return false;
    }

    public void sweep(long rollbackAfterDurationMills, long deleteAfterDurationMillis) {
        if (this.txItem.isCompleted()) {
            this.delete(deleteAfterDurationMillis);
        } else {
            switch (this.txItem.getState()) {
                case PENDING: {
                    if (this.txItem.getLastUpdateTimeMillis() + rollbackAfterDurationMills >= System.currentTimeMillis()) break;
                    try {
                        this.rollback();
                    }
                    catch (TransactionCompletedException e) {}
                    break;
                }
                case COMMITTED: 
                case ROLLED_BACK: {
                    try {
                        this.rollback();
                    }
                    catch (TransactionCompletedException e) {}
                    break;
                }
                default: {
                    throw new TransactionAssertionException(this.txId, "Unexpected state in transaction: " + (Object)((Object)this.txItem.getState()));
                }
            }
        }
    }

    protected synchronized Map<String, AttributeValue> driveRequest(Request clientRequest) throws DuplicateRequestException, ItemNotLockedException, TransactionException {
        clientRequest.validate(this.txId, this.txManager);
        Request requestCopy = Request.deserialize(this.txId, Request.serialize(this.txId, clientRequest));
        ItemNotLockedException lastConflict = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Map<String, AttributeValue> item = this.addRequest(requestCopy, i != 0, 2);
                return item;
            }
            catch (ItemNotLockedException e) {
                lastConflict = e;
                Transaction conflictingTransaction = null;
                try {
                    conflictingTransaction = new Transaction(e.getLockOwnerTxId(), this.txManager, false);
                    conflictingTransaction.rollback();
                }
                catch (TransactionNotFoundException tnfe) {
                }
                catch (TransactionCompletedException completedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw lastConflict;
    }

    public synchronized void commit() throws TransactionRolledBackException, UnknownCompletedTransactionException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.txItem = new TransactionItem(this.txId, this.txManager, false);
            }
            catch (TransactionNotFoundException tnfe) {
                throw new UnknownCompletedTransactionException(this.txId, "In transaction " + (Object)((Object)TransactionItem.State.COMMITTED) + " attempt, transaction either rolled back or committed");
            }
            if (this.txItem.isCompleted()) {
                if (TransactionItem.State.COMMITTED.equals((Object)this.txItem.getState())) {
                    return;
                }
                if (TransactionItem.State.ROLLED_BACK.equals((Object)this.txItem.getState())) {
                    throw new TransactionRolledBackException(this.txId, "Transaction was rolled back");
                }
                throw new TransactionAssertionException(this.txId, "Unexpected state for transaction: " + (Object)((Object)this.txItem.getState()));
            }
            if (TransactionItem.State.COMMITTED.equals((Object)this.txItem.getState())) {
                this.doCommit();
                return;
            }
            if (TransactionItem.State.ROLLED_BACK.equals((Object)this.txItem.getState())) {
                this.doRollback();
                throw new TransactionRolledBackException(this.txId, "Transaction was rolled back");
            }
            if (i >= 2) {
                throw new TransactionException(this.txId, "Unable to commit transaction after 2 attempts");
            }
            int version = this.txItem.getVersion();
            this.verifyLocks();
            try {
                this.txItem.finish(TransactionItem.State.COMMITTED, version);
                continue;
            }
            catch (ConditionalCheckFailedException conditionalCheckFailedException) {
                // empty catch block
            }
        }
        throw new TransactionException(this.txId, "Unable to commit transaction after 2 attempts");
    }

    public synchronized void rollback() throws TransactionCompletedException, UnknownCompletedTransactionException {
        TransactionItem.State state = null;
        try {
            this.txItem.finish(TransactionItem.State.ROLLED_BACK, null);
            state = TransactionItem.State.ROLLED_BACK;
        }
        catch (ConditionalCheckFailedException e) {
            try {
                this.txItem = new TransactionItem(this.txId, this.txManager, false);
                state = this.txItem.getState();
            }
            catch (TransactionNotFoundException tnfe) {
                throw new UnknownCompletedTransactionException(this.txId, "In transaction " + (Object)((Object)TransactionItem.State.ROLLED_BACK) + " attempt, transaction either rolled back or committed");
            }
        }
        if (TransactionItem.State.COMMITTED.equals((Object)state)) {
            if (!this.txItem.isCompleted()) {
                this.doCommit();
            }
            throw new TransactionCommittedException(this.txId, "Transaction was committed");
        }
        if (TransactionItem.State.ROLLED_BACK.equals((Object)state)) {
            if (!this.txItem.isCompleted()) {
                this.doRollback();
            }
            return;
        }
        throw new TransactionAssertionException(this.txId, "Unexpected state in rollback(): " + (Object)((Object)state));
    }

    protected void verifyLocks() {
        for (Request request : this.txItem.getRequests()) {
            if (this.fullyAppliedRequests.contains(request.getRid())) continue;
            this.addRequest(request, true, 3);
        }
    }

    protected void complete(TransactionItem.State expectedCurrentState) {
        try {
            this.txItem.complete(expectedCurrentState);
        }
        catch (ConditionalCheckFailedException e) {
            try {
                this.txItem = new TransactionItem(this.txId, this.txManager, false);
                if (!this.txItem.isCompleted()) {
                    throw new TransactionAssertionException(this.txId, "Expected the transaction to be completed (no item), but there was one.");
                }
            }
            catch (TransactionNotFoundException transactionNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void doCommit() {
        TransactionAssertionException.txAssert(this.txItem != null && TransactionItem.State.COMMITTED.equals((Object)this.txItem.getState()), this.txId, "doCommit() requires a non-null txItem with a state of " + (Object)((Object)TransactionItem.State.COMMITTED), new Object[]{"state", this.txItem.getState(), "txItem", this.txItem});
        for (Request request : this.txItem.getRequests()) {
            this.unlockItemAfterCommit(request);
        }
        for (Request request : this.txItem.getRequests()) {
            this.txItem.deleteItemImage(request.getRid());
        }
        this.complete(TransactionItem.State.COMMITTED);
    }

    protected void unlockItemAfterCommit(Request request) {
        block5: {
            try {
                HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
                expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(this.txId)));
                if (request instanceof Request.PutItem || request instanceof Request.UpdateItem) {
                    HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
                    updates.put(AttributeName.TXID.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
                    updates.put(AttributeName.TRANSIENT.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
                    updates.put(AttributeName.APPLIED.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
                    updates.put(AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
                    UpdateItemRequest update = new UpdateItemRequest().withTableName(request.getTableName()).withKey(request.getKey(this.txManager)).withAttributeUpdates(updates).withExpected(expected);
                    this.txManager.getClient().updateItem(update);
                    break block5;
                }
                if (request instanceof Request.DeleteItem) {
                    DeleteItemRequest delete = new DeleteItemRequest().withTableName(request.getTableName()).withKey(request.getKey(this.txManager)).withExpected(expected);
                    this.txManager.getClient().deleteItem(delete);
                    break block5;
                }
                if (request instanceof Request.GetItem) {
                    this.releaseReadLock(request.getTableName(), request.getKey(this.txManager));
                    break block5;
                }
                throw new TransactionAssertionException(this.txId, "Unknown request type: " + request.getClass());
            }
            catch (ConditionalCheckFailedException conditionalCheckFailedException) {
                // empty catch block
            }
        }
    }

    protected void doRollback() {
        TransactionAssertionException.txAssert(TransactionItem.State.ROLLED_BACK.equals((Object)this.txItem.getState()), this.txId, "Transaction state is not " + (Object)((Object)TransactionItem.State.ROLLED_BACK), new Object[]{"state", this.txItem.getState(), "txItem", this.txItem});
        for (Request request : this.txItem.getRequests()) {
            this.rollbackItemAndReleaseLock(request);
            this.txItem.deleteItemImage(request.getRid());
        }
        this.complete(TransactionItem.State.ROLLED_BACK);
    }

    protected void rollbackItemAndReleaseLock(Request request) {
        this.rollbackItemAndReleaseLock(request.getTableName(), request.getKey(this.txManager), request instanceof Request.GetItem, request.getRid());
    }

    protected void rollbackItemAndReleaseLock(String tableName, Map<String, AttributeValue> key, Boolean isGet, Integer rid) {
        if (isGet != null && isGet.booleanValue()) {
            this.releaseReadLock(tableName, key);
            return;
        }
        Map<String, AttributeValue> itemImage = null;
        if (rid != null) {
            itemImage = this.txItem.loadItemImage(rid);
        }
        if (itemImage != null) {
            TransactionAssertionException.txAssert(itemImage.remove(AttributeName.TRANSIENT.toString()) == null, this.txId, "Didn't expect to have saved an item image for a transient item", "itemImage", itemImage);
            itemImage.remove(AttributeName.TXID.toString());
            itemImage.remove(AttributeName.DATE.toString());
            TransactionAssertionException.txAssert(!itemImage.containsKey(AttributeName.APPLIED.toString()), this.txId, "Old item image should not have contained the attribute " + AttributeName.APPLIED.toString(), "itemImage", itemImage);
            try {
                HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
                expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(this.txId)));
                PutItemRequest put = new PutItemRequest().withTableName(tableName).withItem(itemImage).withExpected(expected);
                this.txManager.getClient().putItem(put);
            }
            catch (ConditionalCheckFailedException e) {}
        } else {
            try {
                HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
                expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(this.txId)));
                expected.put(AttributeName.TRANSIENT.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(BOOLEAN_TRUE_ATTR_VAL)));
                DeleteItemRequest delete = new DeleteItemRequest().withTableName(tableName).withKey(key).withExpected(expected);
                this.txManager.getClient().deleteItem(delete);
                return;
            }
            catch (ConditionalCheckFailedException e) {
                Map<String, AttributeValue> item = this.getItem(tableName, key);
                if (item == null || !this.txId.equals(Transaction.getOwner(item))) {
                    return;
                }
                TransactionAssertionException.txAssert(!item.containsKey(AttributeName.APPLIED.toString()), this.txId, "Applied change to item but didn't save a backup", "table", tableName, "key", key, "item" + item);
                this.releaseReadLock(tableName, key);
            }
        }
    }

    protected void releaseReadLock(String tableName, Map<String, AttributeValue> key) {
        Transaction.releaseReadLock(this.txId, this.txManager, tableName, key);
    }

    protected static void releaseReadLock(String txId, TransactionManager txManager, String tableName, Map<String, AttributeValue> key) {
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
        expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(txId)));
        expected.put(AttributeName.TRANSIENT.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        expected.put(AttributeName.APPLIED.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        try {
            HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>(1);
            updates.put(AttributeName.TXID.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
            updates.put(AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.DELETE));
            UpdateItemRequest update = new UpdateItemRequest().withTableName(tableName).withAttributeUpdates(updates).withKey(key).withExpected(expected);
            txManager.getClient().updateItem(update);
        }
        catch (ConditionalCheckFailedException e) {
            try {
                expected.put(AttributeName.TRANSIENT.toString(), new ExpectedAttributeValue().withValue(new AttributeValue().withS(BOOLEAN_TRUE_ATTR_VAL)));
                DeleteItemRequest delete = new DeleteItemRequest().withTableName(tableName).withKey(key).withExpected(expected);
                txManager.getClient().deleteItem(delete);
            }
            catch (ConditionalCheckFailedException e1) {
                Map<String, AttributeValue> item = Transaction.getItem(txManager, tableName, key);
                TransactionAssertionException.txAssert(item == null || !txId.equals(Transaction.getOwner(item)) || !item.containsKey(AttributeName.APPLIED.toString()), "Item should not have been applied.  Unable to release lock", "item", item);
            }
        }
    }

    protected static void unlockItemUnsafe(TransactionManager txManager, String tableName, Map<String, AttributeValue> item, String txId) {
        try {
            Transaction tx = new Transaction(txId, txManager, false);
            throw new TransactionException(txId, "The transaction item should not have existed, but it did.  You can only unsafely unlock an item without a tx record. txItem: " + tx.txItem);
        }
        catch (TransactionNotFoundException e) {
            HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
            expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(txId)));
            HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>(1);
            for (String attrName : SPECIAL_ATTR_NAMES) {
                updates.put(attrName, new AttributeValueUpdate().withAction(AttributeAction.DELETE));
            }
            Map<String, AttributeValue> key = Request.getKeyFromItem(tableName, item, txManager);
            UpdateItemRequest update = new UpdateItemRequest().withTableName(tableName).withAttributeUpdates(updates).withKey(key).withExpected(expected);
            try {
                txManager.getClient().updateItem(update);
            }
            catch (ConditionalCheckFailedException e2) {
                // empty catch block
            }
            return;
        }
    }

    protected Map<String, AttributeValue> addRequest(Request callerRequest, boolean isRedrive, int numAttempts) throws DuplicateRequestException, ItemNotLockedException, TransactionCompletedException, TransactionNotFoundException, TransactionException {
        if (!isRedrive) {
            boolean success = false;
            for (int i = 0; i < numAttempts; ++i) {
                this.verifyLocks();
                try {
                    this.txItem.addRequest(callerRequest);
                    success = true;
                    break;
                }
                catch (ConditionalCheckFailedException e) {
                    this.txItem = new TransactionItem(this.txId, this.txManager, false);
                    if (TransactionItem.State.COMMITTED.equals((Object)this.txItem.getState())) {
                        throw new TransactionCommittedException(this.txId, "Attempted to add a request to a transaction that was not in state " + (Object)((Object)TransactionItem.State.PENDING) + ", state is " + (Object)((Object)this.txItem.getState()));
                    }
                    if (TransactionItem.State.ROLLED_BACK.equals((Object)this.txItem.getState())) {
                        throw new TransactionRolledBackException(this.txId, "Attempted to add a request to a transaction that was not in state " + (Object)((Object)TransactionItem.State.PENDING) + ", state is " + (Object)((Object)this.txItem.getState()));
                    }
                    if (TransactionItem.State.PENDING.equals((Object)this.txItem.getState())) continue;
                    throw new UnknownCompletedTransactionException(this.txId, "Attempted to add a request to a transaction that was not in state " + (Object)((Object)TransactionItem.State.PENDING) + ", state is " + (Object)((Object)this.txItem.getState()));
                }
            }
            if (!success) {
                throw new TransactionException(this.txId, "Unable to add request to transaction - too much contention for the tx record");
            }
        } else {
            TransactionAssertionException.txAssert(TransactionItem.State.PENDING.equals((Object)this.txItem.getState()), this.txId, "Attempted to add a request to a transaction that was not in state " + (Object)((Object)TransactionItem.State.PENDING), new Object[]{"state", this.txItem.getState()});
        }
        Map<String, AttributeValue> item = this.lockItem(callerRequest, true, 3);
        this.saveItemImage(callerRequest, item);
        try {
            this.txItem = new TransactionItem(this.txId, this.txManager, false);
        }
        catch (TransactionNotFoundException e) {
            this.releaseReadLock(callerRequest.getTableName(), callerRequest.getKey(this.txManager));
            throw e;
        }
        switch (this.txItem.getState()) {
            case COMMITTED: {
                this.doCommit();
                throw new TransactionCommittedException(this.txId, "The transaction already committed");
            }
            case ROLLED_BACK: {
                this.doRollback();
                throw new TransactionRolledBackException(this.txId, "The transaction already rolled back");
            }
            case PENDING: {
                break;
            }
            default: {
                throw new TransactionException(this.txId, "Unexpected state " + (Object)((Object)this.txItem.getState()));
            }
        }
        Map<String, AttributeValue> returnItem = this.applyAndKeepLock(callerRequest, item);
        if (callerRequest.getRid() != null) {
            this.fullyAppliedRequests.add(callerRequest.getRid());
        }
        return returnItem;
    }

    protected void saveItemImage(Request callerRequest, Map<String, AttributeValue> item) {
        if (this.isRequestSaveable(callerRequest, item) && !item.containsKey(AttributeName.APPLIED.toString())) {
            this.txItem.saveItemImage(item, callerRequest.getRid());
        }
    }

    protected boolean isRequestSaveable(Request callerRequest, Map<String, AttributeValue> item) {
        return !(callerRequest instanceof Request.GetItem) && !item.containsKey(AttributeName.TRANSIENT.toString());
    }

    protected Map<String, AttributeValue> lockItem(Request callerRequest, boolean expectExists, int attempts) throws ItemNotLockedException, TransactionException {
        Map<String, ExpectedAttributeValue> expected;
        Map<String, AttributeValue> key = callerRequest.getKey(this.txManager);
        if (attempts <= 0) {
            throw new TransactionException(this.txId, "Unable to acquire item lock for item " + key);
        }
        HashMap<String, AttributeValueUpdate> updates = new HashMap<String, AttributeValueUpdate>();
        updates.put(AttributeName.TXID.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue(this.txId)));
        updates.put(AttributeName.DATE.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(this.txManager.getCurrentTimeAttribute()));
        if (expectExists) {
            expected = callerRequest.getExpectExists(this.txManager);
            expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        } else {
            expected = new HashMap<String, ExpectedAttributeValue>(1);
            updates.put(AttributeName.TRANSIENT.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withS(BOOLEAN_TRUE_ATTR_VAL)));
        }
        expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        UpdateItemRequest updateRequest = new UpdateItemRequest().withTableName(callerRequest.getTableName()).withExpected(expected).withKey(key).withReturnValues(ReturnValue.ALL_NEW).withAttributeUpdates(updates);
        String owner = null;
        boolean nextExpectExists = false;
        Map<String, AttributeValue> item = null;
        try {
            item = this.txManager.getClient().updateItem(updateRequest).getAttributes();
            owner = Transaction.getOwner(item);
        }
        catch (ConditionalCheckFailedException e) {
            item = this.getItem(callerRequest.getTableName(), key);
            if (item == null) {
                nextExpectExists = false;
            }
            nextExpectExists = true;
            owner = Transaction.getOwner(item);
        }
        if (owner != null) {
            if (this.txId.equals(owner)) {
                return item;
            }
            if (attempts > 1) {
                try {
                    Transaction otherTransaction = this.txManager.resumeTransaction(owner);
                    otherTransaction.rollback();
                }
                catch (TransactionCompletedException e) {
                }
                catch (TransactionNotFoundException e) {
                    Transaction.releaseReadLock(owner, this.txManager, callerRequest.getTableName(), key);
                }
            } else {
                throw new ItemNotLockedException(this.txId, owner, callerRequest.getTableName(), key);
            }
        }
        return this.lockItem(callerRequest, nextExpectExists, attempts - 1);
    }

    protected Map<String, AttributeValue> applyAndKeepLock(Request request, Map<String, AttributeValue> lockedItem) {
        Map<String, AttributeValue> returnItem = null;
        String returnValues = request.getReturnValues();
        if (returnValues == null) {
            returnValues = "NONE";
        }
        if (!lockedItem.containsKey(AttributeName.APPLIED.toString())) {
            try {
                HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
                expected.put(AttributeName.TXID.toString(), new ExpectedAttributeValue().withValue(new AttributeValue(this.txId)));
                expected.put(AttributeName.APPLIED.toString(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
                if (request instanceof Request.PutItem) {
                    PutItemRequest put = ((Request.PutItem)request).getRequest();
                    put.getItem().put(AttributeName.TXID.toString(), new AttributeValue(this.txId));
                    put.getItem().put(AttributeName.APPLIED.toString(), new AttributeValue(BOOLEAN_TRUE_ATTR_VAL));
                    if (lockedItem.containsKey(AttributeName.TRANSIENT.toString())) {
                        put.getItem().put(AttributeName.TRANSIENT.toString(), lockedItem.get(AttributeName.TRANSIENT.toString()));
                    }
                    put.getItem().put(AttributeName.DATE.toString(), lockedItem.get(AttributeName.DATE.toString()));
                    put.setExpected(expected);
                    put.setReturnValues(returnValues);
                    returnItem = this.txManager.getClient().putItem(put).getAttributes();
                } else if (request instanceof Request.UpdateItem) {
                    UpdateItemRequest update = ((Request.UpdateItem)request).getRequest();
                    update.setExpected(expected);
                    update.setReturnValues(returnValues);
                    if (update.getAttributeUpdates() != null) {
                        update.getAttributeUpdates().remove(AttributeName.TXID.toString());
                        update.getAttributeUpdates().remove(AttributeName.TRANSIENT.toString());
                        update.getAttributeUpdates().remove(AttributeName.DATE.toString());
                    } else {
                        update.setAttributeUpdates(new HashMap(1));
                    }
                    update.getAttributeUpdates().put(AttributeName.APPLIED.toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue(BOOLEAN_TRUE_ATTR_VAL)));
                    returnItem = this.txManager.getClient().updateItem(update).getAttributes();
                } else if (!(request instanceof Request.DeleteItem) && !(request instanceof Request.GetItem)) {
                    throw new TransactionAssertionException(this.txId, "Request may not be null");
                }
            }
            catch (ConditionalCheckFailedException e) {
                // empty catch block
            }
        }
        if ("ALL_OLD".equals(returnValues) && Transaction.isTransient(lockedItem)) {
            return null;
        }
        if (request instanceof Request.GetItem) {
            GetItemRequest getRequest = ((Request.GetItem)request).getRequest();
            Request lockingRequest = this.txItem.getRequestForKey(request.getTableName(), request.getKey(this.txManager));
            if (lockingRequest instanceof Request.DeleteItem) {
                return null;
            }
            if (lockingRequest instanceof Request.GetItem && Transaction.isTransient(lockedItem)) {
                return null;
            }
            if (getRequest.getAttributesToGet() != null) {
                HashSet attributesToGet = new HashSet(getRequest.getAttributesToGet());
                Iterator<Map.Entry<String, AttributeValue>> it = lockedItem.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, AttributeValue> attr = it.next();
                    if (attributesToGet.contains(attr.getKey())) continue;
                    it.remove();
                }
            }
            return lockedItem;
        }
        if (request instanceof Request.DeleteItem) {
            if ("ALL_OLD".equals(returnValues)) {
                return lockedItem;
            }
            return null;
        }
        if ("ALL_OLD".equals(returnValues)) {
            if (returnItem != null) {
                return returnItem;
            }
            returnItem = this.txItem.loadItemImage(request.getRid());
            if (returnItem == null) {
                throw new UnknownCompletedTransactionException(this.txId, "Transaction must have completed since the old copy of the image is missing");
            }
            return returnItem;
        }
        if ("ALL_NEW".equals(returnValues)) {
            if (returnItem != null) {
                return returnItem;
            }
            returnItem = this.getItem(request.getTableName(), request.getKey(this.txManager));
            if (returnItem == null) {
                throw new UnknownCompletedTransactionException(this.txId, "Transaction must have completed since the item no longer exists");
            }
            String owner = Transaction.getOwner(returnItem);
            if (!this.txId.equals(owner)) {
                throw new ItemNotLockedException(this.txId, owner, request.getTableName(), returnItem);
            }
            return returnItem;
        }
        if ("NONE".equals(returnValues)) {
            return null;
        }
        throw new TransactionAssertionException(this.txId, "Unsupported return values: " + returnValues);
    }

    protected Map<String, AttributeValue> getItem(String tableName, Map<String, AttributeValue> key) {
        return Transaction.getItem(this.txManager, tableName, key);
    }

    protected static Map<String, AttributeValue> getItem(TransactionManager txManager, String tableName, Map<String, AttributeValue> key) {
        GetItemRequest getRequest = new GetItemRequest().withTableName(tableName).withConsistentRead(Boolean.valueOf(true)).withKey(key);
        GetItemResult getResult = txManager.getClient().getItem(getRequest);
        return getResult.getItem();
    }

    protected static String getOwner(Map<String, AttributeValue> item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        AttributeValue itemTxId = item.get(AttributeName.TXID.toString());
        if (itemTxId != null && itemTxId.getS() != null) {
            return itemTxId.getS();
        }
        return null;
    }

    protected TransactionItem getTxItem() {
        return this.txItem;
    }

    public <T> void delete(final T item) {
        this.doWithMapper(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Transaction.this.txManager.getClientMapper().delete(item);
                return null;
            }
        });
    }

    public <T> T load(final T item) {
        return this.doWithMapper(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Transaction.this.txManager.getClientMapper().load(item);
            }
        });
    }

    public <T> void save(final T item) {
        this.doWithMapper(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Transaction.this.txManager.getClientMapper().save(item);
                return null;
            }
        });
    }

    private <T> T doWithMapper(Callable<T> callable) {
        try {
            this.txManager.getFacadeProxy().setBackend(new TransactionDynamoDBFacade(this, this.txManager));
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.txManager.getFacadeProxy().setBackend(null);
        }
    }

    static {
        HashSet<String> names = new HashSet<String>(AttributeName.values().length);
        for (AttributeName name : AttributeName.values()) {
            names.add(name.toString());
        }
        SPECIAL_ATTR_NAMES = Collections.unmodifiableSet(names);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeName {
        TXID("_TxId"),
        TRANSIENT("_TxT"),
        DATE("_TxD"),
        APPLIED("_TxA"),
        REQUESTS("_TxR"),
        STATE("_TxS"),
        VERSION("_TxV"),
        FINALIZED("_TxF"),
        IMAGE_ID("_TxI");

        private final String value;

        private AttributeName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IsolationLevel {
        UNCOMMITTED,
        COMMITTED,
        READ_LOCK;

    }
}

