/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.manage.impl;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.google.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.dynamo.db.lib.manage.AppDynamoDBClient;
import ru.quadcom.dynamo.db.lib.manage.interfaces.IPutGetDeleteDynamoDBService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutGetDeleteDynamoDBService
implements IPutGetDeleteDynamoDBService {
    private static final Logger logger = LoggerFactory.getLogger(PutGetDeleteDynamoDBService.class);
    private final AppDynamoDBClient dbClient;

    @Inject
    public PutGetDeleteDynamoDBService(AppDynamoDBClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public Map<String, AttributeValue> deleteItemAndReturnOldOne(DeleteItemRequest deleteItemRequest) {
        String finalTableName = deleteItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("deleteItemAndReturnOldOne : from {}", (Object)finalTableName);
        deleteItemRequest = deleteItemRequest.withTableName(finalTableName).withReturnValues(ReturnValue.ALL_OLD);
        return this.dbClient.deleteItem(deleteItemRequest).getAttributes();
    }

    @Override
    public Map<String, AttributeValue> putItemAndReturnOldOne(PutItemRequest putItemRequest) {
        String finalTableName = putItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("putItemAndReturnOldOne : from {}", (Object)finalTableName);
        putItemRequest = putItemRequest.withTableName(finalTableName).withReturnValues(ReturnValue.ALL_OLD);
        return this.dbClient.putItem(putItemRequest).getAttributes();
    }

    @Override
    public Map<String, AttributeValue> updateItemAndReturnOldOne(UpdateItemRequest updateItemRequest) {
        String finalTableName = updateItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("updateItemAndReturnOldOne : from {}", (Object)finalTableName);
        updateItemRequest = updateItemRequest.withTableName(finalTableName).withReturnValues(ReturnValue.ALL_OLD);
        return this.dbClient.updateItem(updateItemRequest).getAttributes();
    }

    @Override
    public Map<String, AttributeValue> updateItemAndReturnNewOne(UpdateItemRequest updateItemRequest) {
        String finalTableName = updateItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("updateItemAndReturnNewOne : from {}", (Object)finalTableName);
        updateItemRequest = updateItemRequest.withTableName(finalTableName).withReturnValues(ReturnValue.ALL_NEW);
        return this.dbClient.updateItem(updateItemRequest).getAttributes();
    }

    @Override
    public Map<String, AttributeValue> getItem(GetItemRequest getItemRequest) {
        String finalTableName = getItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("getItem : from {}", (Object)finalTableName);
        getItemRequest = getItemRequest.withTableName(finalTableName);
        return this.dbClient.getItem(getItemRequest).getItem();
    }

    @Override
    public Map<String, AttributeValue> getItemWithStrongConsistency(GetItemRequest getItemRequest) {
        String finalTableName = getItemRequest.getTableName().concat("-").concat(this.dbClient.getNameOfDatabase());
        logger.info("getItemWithStrongConsistency : from {}", (Object)finalTableName);
        getItemRequest = getItemRequest.withTableName(finalTableName).withConsistentRead(Boolean.valueOf(true));
        return this.dbClient.getItem(getItemRequest).getItem();
    }
}

