/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import ru.quadcom.dynamo.db.lib.transactions.Request;
import ru.quadcom.dynamo.db.lib.transactions.Transaction;
import ru.quadcom.dynamo.db.lib.transactions.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionDynamoDBFacade
implements AmazonDynamoDB {
    private final Transaction txn;
    private final TransactionManager txManager;

    public TransactionDynamoDBFacade(Transaction txn, TransactionManager txManager) {
        this.txn = txn;
        this.txManager = txManager;
    }

    public DeleteItemResult deleteItem(DeleteItemRequest request) throws AmazonServiceException, AmazonClientException {
        Map expectedValues = request.getExpected();
        this.checkExpectedValues(request.getTableName(), request.getKey(), expectedValues);
        request.setExpected(null);
        return this.txn.deleteItem(request);
    }

    public GetItemResult getItem(GetItemRequest request) throws AmazonServiceException, AmazonClientException {
        return this.txn.getItem(request);
    }

    public PutItemResult putItem(PutItemRequest request) throws AmazonServiceException, AmazonClientException {
        Map expectedValues = request.getExpected();
        this.checkExpectedValues(request.getTableName(), Request.getKeyFromItem(request.getTableName(), request.getItem(), this.txManager), expectedValues);
        request.setExpected(null);
        return this.txn.putItem(request);
    }

    public UpdateItemResult updateItem(UpdateItemRequest request) throws AmazonServiceException, AmazonClientException {
        Map expectedValues = request.getExpected();
        this.checkExpectedValues(request.getTableName(), request.getKey(), expectedValues);
        request.setExpected(null);
        return this.txn.updateItem(request);
    }

    private void checkExpectedValues(String tableName, Map<String, AttributeValue> itemKey, Map<String, ExpectedAttributeValue> expectedValues) {
        if (expectedValues != null && !expectedValues.isEmpty()) {
            for (Map.Entry<String, ExpectedAttributeValue> entry : expectedValues.entrySet()) {
                if (entry.getValue().isExists() != null && !entry.getValue().isExists().booleanValue() || entry.getValue().getValue() != null) continue;
                throw new IllegalArgumentException("An explicit value is required when Exists is null or true, but none was found in expected values for item with key " + itemKey + ": " + expectedValues);
            }
            GetItemResult result = this.getItem(new GetItemRequest().withAttributesToGet(expectedValues.keySet()).withKey(itemKey).withTableName(tableName));
            Map item = result.getItem();
            try {
                TransactionDynamoDBFacade.checkExpectedValues(expectedValues, item);
            }
            catch (ConditionalCheckFailedException e) {
                throw new ConditionalCheckFailedException("Item " + itemKey + " had unexpected attributes: " + e.getMessage());
            }
        }
    }

    public static void checkExpectedValues(Map<String, ExpectedAttributeValue> expectedValues, Map<String, AttributeValue> item) {
        for (Map.Entry<String, ExpectedAttributeValue> entry : expectedValues.entrySet()) {
            if (!(entry.getValue().isExists() != null && !entry.getValue().isExists().booleanValue() || item != null && item.get(entry.getKey()) != null && TransactionDynamoDBFacade.expectedValueMatches(entry.getValue().getValue(), item.get(entry.getKey())))) {
                throw new ConditionalCheckFailedException("expected attribute(s) " + expectedValues + " but found " + item);
            }
            if (entry.getValue().isExists() == null || entry.getValue().isExists().booleanValue() || item == null || item.get(entry.getKey()) == null) continue;
            throw new ConditionalCheckFailedException("expected attribute(s) " + expectedValues + " but found " + item);
        }
    }

    private static boolean expectedValueMatches(AttributeValue expected, AttributeValue actual) {
        if (expected.getN() != null) {
            return actual.getN() != null && new BigDecimal(expected.getN()).compareTo(new BigDecimal(actual.getN())) == 0;
        }
        if (expected.getS() != null || expected.getB() != null) {
            return expected.equals((Object)actual);
        }
        throw new IllegalArgumentException("Expect condition using unsupported value type: " + expected);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public CreateTableResult createTable(CreateTableRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public DeleteTableResult deleteTable(DeleteTableRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public DescribeTableResult describeTable(DescribeTableRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest arg0) {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ListTablesResult listTables(ListTablesRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public QueryResult query(QueryRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ScanResult scan(ScanRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public void setEndpoint(String arg0) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public void setRegion(Region arg0) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public UpdateTableResult updateTable(UpdateTableRequest arg0) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ScanResult scan(String tableName, List<String> attributesToGet) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ScanResult scan(String tableName, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ScanResult scan(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public UpdateTableResult updateTable(String tableName, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public DeleteTableResult deleteTable(String tableName) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> requestItems) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public DescribeTableResult describeTable(String tableName) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        return this.getItem(new GetItemRequest().withTableName(tableName).withKey(key));
    }

    public GetItemResult getItem(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) throws AmazonServiceException, AmazonClientException {
        return this.getItem(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead));
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key) throws AmazonServiceException, AmazonClientException {
        return this.deleteItem(new DeleteItemRequest().withTableName(tableName).withKey(key));
    }

    public DeleteItemResult deleteItem(String tableName, Map<String, AttributeValue> key, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.deleteItem(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues));
    }

    public CreateTableResult createTable(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item) throws AmazonServiceException, AmazonClientException {
        return this.putItem(new PutItemRequest().withTableName(tableName).withItem(item));
    }

    public PutItemResult putItem(String tableName, Map<String, AttributeValue> item, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.putItem(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues));
    }

    public ListTablesResult listTables(String exclusiveStartTableName) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ListTablesResult listTables(String exclusiveStartTableName, Integer limit) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public ListTablesResult listTables(Integer limit) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) throws AmazonServiceException, AmazonClientException {
        return this.updateItem(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates));
    }

    public UpdateItemResult updateItem(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) throws AmazonServiceException, AmazonClientException {
        return this.updateItem(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues));
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> requestItems) throws AmazonServiceException, AmazonClientException {
        throw new UnsupportedOperationException("Use the underlying client instance instead");
    }
}

