/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.transactions;

import com.amazonaws.RequestClientOptions;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.quadcom.dynamo.db.lib.exceptions.InvalidRequestException;
import ru.quadcom.dynamo.db.lib.exceptions.TransactionAssertionException;
import ru.quadcom.dynamo.db.lib.transactions.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PutItem.class, name="PutItem"), @JsonSubTypes.Type(value=UpdateItem.class, name="UpdateItem"), @JsonSubTypes.Type(value=DeleteItem.class, name="DeleteItem"), @JsonSubTypes.Type(value=GetItem.class, name="GetItem")})
public abstract class Request {
    private static final Set<String> VALID_RETURN_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ALL_OLD", "ALL_NEW", "NONE")));
    private Integer rid;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @JsonIgnore
    protected abstract String getTableName();

    @JsonIgnore
    protected abstract Map<String, AttributeValue> getKey(TransactionManager var1);

    @JsonIgnore
    protected abstract String getReturnValues();

    @JsonIgnore
    protected abstract void doValidate(String var1, TransactionManager var2);

    public Integer getRid() {
        return this.rid;
    }

    public void setRid(Integer rid) {
        this.rid = rid;
    }

    @JsonIgnore
    public void validate(String txId, TransactionManager txManager) {
        if (this.getTableName() == null) {
            throw new InvalidRequestException("TableName must not be null", txId, null, null, this);
        }
        Map<String, AttributeValue> key = this.getKey(txManager);
        if (key == null || key.isEmpty()) {
            throw new InvalidRequestException("The request key cannot be empty", txId, this.getTableName(), key, this);
        }
        Request.validateReturnValues(this.getReturnValues(), txId, this);
        this.doValidate(txId, txManager);
    }

    private static void validateReturnValues(String returnValues, String txId, Request request) {
        if (returnValues == null || VALID_RETURN_VALUES.contains(returnValues)) {
            return;
        }
        throw new InvalidRequestException("Unsupported ReturnValues: " + returnValues, txId, request.getTableName(), null, request);
    }

    private static void validateAttributes(Request request, Map<String, ?> attributes, String txId, TransactionManager txManager) {
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith("_Tx")) continue;
            throw new InvalidRequestException("Request must not contain the reserved attribute " + entry.getKey(), txId, request.getTableName(), request.getKey(txManager), request);
        }
    }

    private static void validateAttributes(Request request, List<String> attributes, String txId, TransactionManager txManager) {
        if (attributes == null) {
            return;
        }
        for (String attr : attributes) {
            if (!attr.startsWith("_Tx")) continue;
            throw new InvalidRequestException("Request must not contain the reserved attribute " + attr, txId, request.getTableName(), request.getKey(txManager), request);
        }
    }

    protected static Map<String, AttributeValue> getKeyFromItem(String tableName, Map<String, AttributeValue> item, TransactionManager txManager) {
        if (item == null) {
            throw new InvalidRequestException("PutItem must contain an Item", null, tableName, null, null);
        }
        HashMap<String, AttributeValue> newKey = new HashMap<String, AttributeValue>();
        List<KeySchemaElement> schema = txManager.getTableSchema(tableName);
        for (KeySchemaElement schemaElement : schema) {
            AttributeValue val = item.get(schemaElement.getAttributeName());
            if (val == null) {
                throw new InvalidRequestException("PutItem request must contain the key attribute " + schemaElement.getAttributeName(), null, tableName, null, null);
            }
            newKey.put(schemaElement.getAttributeName(), item.get(schemaElement.getAttributeName()));
        }
        return newKey;
    }

    @JsonIgnore
    protected Map<String, ExpectedAttributeValue> getExpectNotExists(TransactionManager txManager) {
        Map<String, AttributeValue> key = this.getKey(txManager);
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(key.size());
        for (Map.Entry<String, AttributeValue> entry : key.entrySet()) {
            expected.put(entry.getKey(), new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
        }
        return expected;
    }

    @JsonIgnore
    protected Map<String, ExpectedAttributeValue> getExpectExists(TransactionManager txManager) {
        Map<String, AttributeValue> key = this.getKey(txManager);
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>(key.size());
        for (Map.Entry<String, AttributeValue> entry : key.entrySet()) {
            expected.put(entry.getKey(), new ExpectedAttributeValue().withValue(entry.getValue()));
        }
        return expected;
    }

    protected static ByteBuffer serialize(String txId, Object request) {
        try {
            byte[] requestBytes = MAPPER.writeValueAsBytes(request);
            return ByteBuffer.wrap(requestBytes);
        }
        catch (JsonGenerationException e) {
            throw new TransactionAssertionException(txId, "Failed to serialize request " + request + " " + (Object)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new TransactionAssertionException(txId, "Failed to serialize request " + request + " " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new TransactionAssertionException(txId, "Failed to serialize request " + request + " " + e);
        }
    }

    protected static Request deserialize(String txId, ByteBuffer rawRequest) {
        byte[] requestBytes = rawRequest.array();
        try {
            return (Request)MAPPER.readValue(requestBytes, 0, requestBytes.length, Request.class);
        }
        catch (JsonParseException e) {
            throw new TransactionAssertionException(txId, "Failed to deserialize request " + rawRequest + " " + (Object)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new TransactionAssertionException(txId, "Failed to deserialize request " + rawRequest + " " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new TransactionAssertionException(txId, "Failed to deserialize request " + rawRequest + " " + e);
        }
    }

    static {
        MAPPER.disable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.addMixInAnnotations(GetItemRequest.class, RequestMixIn.class);
        MAPPER.addMixInAnnotations(PutItemRequest.class, RequestMixIn.class);
        MAPPER.addMixInAnnotations(UpdateItemRequest.class, RequestMixIn.class);
        MAPPER.addMixInAnnotations(DeleteItemRequest.class, RequestMixIn.class);
        MAPPER.addMixInAnnotations(AttributeValueUpdate.class, AttributeValueUpdateMixIn.class);
        SimpleModule module = new SimpleModule("custom", Version.unknownVersion());
        module.addSerializer(ByteBuffer.class, (JsonSerializer)new ByteBufferSerializer());
        module.addDeserializer(ByteBuffer.class, (JsonDeserializer)new ByteBufferDeserializer());
        MAPPER.registerModule((Module)module);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteBufferDeserializer
    extends JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ByteBuffer.wrap(jp.getBinaryValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteBufferSerializer
    extends JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        public void serialize(ByteBuffer value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeBinary(value.array());
        }
    }

    private static abstract class AttributeValueUpdateMixIn {
        private AttributeValueUpdateMixIn() {
        }

        @JsonIgnore
        public abstract void setAction(AttributeAction var1);

        @JsonProperty
        public abstract void setAction(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class RequestMixIn
    extends AmazonWebServiceRequestMixIn {
        private RequestMixIn() {
        }

        @Override
        @JsonIgnore
        public abstract String getDelegationToken();

        @Override
        @JsonIgnore
        public abstract void setDelegationToken(String var1);

        @Override
        @JsonIgnore
        public abstract void setRequestCredentials(AWSCredentials var1);

        @Override
        @JsonIgnore
        public abstract AWSCredentials getRequestCredentials();

        @Override
        @JsonIgnore
        public abstract Map<String, String> copyPrivateRequestParameters();

        @Override
        @JsonIgnore
        public abstract RequestClientOptions getRequestClientOptions();

        @JsonIgnore
        public abstract void setReturnValues(ReturnValue var1);

        @JsonProperty
        public abstract void setReturnValues(String var1);

        @JsonIgnore
        public abstract void setReturnConsumedCapacity(ReturnConsumedCapacity var1);

        @JsonProperty
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonIgnore
        public abstract void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        @JsonProperty
        public abstract void setReturnItemCollectionMetrics(String var1);

        @JsonIgnore
        public abstract boolean isConsistentRead();

        @JsonProperty
        public abstract boolean getConsistentRead();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AmazonWebServiceRequestMixIn {
        private AmazonWebServiceRequestMixIn() {
        }

        @JsonIgnore
        public abstract String getDelegationToken();

        @JsonIgnore
        public abstract void setDelegationToken(String var1);

        @JsonIgnore
        public abstract void setRequestCredentials(AWSCredentials var1);

        @JsonIgnore
        public abstract AWSCredentials getRequestCredentials();

        @JsonIgnore
        public abstract Map<String, String> copyPrivateRequestParameters();

        @JsonIgnore
        public abstract RequestClientOptions getRequestClientOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JsonTypeName(value="PutItem")
    public static class PutItem
    extends Request {
        @JsonIgnore
        private Map<String, AttributeValue> key = null;
        private PutItemRequest request;

        public PutItemRequest getRequest() {
            return this.request;
        }

        public void setRequest(PutItemRequest request) {
            this.request = request;
        }

        @Override
        protected String getTableName() {
            return this.request.getTableName();
        }

        @Override
        protected String getReturnValues() {
            return this.request.getReturnValues();
        }

        @Override
        protected Map<String, AttributeValue> getKey(TransactionManager txManager) {
            if (this.key == null) {
                this.key = PutItem.getKeyFromItem(this.getTableName(), this.request.getItem(), txManager);
            }
            return this.key;
        }

        @Override
        protected void doValidate(String txId, TransactionManager txManager) {
            if (this.request == null || this.request.getItem() == null) {
                throw new InvalidRequestException("PutItem must contain an Item", txId, this.getTableName(), null, this);
            }
            Request.validateAttributes((Request)this, this.request.getItem(), txId, txManager);
            if (this.request.getReturnConsumedCapacity() != null) {
                throw new InvalidRequestException("ReturnConsumedCapacity is not currently supported", txId, this.getTableName(), null, this);
            }
            if (this.request.getReturnItemCollectionMetrics() != null) {
                throw new InvalidRequestException("ReturnItemCollectionMetrics is not currently supported", txId, this.getTableName(), null, this);
            }
            if (this.request.getExpected() != null) {
                throw new InvalidRequestException("Requests with conditions are not currently supported", txId, this.getTableName(), this.getKey(txManager), this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JsonTypeName(value="DeleteItem")
    public static class DeleteItem
    extends Request {
        private DeleteItemRequest request;

        public DeleteItemRequest getRequest() {
            return this.request;
        }

        public void setRequest(DeleteItemRequest request) {
            this.request = request;
        }

        @Override
        protected String getTableName() {
            return this.request.getTableName();
        }

        @Override
        protected String getReturnValues() {
            return this.request.getReturnValues();
        }

        @Override
        protected Map<String, AttributeValue> getKey(TransactionManager txManager) {
            return this.request.getKey();
        }

        @Override
        protected void doValidate(String txId, TransactionManager txManager) {
            Request.validateAttributes((Request)this, this.request.getKey(), txId, txManager);
            if (this.request.getReturnConsumedCapacity() != null) {
                throw new InvalidRequestException("ReturnConsumedCapacity is not currently supported", txId, this.getTableName(), null, this);
            }
            if (this.request.getReturnItemCollectionMetrics() != null) {
                throw new InvalidRequestException("ReturnItemCollectionMetrics is not currently supported", txId, this.getTableName(), null, this);
            }
            if (this.request.getExpected() != null) {
                throw new InvalidRequestException("Requests with conditions are not currently supported", txId, this.getTableName(), this.getKey(txManager), this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JsonTypeName(value="UpdateItem")
    public static class UpdateItem
    extends Request {
        private UpdateItemRequest request;

        public UpdateItemRequest getRequest() {
            return this.request;
        }

        public void setRequest(UpdateItemRequest request) {
            this.request = request;
        }

        @Override
        protected String getTableName() {
            return this.request.getTableName();
        }

        @Override
        protected String getReturnValues() {
            return this.request.getReturnValues();
        }

        @Override
        protected Map<String, AttributeValue> getKey(TransactionManager txManager) {
            return this.request.getKey();
        }

        @Override
        protected void doValidate(String txId, TransactionManager txManager) {
            Request.validateAttributes((Request)this, this.request.getKey(), txId, txManager);
            if (this.request.getAttributeUpdates() != null) {
                Request.validateAttributes((Request)this, this.request.getAttributeUpdates(), txId, txManager);
            }
            if (this.request.getReturnConsumedCapacity() != null) {
                throw new InvalidRequestException("ReturnConsumedCapacity is not currently supported", txId, this.request.getTableName(), null, this);
            }
            if (this.request.getReturnItemCollectionMetrics() != null) {
                throw new InvalidRequestException("ReturnItemCollectionMetrics is not currently supported", txId, this.request.getTableName(), null, this);
            }
            if (this.request.getExpected() != null) {
                throw new InvalidRequestException("Requests with conditions are not currently supported", txId, this.request.getTableName(), this.getKey(txManager), this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JsonTypeName(value="GetItem")
    public static class GetItem
    extends Request {
        private GetItemRequest request;

        public GetItemRequest getRequest() {
            return this.request;
        }

        public void setRequest(GetItemRequest request) {
            this.request = request;
        }

        @Override
        protected String getTableName() {
            return this.request.getTableName();
        }

        @Override
        protected String getReturnValues() {
            return null;
        }

        @Override
        protected Map<String, AttributeValue> getKey(TransactionManager txManager) {
            return this.request.getKey();
        }

        @Override
        protected void doValidate(String txId, TransactionManager txManager) {
            Request.validateAttributes((Request)this, this.request.getKey(), txId, txManager);
            Request.validateAttributes((Request)this, this.request.getAttributesToGet(), txId, txManager);
        }
    }
}

