/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.manage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;

public class AppDynamoDBClient
extends AmazonDynamoDBClient {
    private final String nameOfDatabase;

    public AppDynamoDBClient(String nameOfDatabase, String regionName, String endPoint, int maxErrorRetry) {
        super((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider(), new ClientConfiguration().withMaxErrorRetry(maxErrorRetry));
        if (nameOfDatabase.equals("local")) {
            this.setEndpoint(endPoint);
        } else {
            Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
            this.setRegion(region);
        }
        this.nameOfDatabase = nameOfDatabase;
    }

    public AppDynamoDBClient(String nameOfDatabase, String regionName, int maxErrorRetry) {
        this(nameOfDatabase, regionName, "http://localhost:8000", maxErrorRetry);
    }

    public AppDynamoDBClient(String nameOfDatabase, String regionName, int maxErrorRetry, String filePath) {
        super((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider(filePath), new ClientConfiguration().withMaxErrorRetry(maxErrorRetry));
        if (nameOfDatabase.equals("local")) {
            this.setEndpoint("http://localhost:8000");
        } else {
            Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
            this.setRegion(region);
        }
        this.nameOfDatabase = nameOfDatabase;
    }

    public String getNameOfDatabase() {
        return this.nameOfDatabase;
    }
}

