/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.impl;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import ru.quadcom.database.lib.orchestrate.Constants;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateClient;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateGraphService;
import ru.quadcom.database.lib.orchestrate.responses.DeleteGraphResponse;
import ru.quadcom.database.lib.orchestrate.responses.GetGraphResponse;
import ru.quadcom.database.lib.orchestrate.responses.PutGraphResponse;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrateGraphService
implements IOrchestrateGraphService {
    private static final Gson gson = new Gson();
    private final IOrchestrateClient client;

    @Inject
    public OrchestrateGraphService(IOrchestrateClient client) {
        this.client = client;
    }

    @Override
    public Future<PutGraphResponse> putRelation(String collectionFrom, String keyFrom, String kind, String collectionTo, String keyTo) {
        WSRequestHolder holder = this.client.baseGraphRequestHolder(collectionFrom, keyFrom, Lists.newArrayList((Object[])new String[]{kind}), collectionTo, keyTo, true);
        return holder.put("").wrapped().flatMap((Function1)new Mapper<WSResponse, Future<PutGraphResponse>>(){

            public Future<PutGraphResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<PutGraphResponse>(){

                    @Override
                    public PutGraphResponse call() throws Exception {
                        if (response.getStatus() != 201) {
                            OrchestrateGraphService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        return new PutGraphResponse(reqId);
                    }
                }, (ExecutionContext)OrchestrateGraphService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }

    @Override
    public Future<DeleteGraphResponse> deleteRelation(String collectionFrom, String keyFrom, String kind, String collectionTo, String keyTo) {
        WSRequestHolder holder = this.client.baseGraphRequestHolder(collectionFrom, keyFrom, Lists.newArrayList((Object[])new String[]{kind}), collectionTo, keyTo, true);
        return holder.delete().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<DeleteGraphResponse>>(){

            public Future<DeleteGraphResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<DeleteGraphResponse>(){

                    @Override
                    public DeleteGraphResponse call() throws Exception {
                        if (response.getStatus() != 204) {
                            OrchestrateGraphService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        return new DeleteGraphResponse(reqId);
                    }
                }, (ExecutionContext)OrchestrateGraphService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }

    @Override
    public <T> Future<GetGraphResponse<T>> getRelated(String collectionFrom, String keyFrom, final Class<T> clazz, String ... kind) {
        WSRequestHolder holder = this.client.baseGraphRequestHolder(collectionFrom, keyFrom, Lists.newArrayList((Object[])kind), null, null, false);
        return holder.get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<GetGraphResponse<T>>>(){

            public Future<GetGraphResponse<T>> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<GetGraphResponse<T>>(){

                    @Override
                    public GetGraphResponse<T> call() throws Exception {
                        if (response.getStatus() != 200) {
                            OrchestrateGraphService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        TypeToken responseType = TypeToken.of((Class)clazz);
                        String responseBody = response.getBody();
                        Type type = new TypeToken<GetGraphResponse<T>>(){}.where(new TypeParameter<T>(){}, responseType).getType();
                        GetGraphResponse getGraphResponse = (GetGraphResponse)gson.fromJson(responseBody, type);
                        return getGraphResponse.withRequestId(reqId);
                    }
                }, (ExecutionContext)OrchestrateGraphService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }
}

