/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.impl;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import ru.quadcom.database.lib.orchestrate.Constants;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateClient;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateEventsService;
import ru.quadcom.database.lib.orchestrate.responses.GetEventsResponse;
import ru.quadcom.database.lib.orchestrate.responses.PutEventResponse;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrateEventsService
implements IOrchestrateEventsService {
    private static final Gson gson = new Gson();
    private final IOrchestrateClient client;

    @Inject
    public OrchestrateEventsService(IOrchestrateClient client) {
        this.client = client;
    }

    @Override
    public Future<PutEventResponse> putEvent(String collection, String key, String type, Object event) {
        return this.putEventImpl(collection, key, type, null, event);
    }

    @Override
    public Future<PutEventResponse> putEvent(String collection, String key, String type, Long timestamp, Object event) {
        return this.putEventImpl(collection, key, type, timestamp, event);
    }

    private Future<PutEventResponse> putEventImpl(String collection, String key, String type, Long unixTimeStamp, Object event) {
        WSRequestHolder holder = this.client.baseEventsRequestHolder(collection, key, type, unixTimeStamp);
        String jsonObject = gson.toJson(event);
        return holder.put(jsonObject).wrapped().flatMap((Function1)new Mapper<WSResponse, Future<PutEventResponse>>(){

            public Future<PutEventResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<PutEventResponse>(){

                    @Override
                    public PutEventResponse call() throws Exception {
                        if (response.getStatus() != 204) {
                            OrchestrateEventsService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        return new PutEventResponse(reqId);
                    }
                }, (ExecutionContext)OrchestrateEventsService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }

    @Override
    public <T> Future<GetEventsResponse<T>> getEvents(String collection, String key, String type, Class<T> clazz) {
        return this.getEventsImpl(collection, key, type, null, null, clazz);
    }

    @Override
    public <T> Future<GetEventsResponse<T>> getEventsInclusiveStarFrom(String collection, String key, String type, long startFromUnixTime, Class<T> clazz) {
        return this.getEventsImpl(collection, key, type, startFromUnixTime, null, clazz);
    }

    @Override
    public <T> Future<GetEventsResponse<T>> getEventsExclusiveEndWith(String collection, String key, String type, long endWithUnixTime, Class<T> clazz) {
        return this.getEventsImpl(collection, key, type, null, endWithUnixTime, clazz);
    }

    @Override
    public <T> Future<GetEventsResponse<T>> getEventsBetweenInclusiveStarAndExclusiveEnd(String collection, String key, String type, long startFromUnixTime, long endWithUnixTime, Class<T> clazz) {
        return this.getEventsImpl(collection, key, type, startFromUnixTime, endWithUnixTime, clazz);
    }

    private <T> Future<GetEventsResponse<T>> getEventsImpl(String collection, String key, String type, Long startFromUnixTime, Long endWithUnixTime, final Class<T> clazz) {
        WSRequestHolder holder = this.client.baseEventsRequestHolder(collection, key, type, null);
        if (startFromUnixTime != null) {
            holder = holder.setQueryParameter("start", startFromUnixTime.toString());
        }
        if (endWithUnixTime != null) {
            holder = holder.setQueryParameter("end", endWithUnixTime.toString());
        }
        return holder.get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<GetEventsResponse<T>>>(){

            public Future<GetEventsResponse<T>> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<GetEventsResponse<T>>(){

                    @Override
                    public GetEventsResponse<T> call() throws Exception {
                        if (response.getStatus() != 200) {
                            OrchestrateEventsService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        TypeToken responseType = TypeToken.of((Class)clazz);
                        String responseBody = response.getBody();
                        Type type = new TypeToken<GetEventsResponse<T>>(){}.where(new TypeParameter<T>(){}, responseType).getType();
                        GetEventsResponse getEventsResponse = (GetEventsResponse)gson.fromJson(responseBody, type);
                        return getEventsResponse.withRequestId(reqId);
                    }
                }, (ExecutionContext)OrchestrateEventsService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }
}

