/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.impl;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.codec.binary.Base64;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import ru.quadcom.database.lib.orchestrate.Constants;
import ru.quadcom.database.lib.orchestrate.exceptions.ApiBadRequestOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.IndexingConflictOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.InternalErrorOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.ItemAlreadyPresentOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.ItemRefMalformedOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.ItemVersionMismatchOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.ItemsNotFoundOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.SearchIndexNotFoundOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.SearchParamInvalidOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.SecurityAuthenticationOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.exceptions.SecurityUnauthorizedOrchestrateRuntimeException;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateClient;
import ru.quadcom.database.lib.orchestrate.responses.DeleteResponse;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrateClient
implements IOrchestrateClient {
    private final ExecutionContext executionContext;
    private final String baseUrl;
    private final String apiKey;
    private final String auth;
    private static final Gson gson = new Gson();

    public OrchestrateClient(String url, String key, ExecutionContext ex) {
        this.baseUrl = url;
        this.apiKey = key;
        String str = this.apiKey + ":";
        this.auth = "Basic " + Base64.encodeBase64URLSafeString((byte[])str.getBytes());
        this.executionContext = ex;
    }

    private String baseRequestUrl(String collection, String key) {
        StringBuilder urlBuilder = new StringBuilder(this.baseUrl);
        urlBuilder.append("/");
        urlBuilder.append(collection);
        if (key != null) {
            urlBuilder.append("/");
            urlBuilder.append(key);
        }
        return urlBuilder.toString();
    }

    @Override
    public WSRequestHolder baseRequestHolder(String collection, String key) {
        String url = this.baseRequestUrl(collection, key);
        return WS.url((String)url).setHeader("Authorization", this.auth).setContentType(Constants.CONTENT_TYPE.asString());
    }

    private String baseEventsRequestUrl(String collection, String key, String eventType) {
        StringBuilder urlBuilder = new StringBuilder(this.baseRequestUrl(collection, key));
        urlBuilder.append("/events/");
        urlBuilder.append(eventType);
        return urlBuilder.toString();
    }

    @Override
    public WSRequestHolder baseEventsRequestHolder(String collection, String key, String eventType, Long timeStamp) {
        String url = this.baseEventsRequestUrl(collection, key, eventType);
        WSRequestHolder requestHolder = WS.url((String)url);
        if (timeStamp != null) {
            requestHolder = requestHolder.setQueryParameter("timestamp", timeStamp.toString());
        }
        return requestHolder.setHeader("Authorization", this.auth).setContentType(Constants.CONTENT_TYPE.asString());
    }

    private String baseGraphRequestUrl(String collectionFrom, String keyFrom, List<String> kindList, String collectionTo, String keyTo, boolean isItPutRequest) {
        StringBuilder urlBuilder = new StringBuilder(this.baseRequestUrl(collectionFrom, keyFrom));
        if (isItPutRequest) {
            urlBuilder.append("/relation/");
        } else {
            urlBuilder.append("/relations/");
        }
        for (int i = 0; i < kindList.size(); ++i) {
            String eachKind = kindList.get(i);
            urlBuilder.append(eachKind);
            if (i == kindList.size() - 1 && collectionTo == null) continue;
            urlBuilder.append("/");
        }
        if (collectionTo != null) {
            urlBuilder.append(collectionTo);
            urlBuilder.append("/");
            urlBuilder.append(keyTo);
        }
        return urlBuilder.toString();
    }

    @Override
    public WSRequestHolder baseGraphRequestHolder(String collectionFrom, String keyFrom, List<String> kindList, String collectionTo, String keyTo, boolean isItPutRequest) {
        String url = this.baseGraphRequestUrl(collectionFrom, keyFrom, kindList, collectionTo, keyTo, isItPutRequest);
        WSRequestHolder requestHolder = WS.url((String)url).setHeader("Authorization", this.auth).setContentType(Constants.CONTENT_TYPE.asString());
        return requestHolder;
    }

    private String baseSearchRequestUrl(String collection) {
        StringBuilder urlBuilder = new StringBuilder(this.baseUrl);
        urlBuilder.append("/");
        urlBuilder.append(collection);
        return urlBuilder.toString();
    }

    @Override
    public WSRequestHolder baseSearchRequestHolder(String collection, String query, int limit, int offset) {
        String url = this.baseSearchRequestUrl(collection);
        WSRequestHolder requestHolder = WS.url((String)url).setQueryParameter("query", query);
        if (limit > 0) {
            requestHolder = requestHolder.setQueryParameter("limit", Integer.toString(limit <= 100 ? limit : 100));
        }
        if (offset > 0) {
            requestHolder = requestHolder.setQueryParameter("offset", Integer.toString(offset));
        }
        return requestHolder.setHeader("Authorization", this.auth).setContentType(Constants.CONTENT_TYPE.asString());
    }

    @Override
    public void throwExceptionDependsOnStatusCode(WSResponse response) {
        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
        String json = response.getBody();
        ErrorMessage errorMessage = (ErrorMessage)gson.fromJson(json, ErrorMessage.class);
        switch (response.getStatus()) {
            case 400: {
                if (errorMessage.getCode().equals("api_bad_request")) {
                    throw new ApiBadRequestOrchestrateRuntimeException(reqId);
                }
                if (errorMessage.getCode().equals("search_param_invalid")) {
                    throw new SearchParamInvalidOrchestrateRuntimeException(reqId);
                }
                if (!errorMessage.getCode().equals("item_ref_malformed")) break;
                throw new ItemRefMalformedOrchestrateRuntimeException(reqId);
            }
            case 401: {
                if (!errorMessage.getCode().equals("security_unauthorized")) break;
                throw new SecurityUnauthorizedOrchestrateRuntimeException(reqId);
            }
            case 404: {
                if (!errorMessage.getCode().equals("items_not_found")) break;
                throw new ItemsNotFoundOrchestrateRuntimeException(reqId);
            }
            case 409: {
                if (!errorMessage.getCode().equals("indexing_conflict")) break;
                throw new IndexingConflictOrchestrateRuntimeException(reqId);
            }
            case 412: {
                if (errorMessage.getCode().equals("item_version_mismatch")) {
                    throw new ItemVersionMismatchOrchestrateRuntimeException(reqId);
                }
                if (!errorMessage.getCode().equals("item_already_present")) break;
                throw new ItemAlreadyPresentOrchestrateRuntimeException(reqId);
            }
            case 500: {
                if (errorMessage.getCode().equals("security_authentication")) {
                    throw new SecurityAuthenticationOrchestrateRuntimeException(reqId);
                }
                if (errorMessage.getCode().equals("search_index_not_found")) {
                    throw new SearchIndexNotFoundOrchestrateRuntimeException(reqId);
                }
                if (!errorMessage.getCode().equals("internal_error")) break;
                throw new InternalErrorOrchestrateRuntimeException(reqId);
            }
            default: {
                throw new RuntimeException(response.getBody());
            }
        }
    }

    @Override
    public void throwExceptionExceptMismatchAndAlreadyPresentedDependsOnStatusCode(WSResponse response) {
        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
        String json = response.getBody();
        ErrorMessage errorMessage = (ErrorMessage)gson.fromJson(json, ErrorMessage.class);
        switch (response.getStatus()) {
            case 400: {
                if (errorMessage.getCode().equals("api_bad_request")) {
                    throw new ApiBadRequestOrchestrateRuntimeException(reqId);
                }
                if (errorMessage.getCode().equals("search_param_invalid")) {
                    throw new SearchParamInvalidOrchestrateRuntimeException(reqId);
                }
                if (!errorMessage.getCode().equals("item_ref_malformed")) break;
                throw new ItemRefMalformedOrchestrateRuntimeException(reqId);
            }
            case 401: {
                if (!errorMessage.getCode().equals("security_unauthorized")) break;
                throw new SecurityUnauthorizedOrchestrateRuntimeException(reqId);
            }
            case 404: {
                if (!errorMessage.getCode().equals("items_not_found")) break;
                throw new ItemsNotFoundOrchestrateRuntimeException(reqId);
            }
            case 409: {
                if (!errorMessage.getCode().equals("indexing_conflict")) break;
                throw new IndexingConflictOrchestrateRuntimeException(reqId);
            }
            case 412: {
                if (errorMessage.getCode().equals("item_version_mismatch")) {
                    return;
                }
                if (!errorMessage.getCode().equals("item_already_present")) break;
                return;
            }
            case 500: {
                if (errorMessage.getCode().equals("security_authentication")) {
                    throw new SecurityAuthenticationOrchestrateRuntimeException(reqId);
                }
                if (errorMessage.getCode().equals("search_index_not_found")) {
                    throw new SearchIndexNotFoundOrchestrateRuntimeException(reqId);
                }
                if (!errorMessage.getCode().equals("internal_error")) break;
                throw new InternalErrorOrchestrateRuntimeException(reqId);
            }
            default: {
                throw new RuntimeException(response.getBody());
            }
        }
    }

    @Override
    public Future<DeleteResponse> collectionDelete(String collectionName) {
        return this.baseRequestHolder(collectionName, null).setQueryParameter("force", "true").delete().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<DeleteResponse>>(){

            public Future<DeleteResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<DeleteResponse>(){

                    @Override
                    public DeleteResponse call() throws Exception {
                        if (response.getStatus() != 204) {
                            OrchestrateClient.this.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        return new DeleteResponse(reqId);
                    }
                }, (ExecutionContext)OrchestrateClient.this.executionContext);
            }
        }, this.executionContext);
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public static class ErrorMessage {
        private final String message;
        private final String code;

        public ErrorMessage(String message, String code) {
            this.message = message;
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getCode() {
            return this.code;
        }
    }
}

