/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.responses;

import java.util.ArrayList;
import java.util.List;
import ru.quadcom.database.lib.orchestrate.responses.BaseResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResponse<T>
extends BaseResponse {
    private final int count;
    private final int total_count;
    private final List<InnerSearchResponse<T>> results;

    private SearchResponse() {
        super(null);
        this.count = 0;
        this.total_count = 0;
        this.results = null;
    }

    public SearchResponse<T> withRequestId(String requestId) {
        return new SearchResponse<T>(requestId, this.getCount(), this.getTotal_count(), this.getResults());
    }

    public SearchResponse(String reqId, int count, int total_count, List<InnerSearchResponse<T>> results) {
        super(reqId);
        this.count = count;
        this.total_count = total_count;
        this.results = results;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotal_count() {
        return this.total_count;
    }

    public List<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (InnerSearchResponse<T> eachInnerResult : this.results) {
            result.add(((InnerSearchResponse)eachInnerResult).path.key);
        }
        return result;
    }

    public List<InnerSearchResponse<T>> getResults() {
        return this.results;
    }

    public List<T> items() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (InnerSearchResponse<T> eachInnerResult : this.results) {
            result.add(((InnerSearchResponse)eachInnerResult).value);
        }
        return result;
    }

    private static class Path {
        private final String collection;
        private final String key;
        private final String ref;

        private Path(String collection, String key, String ref) {
            this.collection = collection;
            this.key = key;
            this.ref = ref;
        }

        private String getCollection() {
            return this.collection;
        }

        private String getKey() {
            return this.key;
        }

        private String getRef() {
            return this.ref;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InnerSearchResponse<T> {
        private final Path path;
        private final double score;
        private final T value;

        private InnerSearchResponse(Path path, double score, T value) {
            this.path = path;
            this.score = score;
            this.value = value;
        }

        private Path getPath() {
            return this.path;
        }

        private double getScore() {
            return this.score;
        }

        public T getValue() {
            return this.value;
        }

        public String getKey() {
            return this.path.getKey();
        }
    }
}

