/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.impl;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import ru.quadcom.database.lib.orchestrate.Constants;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateClient;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateKeyValueService;
import ru.quadcom.database.lib.orchestrate.responses.DeleteResponse;
import ru.quadcom.database.lib.orchestrate.responses.GetResponse;
import ru.quadcom.database.lib.orchestrate.responses.PutResponse;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrateKeyValueService
implements IOrchestrateKeyValueService {
    private static final Gson gson = new Gson();
    private final IOrchestrateClient client;

    @Inject
    public OrchestrateKeyValueService(IOrchestrateClient client) {
        this.client = client;
    }

    private Future<PutResponse> putWithHeaders(String collectionName, String key, Object obj, String eTag, boolean notExist, final boolean throwMismatchOrAlreadyPresentedException) {
        WSRequestHolder holder = this.client.baseRequestHolder(collectionName, key);
        if (eTag != null) {
            holder = holder.setHeader(Constants.IF_MATH_HEADER.asString(), eTag);
        } else if (notExist) {
            holder = holder.setHeader(Constants.IF_NONE_MATCH_HEADER.asString(), "\"*\"");
        }
        return holder.put(gson.toJson(obj)).wrapped().flatMap((Function1)new Mapper<WSResponse, Future<PutResponse>>(){

            public Future<PutResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<PutResponse>(){

                    @Override
                    public PutResponse call() throws Exception {
                        if (response.getStatus() != 201) {
                            if (throwMismatchOrAlreadyPresentedException) {
                                OrchestrateKeyValueService.this.client.throwExceptionDependsOnStatusCode(response);
                            } else {
                                OrchestrateKeyValueService.this.client.throwExceptionExceptMismatchAndAlreadyPresentedDependsOnStatusCode(response);
                            }
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        String eTag = response.getHeader(Constants.ETAG_HEADER.asString());
                        String location = response.getHeader(Constants.LOCATION_HEADER.asString());
                        return new PutResponse(reqId, eTag, location);
                    }
                }, (ExecutionContext)OrchestrateKeyValueService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }

    @Override
    public Future<PutResponse> putIfVersionsTheSame(String collectionName, String key, Object obj, String etag) {
        return this.putWithHeaders(collectionName, key, obj, etag, false, true);
    }

    @Override
    public Future<PutResponse> putIfNotExist(String collectionName, String key, Object obj) {
        return this.putWithHeaders(collectionName, key, obj, null, true, true);
    }

    @Override
    public Future<PutResponse> putIfVersionsTheSameWithoutMismatchException(String collectionName, String key, Object obj, String etag) {
        return this.putWithHeaders(collectionName, key, obj, etag, false, false);
    }

    @Override
    public Future<PutResponse> putIfNotExistWithoutAlreadyPresentedException(String collectionName, String key, Object obj) {
        return this.putWithHeaders(collectionName, key, obj, null, true, false);
    }

    @Override
    public Future<PutResponse> put(String collectionName, String key, Object obj) {
        return this.putWithHeaders(collectionName, key, obj, null, false, true);
    }

    @Override
    public <T> Future<GetResponse<T>> get(String collectionName, String key, final Class<T> clazz) {
        return this.client.baseRequestHolder(collectionName, key).get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<GetResponse<T>>>(){

            public Future<GetResponse<T>> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<GetResponse<T>>(){

                    @Override
                    public GetResponse<T> call() throws Exception {
                        if (response.getStatus() != 200) {
                            OrchestrateKeyValueService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        String eTag = response.getHeader(Constants.ETAG_HEADER.asString());
                        String location = response.getHeader(Constants.CONTENT_LOCATION_HEADER.asString());
                        String body = response.getBody();
                        Object value = gson.fromJson(body, clazz);
                        GetResponse<Object> getResponse = new GetResponse<Object>(reqId, eTag, location, value);
                        return getResponse;
                    }
                }, (ExecutionContext)OrchestrateKeyValueService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }

    @Override
    public Future<DeleteResponse> delete(String collectionName, String key) {
        return this.client.baseRequestHolder(collectionName, key).delete().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<DeleteResponse>>(){

            public Future<DeleteResponse> apply(final WSResponse response) {
                return Futures.future((Callable)new Callable<DeleteResponse>(){

                    @Override
                    public DeleteResponse call() throws Exception {
                        if (response.getStatus() != 204) {
                            OrchestrateKeyValueService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        return new DeleteResponse(reqId);
                    }
                }, (ExecutionContext)OrchestrateKeyValueService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }
}

