/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.orchestrate.impl;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import play.libs.WS;
import ru.quadcom.database.lib.orchestrate.Constants;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateClient;
import ru.quadcom.database.lib.orchestrate.interfaces.IOrchestrateSearchService;
import ru.quadcom.database.lib.orchestrate.responses.SearchResponse;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrateSearchService
implements IOrchestrateSearchService {
    private static final Gson gson = new Gson();
    private final IOrchestrateClient client;

    @Inject
    public OrchestrateSearchService(IOrchestrateClient client) {
        this.client = client;
    }

    @Override
    public <T> Future<SearchResponse<T>> search(String collectionName, String query, Class<T> clazz) {
        return this.search(collectionName, query, -1, -1, clazz);
    }

    @Override
    public <T> Future<SearchResponse<T>> search(String collectionName, String query, int limit, int offset, final Class<T> clazz) {
        WS.WSRequestHolder holder = this.client.baseSearchRequestHolder(collectionName, query, limit, offset);
        return holder.get().wrapped().flatMap((Function1)new Mapper<WS.Response, Future<SearchResponse<T>>>(){

            public Future<SearchResponse<T>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<SearchResponse<T>>(){

                    @Override
                    public SearchResponse<T> call() throws Exception {
                        if (response.getStatus() != 200) {
                            OrchestrateSearchService.this.client.throwExceptionDependsOnStatusCode(response);
                        }
                        String reqId = response.getHeader(Constants.ORCHESTRATE_REQ_ID_HEADER.asString());
                        TypeToken responseType = TypeToken.of((Class)clazz);
                        String responseBody = response.getBody();
                        Type type = new TypeToken<SearchResponse<T>>(){}.where(new TypeParameter<T>(){}, responseType).getType();
                        SearchResponse searchResponse = (SearchResponse)gson.fromJson(responseBody, type);
                        return searchResponse.withRequestId(reqId);
                    }
                }, (ExecutionContext)OrchestrateSearchService.this.client.getExecutionContext());
            }
        }, this.client.getExecutionContext());
    }
}

