/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.commons.identity.codec;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import ru.quadcom.commons.identity.codec.Base16Coder;

public abstract class Hash {
    public static HashProvider sha1;
    public static HashProvider sha256;

    public static String hashAndByte16Encode(String value) {
        return Hash.sha256.hashAndBase16Encode(value);
    }

    private static String hashAndEncodeUnsafe(String value) {
        return Hash.sha256.hashAndBase16Encode(value);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        sha1 = new HashProvider("SHA-1");
        sha256 = new HashProvider("SHA-256");
    }

    public static class HashProvider {
        private ThreadLocal<MessageDigest> digest;

        protected HashProvider(final String scheme) {
            this.digest = new ThreadLocal<MessageDigest>(){

                @Override
                protected MessageDigest initialValue() {
                    try {
                        return MessageDigest.getInstance(scheme, "BC");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public byte[] hash(String value) {
            try {
                return this.hash(value.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] hash(byte[] value) {
            try {
                MessageDigest messageDigest = this.digest.get();
                messageDigest.reset();
                messageDigest.update(value);
                return messageDigest.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String hashAndBase16Encode(String value) {
            return Base16Coder.encodeBytes(this.hash(value));
        }

        private String hashAndBase16Encode(byte[] value) {
            return Base16Coder.encodeBytes(this.hash(value));
        }
    }
}

