/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.commons.identity;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.commons.identity.codec.Base16Coder;

public class AccountIdGenerator {
    private static final String firstSalt = "Agah8698HJfTmm";
    private static final String secondSalt = "KHtnet97JhjAg";

    public static String createAccountId(String uniqueValue) {
        String id = AccountIdGenerator.createId(uniqueValue);
        return id;
    }

    private static String createId(String base) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(firstSalt);
        buffer.append(base);
        buffer.append(secondSalt);
        try {
            byte[] guid = buffer.toString().getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(guid);
            return Base16Coder.encodeBytes(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Generating account id failed.", e, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Generating account id failed.", e, null);
        }
    }
}

