/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class Join {
    private Field from;
    private Field to;

    private Join() {
    }

    public Join(Field from, Field to) {
        this.from = from;
        this.to = to;
    }

    public static Builder from(Field from) {
        return new Builder(from);
    }

    public static Builder from(String fieldname) {
        return Join.from(new SimpleField(fieldname));
    }

    public Field getFrom() {
        return this.from;
    }

    public Field getTo() {
        return this.to;
    }

    public static class Builder {
        private Join join;

        public Builder(Field from) {
            Assert.notNull((Object)from);
            this.join = new Join();
            this.join.from = from;
        }

        public Builder(String fieldname) {
            this(new SimpleField(fieldname));
        }

        public Join to(Field to) {
            Assert.notNull((Object)to);
            this.join.to = to;
            return this.join;
        }

        public Join to(String fieldname) {
            return this.to(new SimpleField(fieldname));
        }
    }
}

