/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraConverterRowCallback;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.util.Assert;

public class CassandraTemplate
extends CqlTemplate
implements CassandraOperations {
    protected CassandraConverter cassandraConverter;
    protected CassandraMappingContext mappingContext;

    public CassandraTemplate() {
    }

    public CassandraTemplate(Session session) {
        this(session, new MappingCassandraConverter());
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this.setSession(session);
        this.setConverter(converter);
    }

    public void setConverter(CassandraConverter cassandraConverter) {
        Assert.notNull((Object)cassandraConverter);
        this.cassandraConverter = cassandraConverter;
        this.mappingContext = cassandraConverter.getMappingContext();
    }

    @Override
    public CassandraConverter getConverter() {
        return this.cassandraConverter;
    }

    public CassandraMappingContext getCassandraMappingContext() {
        return this.mappingContext;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cassandraConverter);
        Assert.notNull((Object)this.mappingContext);
    }

    @Override
    public boolean exists(Class<?> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Select select = QueryBuilder.select().countAll().from(entity.getTableName().toCql());
        this.appendIdCriteria(select.where(), entity, id);
        Long count = (Long)this.queryForObject(select, Long.class);
        return count != 0L;
    }

    @Override
    public long count(Class<?> type) {
        return this.count(this.getTableName(type).toCql());
    }

    @Override
    public <T> void delete(List<T> entities) {
        this.delete((T)entities, null);
    }

    @Override
    public <T> void delete(List<T> entities, QueryOptions options) {
        this.batchDelete(entities, options, false);
    }

    @Override
    public void deleteById(Class<?> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.appendIdCriteria(delete.where(), entity, id);
        this.execute(delete);
    }

    @Override
    public <T> void delete(T entity) {
        this.delete(entity, null);
    }

    @Override
    public <T> void delete(T entity, QueryOptions options) {
        this.delete(entity, options, false);
    }

    @Override
    public <T> void deleteAsynchronously(List<T> entities) {
        this.deleteAsynchronously((T)entities, null);
    }

    @Override
    public <T> void deleteAsynchronously(List<T> entities, QueryOptions options) {
        this.batchDelete(entities, options, true);
    }

    @Override
    public <T> void deleteAsynchronously(T entity) {
        this.deleteAsynchronously(entity, null);
    }

    @Override
    public <T> void deleteAsynchronously(T entity, QueryOptions options) {
        this.delete(entity, options, true);
    }

    @Override
    public CqlIdentifier getTableName(Class<?> type) {
        return ((CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type)).getTableName();
    }

    @Override
    public <T> List<T> insert(List<T> entities) {
        return this.insert((T)entities, null);
    }

    @Override
    public <T> List<T> insert(List<T> entities, WriteOptions options) {
        return this.batchInsert(entities, options, false);
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, null);
    }

    @Override
    public <T> T insert(T entity, WriteOptions options) {
        return this.insert(entity, options, false);
    }

    @Override
    public <T> List<T> insertAsynchronously(List<T> entities) {
        return this.insertAsynchronously((T)entities, null);
    }

    @Override
    public <T> List<T> insertAsynchronously(List<T> entities, WriteOptions options) {
        return this.batchInsert(entities, options, true);
    }

    @Override
    public <T> T insertAsynchronously(T entity) {
        return this.insertAsynchronously(entity, null);
    }

    @Override
    public <T> T insertAsynchronously(T entity, WriteOptions options) {
        return this.insert(entity, options, true);
    }

    @Override
    public <T> List<T> selectAll(Class<T> type) {
        return this.select(QueryBuilder.select().all().from(this.getTableName(type).toCql()), type);
    }

    @Override
    public <T> List<T> select(String cql, Class<T> type) {
        Assert.hasText((String)cql);
        Assert.notNull(type);
        return this.select(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> select(Select select, Class<T> type) {
        Assert.notNull((Object)select);
        return this.select(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> selectBySimpleIds(Class<T> type, Iterable<?> ids) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        if (((CassandraPersistentProperty)entity.getIdProperty()).isCompositePrimaryKey()) {
            throw new IllegalArgumentException(String.format("entity class [%s] uses a composite primary key class [%s] which this method can't support", type.getName(), ((CassandraPersistentProperty)entity.getIdProperty()).getCompositePrimaryKeyEntity().getType().getName()));
        }
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        select.where(QueryBuilder.in((String)((CassandraPersistentProperty)entity.getIdProperty()).getColumnName().toCql(), (Object[])CollectionUtils.toArray(ids)));
        return this.select(select, type);
    }

    @Override
    public <T> T selectOneById(Class<T> type, Object id) {
        Assert.notNull(type);
        Assert.notNull((Object)id);
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(type);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("unknown entity class [%s]", type.getName()));
        }
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.appendIdCriteria(select.where(), entity, id);
        return this.selectOne(select, type);
    }

    protected void appendIdCriteria(ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Map<?, ?> id) {
        for (Map.Entry<?, ?> entry : id.entrySet()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getPersistentProperty(entry.getKey().toString());
            clauseCallback.doWithClause(QueryBuilder.eq((String)property.getColumnName().toCql(), entry.getValue()));
        }
    }

    protected void appendIdCriteria(final ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Object id) {
        if (id instanceof Map) {
            this.appendIdCriteria(clauseCallback, entity, (Map)id);
            return;
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty.isCompositePrimaryKey()) {
            CassandraPersistentEntity<?> idEntity = idProperty.getCompositePrimaryKeyEntity();
            final BeanWrapper idWrapper = BeanWrapper.create((Object)id, (ConversionService)this.cassandraConverter.getConversionService());
            idEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                public void doWithPersistentProperty(CassandraPersistentProperty p) {
                    clauseCallback.doWithClause(QueryBuilder.eq((String)p.getColumnName().toCql(), (Object)idWrapper.getProperty((PersistentProperty)p, p.getActualType())));
                }
            });
            return;
        }
        clauseCallback.doWithClause(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
    }

    protected void appendIdCriteria(final Select.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    protected void appendIdCriteria(final Delete.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> type) {
        return this.selectOne(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> T selectOne(Select select, Class<T> type) {
        return this.selectOne(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, type));
    }

    @Override
    public <T> List<T> update(List<T> entities) {
        return this.update((T)entities, null);
    }

    @Override
    public <T> List<T> update(List<T> entities, WriteOptions options) {
        return this.batchUpdate(entities, options, false);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, null);
    }

    @Override
    public <T> T update(T entity, WriteOptions options) {
        return this.update(entity, options, false);
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities) {
        return this.updateAsynchronously((T)entities, null);
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities, WriteOptions options) {
        return this.batchUpdate(entities, options, true);
    }

    @Override
    public <T> T updateAsynchronously(T entity) {
        return this.updateAsynchronously(entity, null);
    }

    @Override
    public <T> T updateAsynchronously(T entity, WriteOptions options) {
        return this.update(entity, options, true);
    }

    protected <T> CqlIdentifier determineTableName(T obj) {
        return obj == null ? null : this.determineTableName(obj.getClass());
    }

    protected <T> List<T> select(final String query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = (ResultSet)this.doExecute((SessionCallback)new SessionCallback<ResultSet>(){

            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute(query);
            }
        });
        if (resultSet == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Row row : resultSet) {
            result.add(readRowCallback.doWith(row));
        }
        return result;
    }

    protected <T> List<T> select(final Select query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = (ResultSet)this.doExecute((SessionCallback)new SessionCallback<ResultSet>(){

            public ResultSet doInSession(Session s) throws DataAccessException {
                return s.execute((Statement)query);
            }
        });
        if (resultSet == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Row row : resultSet) {
            result.add(readRowCallback.doWith(row));
        }
        return result;
    }

    protected <T> T selectOne(String query, CassandraConverterRowCallback<T> readRowCallback) {
        this.logger.debug(query);
        ResultSet resultSet = this.query(query);
        Iterator iterator = resultSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            T result = readRowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException("found two or more results in query " + query);
            }
            return result;
        }
        return null;
    }

    protected <T> T selectOne(Select query, CassandraConverterRowCallback<T> readRowCallback) {
        ResultSet resultSet = this.query(query);
        Iterator iterator = resultSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            T result = readRowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException("found two or more results in query " + query);
            }
            return result;
        }
        return null;
    }

    protected <T> void batchDelete(List<T> entities, QueryOptions options, boolean asynchronously) {
        Assert.notEmpty(entities);
        Batch b = CassandraTemplate.createDeleteBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asynchronously) {
            this.executeAsynchronously(b);
        } else {
            this.execute(b);
        }
    }

    protected <T> T insert(T entity, WriteOptions options, boolean asynchronously) {
        Assert.notNull(entity);
        Insert insert = CassandraTemplate.createInsertQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asynchronously) {
            this.executeAsynchronously(insert);
        } else {
            this.execute(insert);
        }
        return entity;
    }

    protected <T> List<T> batchInsert(List<T> entities, WriteOptions options, boolean asychronously) {
        if (entities == null || entities.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("no-op due to given null or empty list");
            }
            return entities;
        }
        Batch b = CassandraTemplate.createInsertBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asychronously) {
            this.executeAsynchronously(b);
        } else {
            this.execute(b);
        }
        return entities;
    }

    protected <T> List<T> batchUpdate(List<T> entities, WriteOptions options, boolean asychronously) {
        Assert.notEmpty(entities);
        Batch b = CassandraTemplate.toUpdateBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asychronously) {
            this.executeAsynchronously(b);
        } else {
            this.execute(b);
        }
        return entities;
    }

    protected <T> void delete(T entity, QueryOptions options, boolean asynchronously) {
        Assert.notNull(entity);
        Delete delete = CassandraTemplate.createDeleteQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asynchronously) {
            this.executeAsynchronously(delete);
        } else {
            this.execute(delete);
        }
    }

    protected <T> T update(T entity, WriteOptions options, boolean asychronously) {
        Assert.notNull(entity);
        Update update = CassandraTemplate.toUpdateQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        if (asychronously) {
            this.executeAsynchronously(update);
        } else {
            this.execute(update);
        }
        return entity;
    }

    public static Insert createInsertQuery(String tableName, Object objectToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Insert insert = QueryBuilder.insertInto((String)tableName);
        entityWriter.write(objectToSave, (Object)insert);
        CqlTemplate.addWriteOptions((Insert)insert, (WriteOptions)options);
        return insert;
    }

    public static Update toUpdateQuery(String tableName, Object objectToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Update update = QueryBuilder.update((String)tableName);
        entityWriter.write(objectToSave, (Object)update);
        CqlTemplate.addWriteOptions((Update)update, (WriteOptions)options);
        return update;
    }

    public static <T> Batch toUpdateBatchQuery(String tableName, List<T> objectsToSave, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Batch b = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T objectToSave : objectsToSave) {
            b.add((RegularStatement)CassandraTemplate.toUpdateQuery(tableName, objectToSave, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)b, (QueryOptions)options);
        return b;
    }

    public static <T> Batch createInsertBatchQuery(String tableName, List<T> entities, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T entity : entities) {
            batch.add((RegularStatement)CassandraTemplate.createInsertQuery(tableName, entity, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)batch, (QueryOptions)options);
        return batch;
    }

    public static Delete createDeleteQuery(String tableName, Object object, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Delete.Selection ds = QueryBuilder.delete();
        Delete delete = ds.from(tableName);
        Delete.Where w = delete.where();
        entityWriter.write(object, (Object)w);
        CqlTemplate.addQueryOptions((Statement)delete, (QueryOptions)options);
        return delete;
    }

    public static <T> Batch createDeleteBatchQuery(String tableName, List<T> entities, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.notEmpty(entities);
        Assert.hasText((String)tableName);
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (T entity : entities) {
            batch.add((RegularStatement)CassandraTemplate.createDeleteQuery(tableName, entity, options, entityWriter));
        }
        CqlTemplate.addQueryOptions((Statement)batch, (QueryOptions)options);
        return batch;
    }

    @Override
    public <T> void deleteAll(Class<T> clazz) {
        if (!this.mappingContext.contains(clazz)) {
            throw new IllegalArgumentException(String.format("unknown persistent entity class [%s]", clazz.getName()));
        }
        this.truncate(((CassandraPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).getTableName());
    }

    protected static interface ClauseCallback {
        public void doWithClause(Clause var1);
    }
}

