/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.Predef$;
import scala.ScalaObject;
import scala.concurrent.stm.ccstm.SlotLock;
import scala.concurrent.stm.skel.SimpleRandom$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0003\u0005)\u0011a\u0002\u0016=o'2|G/T1oC\u001e,'O\u0003\u0002\u0004\t\u0005)1mY:u[*\u0011QAB\u0001\u0004gRl'BA\u0004\t\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u0013\u0005)1oY1mCV\u00111bJ\n\u0004\u00011!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U1R\"\u0001\u0005\n\u0005]A!aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0006e\u0006tw-Z\u0002\u0001!\t)B$\u0003\u0002\u001e\u0011\t\u0019\u0011J\u001c;\t\u0011}\u0001!\u0011!Q\u0001\nm\tQB]3tKJ4X\rZ*m_R\u001c\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0002$aE\u00022\u0001\n\u0001&\u001b\u0005\u0011\u0001C\u0001\u0014(\u0019\u0001!Q\u0001\u000b\u0001C\u0002%\u0012\u0011\u0001V\t\u0003U5\u0002\"!F\u0016\n\u00051B!a\u0002(pi\"Lgn\u001a\t\u0003+9J!a\f\u0005\u0003\r\u0005s\u0017PU3g\u0011\u0015I\u0002\u00051\u0001\u001c\u0011\u0015y\u0002\u00051\u0001\u001c\u0011\u0015\u0019\u0004\u0001\"\u00035\u0003!qW\r\u001f;TY>$HCA\u000e6\u0011\u00151$\u00071\u0001\u001c\u0003\u0015!(/[3t\u0011\u001dA\u0004A1A\u0005\ne\nQa\u001d7piN,\u0012A\u000f\t\u0004w\u0005kS\"\u0001\u001f\u000b\u0005ur\u0014AB1u_6L7M\u0003\u0002\b\u007f)\u0011\u0001\tE\u0001\u0005kRLG.\u0003\u0002Cy\t!\u0012\t^8nS\u000e\u0014VMZ3sK:\u001cW-\u0011:sCfDa\u0001\u0012\u0001!\u0002\u0013Q\u0014AB:m_R\u001c\b\u0005C\u0003G\u0001\u0011\u0005q)\u0001\u0004bgNLwM\u001c\u000b\u00047!S\u0005\"B%F\u0001\u0004)\u0013a\u0001;y]\")1*\u0012a\u00017\u0005A1\u000f\\8u\u0011&tG\u000fK\u0002F\u001bB\u0003\"!\u0006(\n\u0005=C!A\u0002;ie><8oI\u0001R!\ti!+\u0003\u0002T\u001d\t!\u0012J\u001c;feJ,\b\u000f^3e\u000bb\u001cW\r\u001d;j_:DQ!\u0016\u0001\u0005\u0002Y\u000ba\u0001\\8pWV\u0004HCA\u0013X\u0011\u0015AF\u000b1\u0001\u001c\u0003\u0011\u0019Hn\u001c;\t\u000bi\u0003A\u0011B.\u0002\rUtwO]1q)\t)C\fC\u0003^3\u0002\u0007Q&A\u0001f\u0011\u0015y\u0006\u0001\"\u0001a\u0003-\u0011WmZ5o\u0019>|7.\u001e9\u0015\u0005\u0015\n\u0007\"\u0002-_\u0001\u0004Y\u0002\"B2\u0001\t\u0013!\u0017A\u00027pG.,G\r\u0006\u0002.K\")QL\u0019a\u0001[!)q\r\u0001C\u0001Q\u0006IQM\u001c3M_>\\W\u000f\u001d\u000b\u0004S2l\u0007CA\u000bk\u0013\tY\u0007B\u0001\u0003V]&$\b\"\u0002-g\u0001\u0004Y\u0002\"\u00028g\u0001\u0004)\u0013\u0001C8cg\u0016\u0014h/\u001a3\t\u000bA\u0004A\u0011A9\u0002\u000fI,G.Z1tKR\u0011\u0011N\u001d\u0005\u00061>\u0004\ra\u0007\u0005\u0006i\u0002!I!^\u0001\tk:dwnY6fIR\u0011QF\u001e\u0005\u0006;N\u0004\r!\f")
public final class TxnSlotManager<T>
implements ScalaObject {
    private final int range;
    private final int reservedSlots;
    private final AtomicReferenceArray<Object> slots;

    private int nextSlot(int tries) {
        return (SimpleRandom$.MODULE$.nextInt() << 4 | -tries >> 1 & 0xF) & this.range - 1;
    }

    private AtomicReferenceArray<Object> slots() {
        return this.slots;
    }

    public int assign(T txn, int slotHint) throws InterruptedException {
        int s = (slotHint & ~15 | slotHint + 1 & 0xF) & this.range - 1;
        int tries = 0;
        while (true) {
            if (s >= this.reservedSlots && this.slots().get(s) == null) {
                if (this.slots().compareAndSet(s, null, txn)) {
                    return s;
                }
            }
            s = this.nextSlot(tries);
            if (++tries <= 100) continue;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.yield();
        }
    }

    public T lookup(int slot) {
        return this.unwrap(this.slots().get(slot));
    }

    private T unwrap(Object e) {
        Object object = e;
        return (T)(object instanceof SlotLock ? ((SlotLock)object).txn() : object);
    }

    public T beginLookup(int slot) {
        Object e = null;
        while ((e = this.slots().get(slot)) != null && !this.slots().compareAndSet(slot, e, this.locked(e))) {
        }
        return this.unwrap(e);
    }

    private Object locked(Object e) {
        SlotLock slotLock;
        Object object = e;
        if (object instanceof SlotLock) {
            SlotLock slotLock2 = (SlotLock)object;
            slotLock = new SlotLock(slotLock2.txn(), slotLock2.refCount() + 1);
        } else {
            slotLock = new SlotLock(object, 1);
        }
        return slotLock;
    }

    public void endLookup(int slot, T observed) {
        if (observed != null) {
            this.release(slot);
        }
    }

    public void release(int slot) {
        Object e = null;
        do {
            e = this.slots().get(slot);
        } while (!this.slots().compareAndSet(slot, e, this.unlocked(e)));
    }

    private Object unlocked(Object e) {
        Object object;
        Object object2 = e;
        if (object2 instanceof SlotLock) {
            SlotLock slotLock = (SlotLock)object2;
            Object object3 = slotLock.txn();
            int n = slotLock.refCount();
            object = n == 1 ? object3 : new SlotLock(object3, n - 1);
        } else {
            object = null;
        }
        return object;
    }

    public TxnSlotManager(int range, int reservedSlots) {
        this.range = range;
        this.reservedSlots = reservedSlots;
        Predef$.MODULE$.assert(range >= 16 & (range & range - 1) == 0);
        Predef$.MODULE$.assert(range >= reservedSlots + 16);
        this.slots = new AtomicReferenceArray(range);
    }
}

