/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import scala.ScalaObject;
import scala.actors.threadpool.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u0001\u0003\u0001\tQ!\u0001\u0003*fiJL8+\u001a;\u000b\u0005\r!\u0011!B2dgRl'BA\u0003\u0007\u0003\r\u0019H/\u001c\u0006\u0003\u000f!\t!bY8oGV\u0014(/\u001a8u\u0015\u0005I\u0011!B:dC2\f7c\u0001\u0001\f'A\u0011A\"E\u0007\u0002\u001b)\u0011abD\u0001\u0005Y\u0006twMC\u0001\u0011\u0003\u0011Q\u0017M^1\n\u0005Ii!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0015+5\t\u0001\"\u0003\u0002\u0017\u0011\tY1kY1mC>\u0013'.Z2u\u0011!A\u0002A!b\u0001\n\u0003Q\u0012\u0001B:ju\u0016\u001c\u0001!F\u0001\u001c!\t!B$\u0003\u0002\u001e\u0011\t\u0019\u0011J\u001c;\t\u0011}\u0001!\u0011!Q\u0001\nm\tQa]5{K\u0002B\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\bQ\u0006tG\r\\3t!\r!2%J\u0005\u0003I!\u0011Q!\u0011:sCf\u0004$A\n\u0017\u0011\u0007\u001dB#&D\u0001\u0003\u0013\tI#A\u0001\u0004IC:$G.\u001a\t\u0003W1b\u0001\u0001B\u0003.\u0001\t\u0005aFA\u0002`IE\n\"a\f\u001a\u0011\u0005Q\u0001\u0014BA\u0019\t\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001F\u001a\n\u0005QB!aA!os\"Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u0005wKJ\u001c\u0018n\u001c8t!\r!2\u0005\u000f\t\u0003sqr!a\n\u001e\n\u0005m\u0012\u0011!B\"D'Rk\u0015BA\u001f?\u0005\u001d1VM]:j_:T!a\u000f\u0002\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0011\u00115\t\u0012&\u0011\u0005\u001d\u0002\u0001\"\u0002\r@\u0001\u0004Y\u0002\"B\u0011@\u0001\u0004)\u0005c\u0001\u000b$\rB\u0012q)\u0013\t\u0004O!B\u0005CA\u0016J\t\u0015isH!\u0001/\u0011\u00151t\b1\u00018\u0011\u0015a\u0005\u0001\"\u0001N\u0003)\tw/Y5u%\u0016$(/\u001f\u000b\u0003\u001dF\u0003\"\u0001F(\n\u0005AC!\u0001\u0002'p]\u001eDQAU&A\u00029\u000bA\u0002^5nK>,HOT1o_ND3a\u0013+X!\t!R+\u0003\u0002W\u0011\t1A\u000f\u001b:poN\u001c\u0013\u0001\u0017\t\u0003\u0019eK!AW\u0007\u0003)%sG/\u001a:skB$X\rZ#yG\u0016\u0004H/[8o\u0011\u0015a\u0006\u0001\"\u0003^\u00031\tG\u000f^3naR\fu/Y5u)\tq\u0016\r\u0005\u0002\u0015?&\u0011\u0001\r\u0003\u0002\b\u0005>|G.Z1o\u0011\u0015\u00117\f1\u0001O\u00031q\u0017M\\8EK\u0006$G.\u001b8fQ\rYFk\u0016\u0005\u0006K\u0002!IAZ\u0001\u0015E2|7m[5oO\u0006#H/Z7qi\u0006;\u0018-\u001b;\u0015\ty;\u0007.\u001d\u0005\u0006E\u0012\u0004\rA\u0014\u0005\bS\u0012\u0004\n\u00111\u0001k\u0003\u0015)g/\u001a8u!\tYgN\u0004\u0002(Y&\u0011QNA\u0001\u000e/\u0006\\W-\u001e9NC:\fw-\u001a:\n\u0005=\u0004(!B#wK:$(BA7\u0003\u0011\u001d\u0011H\r%AA\u0002m\t\u0011!\u001b\u0015\u0003IR\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zm\n9A/Y5me\u0016\u001c\u0007f\u00013U/\")A\u0010\u0001C\u0005{\u0006\u0001\u0012\r\u001a3QK:$\u0017N\\4XC.,W\u000f\u001d\u000b\u0005=z\fY\u0001\u0003\u0004\u0000w\u0002\u0007\u0011\u0011A\u0001\u0007Q\u0006tG\r\\31\t\u0005\r\u0011q\u0001\t\u0005O!\n)\u0001E\u0002,\u0003\u000f!a!!\u0003|\u0005\u0003q#aA0%e!1\u0011QB>A\u0002a\n1A^3sQ\tYH\u000fC\u0004\u0002\u0014\u0001!I!!\u0006\u0002\u000f\rD\u0017M\\4fIV\ta\fC\u0005\u0002\u001a\u0001\t\n\u0011\"\u0003\u0002\u001c\u0005q\"\r\\8dW&tw-\u0011;uK6\u0004H/Q<bSR$C-\u001a4bk2$HEM\u000b\u0003\u0003;Q3A[A\u0010W\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9C^\u0001\nk:\u001c\u0007.Z2lK\u0012LA!a\u000b\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005=\u0002!%A\u0005\n\u0005E\u0012A\b2m_\u000e\\\u0017N\\4BiR,W\u000e\u001d;Bo\u0006LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019DK\u0002\u001c\u0003?\u0001")
public class RetrySet
implements ScalaObject {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
            throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
        }
        long begin = System.nanoTime();
        long d = begin + timeoutNanos;
        long deadline = d < 0L ? Long.MAX_VALUE : d;
        boolean timeoutExceeded = !this.attemptAwait(deadline);
        long actualElapsed = System.nanoTime() - begin;
        if (Stats$.MODULE$.top() != null) {
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        while (true) {
            if (i < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) return false;
                if (this.changed()) {
                    return true;
                }
                i = this.blockingAttemptAwait$default$3();
                event = this.blockingAttemptAwait$default$2();
                continue;
            }
            Handle<?> h = this.handles[i];
            if (event.addSource(h)) {
                if (!this.addPendingWakeup(h, this.versions[i])) return true;
                --i;
                continue;
            }
            if (this.changed()) {
                return true;
            }
            i = this.blockingAttemptAwait$default$3();
            event = this.blockingAttemptAwait$default$2();
        }
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        boolean bl;
        block1: {
            long m;
            do {
                if (!CCSTM$.MODULE$.changing(m = handle.meta()) && CCSTM$.MODULE$.version(m) == ver) continue;
                bl = false;
                break block1;
            } while (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m)));
            bl = true;
        }
        return bl;
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }
}

