/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Integer limit;
    private String select;
    private Map<String, Condition> scanFilter;
    private Map<String, AttributeValue> exclusiveStartKey;
    private String returnConsumedCapacity;
    private Integer totalSegments;
    private Integer segment;

    public ScanRequest() {
    }

    public ScanRequest(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ScanRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
        attributesToGetCopy.addAll(attributesToGet);
        this.attributesToGet = attributesToGetCopy;
    }

    public ScanRequest withAttributesToGet(String ... attributesToGet) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String value : attributesToGet) {
            this.getAttributesToGet().add(value);
        }
        return this;
    }

    public ScanRequest withAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
            attributesToGetCopy.addAll(attributesToGet);
            this.attributesToGet = attributesToGetCopy;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ScanRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public ScanRequest withSelect(String select) {
        this.select = select;
        return this;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public ScanRequest withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public Map<String, Condition> getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> scanFilter) {
        this.scanFilter = scanFilter;
    }

    public ScanRequest withScanFilter(Map<String, Condition> scanFilter) {
        this.setScanFilter(scanFilter);
        return this;
    }

    public ScanRequest addScanFilterEntry(String key, Condition value) {
        if (null == this.scanFilter) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        if (this.scanFilter.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.scanFilter.put(key, value);
        return this;
    }

    public ScanRequest clearScanFilterEntries() {
        this.scanFilter = null;
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public ScanRequest withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.setExclusiveStartKey(exclusiveStartKey);
        return this;
    }

    public void setExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        HashMap<String, AttributeValue> exclusiveStartKey = new HashMap<String, AttributeValue>();
        if (hashKey == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        exclusiveStartKey.put(hashKey.getKey(), hashKey.getValue());
        if (rangeKey != null) {
            exclusiveStartKey.put(rangeKey.getKey(), rangeKey.getValue());
        }
        this.setExclusiveStartKey(exclusiveStartKey);
    }

    public ScanRequest withExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        this.setExclusiveStartKey(hashKey, rangeKey);
        return this;
    }

    public ScanRequest addExclusiveStartKeyEntry(String key, AttributeValue value) {
        if (null == this.exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>();
        }
        if (this.exclusiveStartKey.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.exclusiveStartKey.put(key, value);
        return this;
    }

    public ScanRequest clearExclusiveStartKeyEntries() {
        this.exclusiveStartKey = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public ScanRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public ScanRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public Integer getTotalSegments() {
        return this.totalSegments;
    }

    public void setTotalSegments(Integer totalSegments) {
        this.totalSegments = totalSegments;
    }

    public ScanRequest withTotalSegments(Integer totalSegments) {
        this.totalSegments = totalSegments;
        return this;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public void setSegment(Integer segment) {
        this.segment = segment;
    }

    public ScanRequest withSegment(Integer segment) {
        this.segment = segment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ",");
        }
        if (this.getSelect() != null) {
            sb.append("Select: " + this.getSelect() + ",");
        }
        if (this.getScanFilter() != null) {
            sb.append("ScanFilter: " + this.getScanFilter() + ",");
        }
        if (this.getExclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: " + this.getExclusiveStartKey() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getTotalSegments() != null) {
            sb.append("TotalSegments: " + this.getTotalSegments() + ",");
        }
        if (this.getSegment() != null) {
            sb.append("Segment: " + this.getSegment());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSelect() == null ? 0 : this.getSelect().hashCode());
        hashCode = 31 * hashCode + (this.getScanFilter() == null ? 0 : ((Object)this.getScanFilter()).hashCode());
        hashCode = 31 * hashCode + (this.getExclusiveStartKey() == null ? 0 : ((Object)this.getExclusiveStartKey()).hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTotalSegments() == null ? 0 : this.getTotalSegments().hashCode());
        hashCode = 31 * hashCode + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !((Object)other.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getSelect() == null ^ this.getSelect() == null) {
            return false;
        }
        if (other.getSelect() != null && !other.getSelect().equals(this.getSelect())) {
            return false;
        }
        if (other.getScanFilter() == null ^ this.getScanFilter() == null) {
            return false;
        }
        if (other.getScanFilter() != null && !((Object)other.getScanFilter()).equals(this.getScanFilter())) {
            return false;
        }
        if (other.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        if (other.getExclusiveStartKey() != null && !((Object)other.getExclusiveStartKey()).equals(this.getExclusiveStartKey())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getTotalSegments() == null ^ this.getTotalSegments() == null) {
            return false;
        }
        if (other.getTotalSegments() != null && !other.getTotalSegments().equals(this.getTotalSegments())) {
            return false;
        }
        if (other.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        return other.getSegment() == null || other.getSegment().equals(this.getSegment());
    }
}

