/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        IamInstanceProfileSpecification iamInstanceProfile;
        SdkInternalList networkInterfacesList;
        SdkInternalList blockDeviceMappingsList;
        Placement placement;
        SdkInternalList securityGroupIdsList;
        SdkInternalList securityGroupsList;
        if (runInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)runInstancesRequest.getKeyName()));
        }
        if (!(securityGroupsList = (SdkInternalList)runInstancesRequest.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (Object securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)runInstancesRequest.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)runInstancesRequest.getInstanceType()));
        }
        if ((placement = runInstancesRequest.getPlacement()) != null) {
            if (placement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
            }
            if (placement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
            }
            if (placement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
            }
            if (placement.getHostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
            }
            if (placement.getAffinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)runInstancesRequest.getRamdiskId()));
        }
        if (!(blockDeviceMappingsList = (SdkInternalList)runInstancesRequest.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (blockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingsListValue.getVirtualName()));
                }
                if (blockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingsListValue.getDeviceName()));
                }
                if ((ebs = blockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                }
                if (blockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.getMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean((Boolean)runInstancesRequest.getMonitoring()));
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean((Boolean)runInstancesRequest.getDisableApiTermination()));
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)runInstancesRequest.getPrivateIpAddress()));
        }
        if (runInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runInstancesRequest.getClientToken()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)runInstancesRequest.getAdditionalInfo()));
        }
        if (!(networkInterfacesList = (SdkInternalList)runInstancesRequest.getNetworkInterfaces()).isEmpty() || !networkInterfacesList.isAutoConstruct()) {
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
                SdkInternalList privateIpAddressesList;
                SdkInternalList groupsList;
                if (networkInterfacesListValue.getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)networkInterfacesListValue.getNetworkInterfaceId()));
                }
                if (networkInterfacesListValue.getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)networkInterfacesListValue.getDeviceIndex()));
                }
                if (networkInterfacesListValue.getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)networkInterfacesListValue.getSubnetId()));
                }
                if (networkInterfacesListValue.getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)networkInterfacesListValue.getDescription()));
                }
                if (networkInterfacesListValue.getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)networkInterfacesListValue.getPrivateIpAddress()));
                }
                if (!(groupsList = (SdkInternalList)networkInterfacesListValue.getGroups()).isEmpty() || !groupsList.isAutoConstruct()) {
                    int groupsListIndex = 1;
                    for (String groupsListValue : groupsList) {
                        if (groupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (networkInterfacesListValue.getDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getDeleteOnTermination()));
                }
                if (!(privateIpAddressesList = (SdkInternalList)networkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !privateIpAddressesList.isAutoConstruct()) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
                        if (privateIpAddressesListValue.getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressesListValue.getPrivateIpAddress()));
                        }
                        if (privateIpAddressesListValue.getPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressesListValue.getPrimary()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (networkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)networkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                }
                if (networkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getAssociatePublicIpAddress()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if ((iamInstanceProfile = runInstancesRequest.getIamInstanceProfile()) != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)runInstancesRequest.getEbsOptimized()));
        }
        return request;
    }
}

