/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.InputStream;
import java.io.StringReader;
import org.specs2.control.Exceptions$;
import org.specs2.io.MockFileSystem;
import org.specs2.xml.Nodex$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.parsing.XhtmlParser$;

public abstract class MockFileSystem$class {
    public static String readFile(MockFileSystem $this, String path) {
        return (String)$this.files().apply((Object)path);
    }

    public static List filePaths(MockFileSystem $this, String basePath, String path, boolean verbose) {
        return $this.files().keySet().toList();
    }

    public static boolean filePaths$default$3(MockFileSystem $this) {
        return false;
    }

    public static String filePaths$default$2(MockFileSystem $this) {
        return "*";
    }

    public static String filePaths$default$1(MockFileSystem $this) {
        return ".";
    }

    public static void addFile(MockFileSystem $this, String content2) {
        $this.addFile($this.defaultFilePath(), content2);
    }

    public static void addFile(MockFileSystem $this, String path, String content2) {
        $this.files().$plus$eq(Predef$Pair$.MODULE$.apply((Object)path, (Object)content2));
        $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
    }

    public static void addChild(MockFileSystem $this, String parent, String child) {
        Option option;
        block4: {
            block3: {
                BoxedUnit boxedUnit;
                block2: {
                    option = $this.children().get((Object)parent);
                    if (!(option instanceof Some)) break block2;
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                boxedUnit = $this.children().put((Object)parent, (Object)new ListBuffer());
            }
            ((ListBuffer)$this.children().get((Object)parent).get()).$plus$eq((Object)child);
            return;
        }
        throw new MatchError((Object)option);
    }

    public static String setReadable(MockFileSystem $this, String path) {
        if (!$this.canRead(path)) {
            $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        }
        return path;
    }

    public static String setWritable(MockFileSystem $this, String path) {
        if (!$this.canWrite(path)) {
            $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
        }
        return path;
    }

    public static String setNotReadable(MockFileSystem $this, String path$4) {
        $this.readableFiles_$eq((List<String>)((List)$this.readableFiles().filterNot((Function1)new Serializable($this, path$4){
            public static final long serialVersionUID;
            private final String path$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$4;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$4 = string;
            }
        })));
        return path$4;
    }

    public static String setNotWritable(MockFileSystem $this, String path$5) {
        $this.writableFiles_$eq((List<String>)((List)$this.writableFiles().filterNot((Function1)new Serializable($this, path$5){
            public static final long serialVersionUID;
            private final String path$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$5;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$5 = string;
            }
        })));
        return path$5;
    }

    public static boolean canRead(MockFileSystem $this, String path$2) {
        return $this.readableFiles().exists((Function1)new Serializable($this, path$2){
            public static final long serialVersionUID;
            private final String path$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$2 = string;
            }
        });
    }

    public static boolean canWrite(MockFileSystem $this, String path$3) {
        return $this.writableFiles().exists((Function1)new Serializable($this, path$3){
            public static final long serialVersionUID;
            private final String path$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$3;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$3 = string;
            }
        });
    }

    public static boolean isAbsolute(MockFileSystem $this, String path) {
        return path.startsWith("/") || path.startsWith("\\");
    }

    public static boolean isHidden(MockFileSystem $this, String path) {
        return path.startsWith(".");
    }

    public static boolean isFile(MockFileSystem $this, String path) {
        return path.matches(".*\\..*");
    }

    public static boolean isDirectory(MockFileSystem $this, String path) {
        return !$this.isFile(path);
    }

    public static List listFiles(MockFileSystem $this, String path) {
        return (List)$this.children().get((Object)path.replaceAll("\\\\", "/")).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(ListBuffer<String> listBuffer) {
                return listBuffer.toList();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
    }

    public static String defaultFilePath(MockFileSystem $this) {
        return new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)$this.files().size())).append((Object)$this.defaultExtension()).toString();
    }

    public static boolean createFile(MockFileSystem $this, String path) {
        $this.files().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)path).$minus$greater((Object)""));
        return true;
    }

    public static boolean delete(MockFileSystem $this, String path) {
        $this.files().$minus$eq((Object)path);
        return true;
    }

    public static boolean mkdirs(MockFileSystem $this, String path) {
        String string = path;
        $this.createdDirs_$eq((List<String>)$this.createdDirs().$colon$colon((Object)string));
        return true;
    }

    public static boolean createDir(MockFileSystem $this, String path) {
        return $this.mkdirs(path);
    }

    public static MockFileSystem.MockFileWriter getWriter(MockFileSystem $this, String path, boolean append2) {
        return new MockFileSystem.MockFileWriter($this, path);
    }

    public static boolean getWriter$default$2(MockFileSystem $this) {
        return false;
    }

    public static MockFileSystem reset(MockFileSystem $this) {
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
        return $this;
    }

    public static boolean exists(MockFileSystem $this, String path) {
        return $this.files().contains((Object)path);
    }

    public static InputStream inputStream(MockFileSystem $this, String filePath$1) {
        return new InputStream($this, filePath$1){
            private final StringReader reader;

            private StringReader reader() {
                return this.reader;
            }

            public int read() {
                return this.reader().read();
            }
            {
                this.reader = new StringReader($outer.readFile(string));
            }
        };
    }

    public static NodeSeq loadXmlFile(MockFileSystem $this, String filePath$2, Function1 report2) {
        return (NodeSeq)Exceptions$.MODULE$.tryo(new Serializable($this, filePath$2){
            public static final long serialVersionUID;
            private final MockFileSystem $outer;
            private final String filePath$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final NodeSeq apply() {
                Source xhtml = Source$.MODULE$.fromString(new StringBuilder().append((Object)"<e>").append((Object)this.$outer.readFile(this.filePath$2)).append((Object)"</e>").toString());
                return Nodex$.MODULE$.reducable((Seq<NodeSeq>)XhtmlParser$.MODULE$.apply(xhtml).$bslash$bslash("e").apply(0).child()).reduceNodes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.filePath$2 = string;
            }
        }, (Function1<Exception, BoxedUnit>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object) {
                Exceptions$.MODULE$.implicitUnit(object);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final NodeSeq apply() {
                return NodeSeq$.MODULE$.Empty();
            }
        });
    }

    public static Function1 loadXmlFile$default$2(MockFileSystem $this, String filePath) {
        return new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Exception e) {
                e.printStackTrace();
            }
        };
    }

    public static void $init$(MockFileSystem $this) {
        $this.defaultExtension_$eq("");
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.createdDirs_$eq((List<String>)Nil$.MODULE$);
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
    }
}

