/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.io.FileSystem;
import org.specs2.io.FileSystem$$anonfun$org$specs2$io$FileSystem$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$cons$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystem$class {
    public static Seq filePaths(FileSystem $this, String basePath, String path, boolean verbose$1) {
        Stream found2 = FileSystem$class.org$specs2$io$FileSystem$$recurse($this, new File(basePath));
        if (verbose$1) {
            found2.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(File f) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"found file: ").append((Object)f).toString());
                }
            });
        }
        String pattern$1 = new StringBuilder().append((Object)$this.globToPattern(path)).append((Object)($this.isDir(path) ? "/*.*" : "")).toString();
        if (verbose$1) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\nThe pattern used to match files is: ").append((Object)pattern$1).toString());
        }
        scala.collection.immutable.Seq collected = ((scala.collection.immutable.Seq)found2.collect(new PartialFunction($this, verbose$1, pattern$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final boolean verbose$1;
            private final String pattern$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(File file) {
                File file2 = file;
                File f = file2;
                if (this.gd1$1(f)) {
                    return f.getPath();
                }
                throw new MatchError((Object)file2);
            }

            public final boolean isDefinedAt(File file) {
                File file2 = file;
                return this.gd2$1(file2);
            }

            private final boolean gd1$1(File file) {
                return FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, file, this.pattern$1, this.verbose$1);
            }

            private final boolean gd2$1(File file) {
                return FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, file, this.pattern$1, this.verbose$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.verbose$1 = bl;
                this.pattern$1 = string;
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Stream$.MODULE$.canBuildFrom())).toSeq();
        return collected;
    }

    public static boolean filePaths$default$3(FileSystem $this) {
        return false;
    }

    public static String filePaths$default$2(FileSystem $this) {
        return "*";
    }

    public static String filePaths$default$1(FileSystem $this) {
        return ".";
    }

    public static final boolean org$specs2$io$FileSystem$$isVersionFile(FileSystem $this, File f$1) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".svn", ".cvs"}))).exists((Function1)new Serializable($this, f$1){
            public static final long serialVersionUID;
            private final File f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return this.f$1.getPath().contains(string);
            }
            {
                this.f$1 = file;
            }
        });
    }

    public static final boolean org$specs2$io$FileSystem$$fileMatchesPattern(FileSystem $this, File f, String pattern, boolean verbose) {
        String filePath = new StringBuilder().append((Object)"./").append((Object)f.getPath().replace("\\", "/")).toString();
        if (verbose && f.isFile()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)filePath).append((Object)" matches pattern: ").append((Object)BoxesRunTime.boxToBoolean((boolean)filePath.matches(pattern))).toString());
        }
        return f.isFile() && filePath.matches(pattern);
    }

    private static boolean fileMatchesPattern$default$3(FileSystem $this) {
        return false;
    }

    public static final Stream org$specs2$io$FileSystem$$recurse(FileSystem $this, File file$1) {
        return Stream$cons$.MODULE$.apply((Object)file$1, (Function0)new Serializable($this, file$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final File file$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Stream<File> apply() {
                return this.file$1.listFiles() == null ? package$.MODULE$.Stream().empty() : (Stream)((Stream)Predef$.MODULE$.refArrayOps((Object[])this.file$1.listFiles()).toStream().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(File file) {
                        return FileSystem$class.org$specs2$io$FileSystem$$isVersionFile(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), file);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Stream<File> apply(File file) {
                        return FileSystem$class.org$specs2$io$FileSystem$$recurse(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), file);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, package$.MODULE$.Stream().canBuildFrom());
            }

            public FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.file$1 = file;
            }
        });
    }

    public static String globToPattern(FileSystem $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        String pattern = glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
        if (!pattern.startsWith("\\./")) {
            pattern = new StringBuilder().append((Object)"\\./").append((Object)pattern).toString();
        }
        return pattern;
    }

    public static boolean isDir(FileSystem $this, String path) {
        return $this.isDirectory(path);
    }

    public static boolean createDir(FileSystem $this, String path) {
        return new File(path).mkdirs();
    }

    public static String removeDir(FileSystem $this, String path) {
        Object object;
        File dir = new File(path);
        if (dir.isDirectory()) {
            boolean bl;
            if (dir.listFiles() == null || Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).isEmpty()) {
                bl = dir.delete();
            } else {
                Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID;
                    private final FileSystem $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(File file) {
                        return file.isFile() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : this.$outer.removeDir(file.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                bl = dir.delete();
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return dir.getParent();
    }

    public static boolean canRead(FileSystem $this, String path) {
        return path != null && new File(path).canRead();
    }

    public static boolean canWrite(FileSystem $this, String path) {
        return path != null && new File(path).canWrite();
    }

    public static boolean isAbsolute(FileSystem $this, String path) {
        return path != null && new File(path).isAbsolute();
    }

    public static boolean isFile(FileSystem $this, String path) {
        return path != null && new File(path).isFile();
    }

    public static boolean isDirectory(FileSystem $this, String path) {
        return path != null && new File(path).isDirectory();
    }

    public static boolean isHidden(FileSystem $this, String path) {
        return path != null && new File(path).isHidden();
    }

    public static String getName(FileSystem $this, String path) {
        return new File(path).getName();
    }

    public static String getAbsolutePath(FileSystem $this, String path) {
        return new File(path).getAbsolutePath();
    }

    public static String getCanonicalPath(FileSystem $this, String path) {
        return new File(path).getCanonicalPath();
    }

    public static String getParent(FileSystem $this, String path) {
        return new File(path).getParent();
    }

    public static List listFiles(FileSystem $this, String path) {
        return new File(path).list() == null ? Nil$.MODULE$ : Predef$.MODULE$.refArrayOps((Object[])new File(path).list()).toList();
    }

    public static void copyDir(FileSystem $this, URL url, String dest) {
        $this.copyDir(new File(url.toURI()).getPath(), dest);
    }

    public static void copyDir(FileSystem $this, String src$1, String dest$1) {
        ((LinearSeqOptimized)$this.listFiles(src$1).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return string.contains(".svn");
            }
        })).foreach((Function1)new Serializable($this, src$1, dest$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final String src$1;
            private final String dest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String name) {
                String path = new StringBuilder().append((Object)this.src$1).append((Object)"/").append((Object)name).toString();
                if (new File(path).isDirectory()) {
                    this.$outer.copyDir(path, this.dest$1);
                } else {
                    this.$outer.copyFile(path, this.dest$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$1 = string;
                this.dest$1 = string2;
            }
        });
    }

    public static void copyFile(FileSystem $this, String path, String dest) {
        $this.mkdirs(dest);
        String destFilePath = new StringBuilder().append((Object)dest).append((Object)"/").append((Object)new File(path).getName()).toString();
        new File(destFilePath).createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destFilePath), 2048);
        $this.copy(input, output);
        output.flush();
        output.close();
        input.close();
    }

    public static void unjar(FileSystem $this, String path, String dest) {
        $this.unjar(path, dest, ".*");
    }

    public static void unjar(FileSystem $this, String path, String dirPath$1, String regexFilter$1) {
        $this.mkdirs(dirPath$1);
        FileInputStream fis = new FileInputStream(path);
        ZipInputStream zis$1 = new ZipInputStream(new BufferedInputStream(fis));
        Object entry = null;
        FileSystem$class.extractEntry$1($this, zis$1.getNextEntry(), dirPath$1, regexFilter$1, zis$1);
        zis$1.close();
    }

    public static void copy(FileSystem $this, InputStream input$1, OutputStream output$1) {
        byte[] data$1 = new byte[2048];
        FileSystem$class.readData$1($this, input$1.read(data$1, 0, 2048), input$1, output$1, data$1);
    }

    public static void copySpecResourcesDir(FileSystem $this, String src$2, String outputDir$1) {
        URL jarUrl = Thread.currentThread().getContextClassLoader().getResource(new StringBuilder().append((Object)$this.getClass().getName().replace(".", "/")).append((Object)".class").toString());
        Option$.MODULE$.apply((Object)jarUrl).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(URL url) {
                return url.toString().startsWith("jar");
            }
        }).foreach((Function1)new Serializable($this, src$2, outputDir$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final String src$2;
            private final String outputDir$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(URL url) {
                this.$outer.unjar(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.augmentString(FileSystem$class.org$specs2$io$FileSystem$$getPath(this.$outer, url)).takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(char c) {
                        return c != '!';
                    }
                })).mkString(), this.outputDir$1, new StringBuilder().append((Object)".*").append((Object)this.src$2).append((Object)"/.*").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$2 = string;
                this.outputDir$1 = string2;
            }
        });
        URL folderUrl$1 = Thread.currentThread().getContextClassLoader().getResource(src$2);
        Option$.MODULE$.apply((Object)folderUrl$1).withFilter((Function1)new Serializable($this, folderUrl$1){
            public static final long serialVersionUID;
            private final URL folderUrl$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(URL url) {
                return !this.folderUrl$1.toString().startsWith("jar");
            }
            {
                this.folderUrl$1 = uRL;
            }
        }).foreach((Function1)new Serializable($this, src$2, outputDir$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final String src$2;
            private final String outputDir$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(URL url) {
                this.$outer.copyDir(url, new StringBuilder().append((Object)this.outputDir$1).append((Object)this.src$2).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$2 = string;
                this.outputDir$1 = string2;
            }
        });
    }

    public static final String org$specs2$io$FileSystem$$getPath(FileSystem $this, URL url) {
        Object object = scala.sys.package$.MODULE$.props().apply((Object)"file.separator");
        String string = "\\";
        String path = !(object != null ? !object.equals(string) : string != null) ? url.getPath().replace("\\", "/").replace("file:/", "") : url.getPath().replace("file:", "");
        return path.replace("%20", " ");
    }

    private static final void extractEntry$1(FileSystem $this, ZipEntry entry, String string, String string2, ZipInputStream zipInputStream) {
        while (entry != null) {
            Object object;
            if (entry.getName().matches(string2)) {
                if (entry.isDirectory()) {
                    object = BoxesRunTime.boxToBoolean((boolean)$this.createDir(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString()));
                } else {
                    $this.createFile(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString());
                    FileOutputStream fos = new FileOutputStream(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString());
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    $this.copy(zipInputStream, dest);
                    dest.flush();
                    dest.close();
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            entry = zipInputStream.getNextEntry();
        }
        return;
    }

    private static final void readData$1(FileSystem $this, int count, InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        while (count != -1) {
            outputStream.write(byArray, 0, count);
            outputStream.flush();
            count = inputStream.read(byArray, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

