/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

public class MapConfigurator
extends Configurator.Adapter {
    private final Map<String, Object> config;
    private final List<ThirdPartyJaxRsPackage> extensions;

    public MapConfigurator(Map<String, Object> config, List<ThirdPartyJaxRsPackage> extensions) {
        this.config = config;
        this.extensions = extensions;
    }

    public Map<String, String> getDatabaseTuningProperties() {
        return this.toStringStringMap(this.config);
    }

    private Map<String, String> toStringStringMap(Map<String, Object> config) {
        HashMap<String, String> converted = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            converted.put(entry.getKey(), entry.getValue().toString());
        }
        return converted;
    }

    public Configuration configuration() {
        return new MapBasedConfiguration(this.config);
    }

    public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsClasses() {
        return this.extensions;
    }

    public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
        return this.extensions;
    }
}

