/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.Node;

public class XmlDeclaration
extends Node {
    public XmlDeclaration(Tag tag, boolean caseSensitive) {
        super(Node.NodeType.XML_DECLARATION, tag.getName(), caseSensitive);
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = tag.getAttributeName(i);
            String value = tag.getAttributeValue(i);
            this.setAttribute(key, value);
        }
    }

    public XmlDeclaration(String name) {
        this(name, false);
    }

    public XmlDeclaration(String name, boolean caseSensitive) {
        super(Node.NodeType.XML_DECLARATION, name, caseSensitive);
    }

    public XmlDeclaration clone() {
        return this.cloneTo(new XmlDeclaration(this.nodeName, this.caseSensitive));
    }

    public void toHtml(Appendable appendable) throws IOException {
        appendable.append("<?");
        appendable.append(this.nodeName);
        int attrCount = this.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = this.getAttribute(i);
                appendable.append(' ');
                attr.toHtml(appendable);
            }
        }
        appendable.append("?>");
    }
}

