/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.LinkedList;
import jodd.lagarto.LagartoLexer;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.HtmlImplicitClosingRules;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMBuilderTagVisitor
implements TagVisitor {
    private static final Logger log = LoggerFactory.getLogger(DOMBuilderTagVisitor.class);
    protected final LagartoDOMBuilder domBuilder;
    protected final HtmlImplicitClosingRules implRules = new HtmlImplicitClosingRules();
    private long startTime;
    protected Document rootNode;
    protected Node parentNode;
    protected boolean enabled;

    public DOMBuilderTagVisitor(LagartoDOMBuilder domBuilder) {
        this.domBuilder = domBuilder;
    }

    public Document getDocument() {
        return this.rootNode;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("DomTree builder started.");
        }
        this.rootNode = new Document();
        this.parentNode = this.rootNode;
        this.enabled = true;
    }

    public void end() {
        if (this.parentNode != this.rootNode && !this.domBuilder.isImpliedEndTags() && log.isWarnEnabled()) {
            String positionString = "";
            if (this.parentNode.position != null) {
                positionString = this.parentNode.position.toString();
            }
            log.warn("Some unclosed tags are closed: <" + this.parentNode.getNodeName() + "> " + positionString);
        }
        if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, true);
        }
        this.domBuilder.elapsed = System.currentTimeMillis() - this.startTime;
        if (log.isDebugEnabled()) {
            log.debug("LagartoDom tree created in " + this.domBuilder.elapsed + " ms.");
        }
    }

    protected Element createElementNode(Tag tag) {
        boolean isVoid = this.domBuilder.isVoidTag(tag.getName());
        boolean selfClosed = false;
        if (this.domBuilder.hasVoidTags()) {
            if (isVoid) {
                selfClosed = this.domBuilder.isSelfCloseVoidTags();
            }
        } else {
            selfClosed = this.domBuilder.isSelfCloseVoidTags();
        }
        Element element = new Element(tag, isVoid, selfClosed, this.domBuilder.isCaseSensitive());
        if (this.domBuilder.isCalculatePosition()) {
            element.position = this.calculatePosition(tag);
        }
        return element;
    }

    public void tag(Tag tag) {
        if (!this.enabled) {
            return;
        }
        TagType tagType = tag.getType();
        switch (tagType) {
            case START: {
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                if (this.domBuilder.isImpliedEndTags()) {
                    String parentNodeName;
                    while (this.implRules.implicitlyCloseParentTagOnNewTag(parentNodeName = this.parentNode.getNodeName(), node.getNodeName())) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (!log.isDebugEnabled()) continue;
                        String positionString = "";
                        if (this.parentNode.position != null) {
                            positionString = this.parentNode.position.toString();
                        }
                        log.debug("Implicitly closed tag <" + node.getNodeName() + "> " + positionString);
                    }
                }
                this.parentNode.addChild((Node)node);
                if (node.isVoidElement()) break;
                this.parentNode = node;
                break;
            }
            case END: {
                String tagName;
                Node matchingParent;
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, true);
                }
                if ((matchingParent = this.findMatchingParentOpenTag(tagName = tag.getName())) == this.parentNode) {
                    this.parentNode = this.parentNode.getParentNode();
                    break;
                }
                if (matchingParent == null) {
                    String positionString = "";
                    if (this.domBuilder.isCalculatePosition()) {
                        positionString = this.calculatePosition(tag).toString();
                    }
                    this.error("Orphan closed tag ignored: </" + tagName + "> " + positionString);
                    break;
                }
                if (this.domBuilder.isImpliedEndTags()) {
                    boolean fixed = false;
                    while (this.implRules.implicitlyCloseParentTagOnTagEnd(this.parentNode.getNodeName(), tagName)) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (log.isDebugEnabled()) {
                            String positionString = "";
                            if (this.parentNode.position != null) {
                                positionString = this.parentNode.position.toString();
                            }
                            log.debug("Implicitly closed tag <" + tagName + "> " + positionString);
                        }
                        if (this.parentNode != matchingParent) continue;
                        this.parentNode = matchingParent.parentNode;
                        fixed = true;
                        break;
                    }
                    if (fixed) break;
                }
                this.fixUnclosedTagsUpToMatchingParent(matchingParent);
                break;
            }
            case SELF_CLOSING: {
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                this.parentNode.addChild((Node)node);
            }
        }
    }

    protected void removeLastChildNodeIfEmptyText(Node parentNode, boolean closedTag) {
        if (parentNode == null) {
            return;
        }
        Node lastChild = parentNode.getLastChild();
        if (lastChild == null) {
            return;
        }
        if (lastChild.getNodeType() != Node.NodeType.TEXT) {
            return;
        }
        if (closedTag && parentNode.getChildNodesCount() == 1) {
            return;
        }
        Text text = (Text)lastChild;
        if (text.isBlank()) {
            lastChild.detachFromParent();
        }
    }

    protected Node findMatchingParentOpenTag(String tagName) {
        Node parent = this.parentNode;
        if (!this.domBuilder.isCaseSensitive()) {
            tagName = tagName.toLowerCase();
        }
        while (parent != null) {
            String parentNodeName = parent.getNodeName();
            if (parentNodeName != null && !this.domBuilder.isCaseSensitive()) {
                parentNodeName = parentNodeName.toLowerCase();
            }
            if (tagName.equals(parentNodeName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    protected void fixUnclosedTagsUpToMatchingParent(Node matchingParent) {
        LinkedList<Node> finalNodes = new LinkedList<Node>();
        while (true) {
            if (this.parentNode == matchingParent) break;
            Node parentParentNode = this.parentNode.getParentNode();
            this.parentNode.detachFromParent();
            String positionString = "";
            if (this.parentNode.position != null) {
                positionString = this.parentNode.position.toString();
            }
            this.error("Unclosed tag closed: <" + this.parentNode.getNodeName() + "> " + positionString);
            finalNodes.addFirst(this.parentNode);
            this.parentNode = parentParentNode;
        }
        this.parentNode = this.parentNode.getParentNode();
        Node[] newChilds = new Node[finalNodes.size()];
        for (int i = 0; i < finalNodes.size(); ++i) {
            Node node;
            newChilds[i] = node = (Node)finalNodes.get(i);
        }
        matchingParent.addChild(newChilds);
    }

    public void xmp(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(body.toString());
            node.addChild((Node)text);
        }
    }

    public void style(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(body.toString());
            node.addChild((Node)text);
        }
    }

    public void script(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(body.toString());
            node.addChild((Node)text);
        }
    }

    public void comment(CharSequence comment) {
        if (!this.enabled) {
            return;
        }
        if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, false);
        }
        if (this.domBuilder.isIgnoreComments()) {
            return;
        }
        Comment node = new Comment(comment.toString());
        this.parentNode.addChild((Node)node);
    }

    public void text(CharSequence text) {
        if (!this.enabled) {
            return;
        }
        String textValue = text.toString();
        Text node = new Text(textValue);
        this.parentNode.addChild((Node)node);
    }

    public void cdata(CharSequence cdata) {
        if (!this.enabled) {
            return;
        }
        CData cdataNode = new CData(cdata.toString());
        this.parentNode.addChild((Node)cdataNode);
    }

    public void xml(Tag tag) {
        if (!this.enabled) {
            return;
        }
        XmlDeclaration xmlDeclaration = new XmlDeclaration(tag, this.domBuilder.isCaseSensitive());
        this.parentNode.addChild((Node)xmlDeclaration);
    }

    public void doctype(String name, String publicId, String baseUri) {
        if (!this.enabled) {
            return;
        }
        DocumentType documentType = new DocumentType(name, publicId, baseUri);
        this.parentNode.addChild((Node)documentType);
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, CharSequence comment) {
        String defaultExpression = this.domBuilder.getConditionalCommentExpression();
        if (defaultExpression != null) {
            String expressionString = expression.toString().trim();
            if (!expressionString.equals(defaultExpression)) {
                this.enabled = expressionString.equals("endif");
            }
        } else {
            if (!this.enabled) {
                return;
            }
            String additionalComment = comment != null ? comment.toString() : null;
            Comment commentNode = new Comment(expression.toString(), isStartingTag, isHidden, additionalComment);
            this.parentNode.addChild((Node)commentNode);
        }
    }

    public void error(String message) {
        if (this.domBuilder.isCollectErrors()) {
            if (this.domBuilder.errors == null) {
                this.domBuilder.errors = new LinkedList<String>();
            }
            this.domBuilder.errors.add(message);
        }
        if (log.isWarnEnabled()) {
            log.warn(message);
        }
    }

    protected LagartoLexer.Position calculatePosition(Tag tag) {
        LagartoLexer lexer = this.domBuilder.getLexer();
        LagartoLexer.Position position = lexer.currentPosition();
        int column = position.column;
        if (tag.getName() != null) {
            column -= tag.getName().length();
        }
        for (int i = 0; i < tag.getAttributeCount(); ++i) {
            column -= tag.getAttributeName(i).length();
            String value = tag.getAttributeValue(i);
            if (value != null) {
                column -= value.length();
                --column;
            }
            --column;
        }
        int diff = position.column - column;
        position.column = column;
        position.offset -= diff;
        return position;
    }
}

