/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly;

import java.util.LinkedList;
import java.util.List;
import jodd.csselly.Combinator;
import jodd.csselly.Selector;
import jodd.csselly.selector.AttributeSelector;
import jodd.csselly.selector.Match;
import jodd.csselly.selector.PseudoClassSelector;
import jodd.csselly.selector.PseudoFunctionSelector;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSelector
implements NodeFilter {
    private static final String ID = "id";
    private static final String CLASS = "class";
    protected CssSelector prevCssSelector;
    protected CssSelector nextCssSelector;
    protected final String element;
    protected Combinator combinator = Combinator.DESCENDANT;
    protected List<Selector> selectors;

    public CssSelector() {
        this(null);
    }

    public CssSelector(String element) {
        if (element == null) {
            element = "*";
        }
        this.element = this.unescape(element);
        this.selectors = new LinkedList<Selector>();
    }

    public CssSelector getPrevCssSelector() {
        return this.prevCssSelector;
    }

    public CssSelector getNextCssSelector() {
        return this.nextCssSelector;
    }

    void setPrevCssSelector(CssSelector prevCssSelector) {
        this.prevCssSelector = prevCssSelector;
        prevCssSelector.nextCssSelector = this;
    }

    public String getElement() {
        return this.element;
    }

    public Selector getSelector(int index) {
        return this.selectors.get(index);
    }

    public int selectorsCount() {
        return this.selectors.size();
    }

    public void setCombinator(Combinator combinator) {
        this.combinator = combinator;
    }

    public Combinator getCombinator() {
        return this.combinator;
    }

    public void addIdSelector(String id) {
        id = this.unescape(id);
        this.selectors.add(new AttributeSelector(ID, Match.EQUALS, id));
    }

    public void addClassSelector(String clazz) {
        clazz = this.unescape(clazz);
        this.selectors.add(new AttributeSelector(CLASS, Match.INCLUDES, clazz));
    }

    public void addAttributeSelector(String attribute) {
        attribute = this.unescape(attribute);
        this.selectors.add(new AttributeSelector(attribute));
    }

    public void addPseudoClassSelector(String pseudoClass) {
        this.selectors.add(new PseudoClassSelector(pseudoClass));
    }

    public void addPseudoFunctionSelector(String pseudoFunction, String expression) {
        this.selectors.add(new PseudoFunctionSelector(pseudoFunction, expression));
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.element);
        for (Selector selector : this.selectors) {
            switch (selector.getType()) {
                case ATTRIBUTE: {
                    AttributeSelector attrSelector = (AttributeSelector)selector;
                    String attrName = attrSelector.getName();
                    if (attrName.equals(ID)) {
                        out.append('#').append(attrSelector.getValue());
                        break;
                    }
                    if (attrName.equals(CLASS)) {
                        out.append('.').append(attrSelector.getValue());
                        break;
                    }
                    out.append('[').append(attrSelector.getName());
                    String value = attrSelector.getValue();
                    if (value != null) {
                        out.append(attrSelector.getMatch().getSign());
                        char quote = attrSelector.getQuoteChar();
                        if (quote != '\u0000') {
                            out.append(quote);
                        }
                        out.append(value);
                        if (quote != '\u0000') {
                            out.append(quote);
                        }
                    }
                    out.append(']');
                    break;
                }
                case PSEUDO_CLASS: {
                    PseudoClassSelector psc = (PseudoClassSelector)selector;
                    out.append(':').append(psc.getPseudoClass().getPseudoClassName());
                    break;
                }
                case PSEUDO_FUNCTION: {
                    PseudoFunctionSelector pfns = (PseudoFunctionSelector)selector;
                    out.append(':').append(pfns.getPseudoFunction().getPseudoFunctionName()).append('(');
                    out.append(pfns.getExpression()).append(')');
                }
            }
        }
        if (this.nextCssSelector != null) {
            if (this.combinator != Combinator.DESCENDANT) {
                out.append(' ');
            }
            out.append(this.combinator.getSign());
            if (this.combinator != Combinator.DESCENDANT) {
                out.append(' ');
            }
        }
        return out.toString();
    }

    @Override
    public boolean accept(Node node) {
        if (!this.matchElement(node)) {
            return false;
        }
        int totalSelectors = this.selectorsCount();
        block5: for (int i = 0; i < totalSelectors; ++i) {
            Selector selector = this.getSelector(i);
            switch (selector.getType()) {
                case ATTRIBUTE: {
                    if (((AttributeSelector)selector).accept(node)) continue block5;
                    return false;
                }
                case PSEUDO_CLASS: {
                    if (((PseudoClassSelector)selector).accept(node)) continue block5;
                    return false;
                }
                case PSEUDO_FUNCTION: {
                    if (((PseudoFunctionSelector)selector).accept(node)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchElement(Node node) {
        if (node.getNodeType() != Node.NodeType.ELEMENT) {
            return false;
        }
        String element = this.getElement();
        String nodeName = node.getNodeName();
        return element.equals("*") || element.equals(nodeName);
    }

    public boolean accept(LinkedList<Node> currentResults, Node node, int index) {
        int totalSelectors = this.selectorsCount();
        block4: for (int i = 0; i < totalSelectors; ++i) {
            Selector selector = this.getSelector(i);
            switch (selector.getType()) {
                case PSEUDO_FUNCTION: {
                    if (((PseudoFunctionSelector)selector).accept(currentResults, node, index)) continue block4;
                    return false;
                }
                case PSEUDO_CLASS: {
                    if (((PseudoClassSelector)selector).accept(currentResults, node, index)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    protected String unescape(String value) {
        if (value.indexOf(92) == -1) {
            return value;
        }
        return StringUtil.remove((String)value, (char)'\\');
    }
}

