/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class S3Repository
extends BlobStoreRepository {
    public static final String TYPE = "s3";
    private final S3BlobStore blobStore;
    private final BlobPath basePath;
    private ByteSizeValue chunkSize;
    private boolean compress;

    @Inject
    public S3Repository(RepositoryName name, RepositorySettings repositorySettings, IndexShardRepository indexShardRepository, AwsS3Service s3Service) throws IOException {
        super(name.getName(), repositorySettings, indexShardRepository);
        String regionSetting;
        String bucket = repositorySettings.settings().get("bucket", this.componentSettings.get("bucket"));
        if (bucket == null) {
            throw new RepositoryException(name.name(), "No bucket defined for s3 gateway");
        }
        String endpoint = repositorySettings.settings().get("endpoint", this.componentSettings.get("endpoint"));
        String protocol = repositorySettings.settings().get("protocol", this.componentSettings.get("protocol"));
        String region = repositorySettings.settings().get("region", this.componentSettings.get("region"));
        if (region == null && (regionSetting = repositorySettings.settings().get("cloud.aws.region", this.settings.get("cloud.aws.region"))) != null) {
            if ("us-east".equals(regionSetting = regionSetting.toLowerCase(Locale.ENGLISH)) || "us-east-1".equals(regionSetting)) {
                region = null;
            } else if ("us-west".equals(regionSetting) || "us-west-1".equals(regionSetting)) {
                region = "us-west-1";
            } else if ("us-west-2".equals(regionSetting)) {
                region = "us-west-2";
            } else if ("ap-southeast".equals(regionSetting) || "ap-southeast-1".equals(regionSetting)) {
                region = "ap-southeast-1";
            } else if ("ap-southeast-2".equals(regionSetting)) {
                region = "ap-southeast-2";
            } else if ("ap-northeast".equals(regionSetting) || "ap-northeast-1".equals(regionSetting)) {
                region = "ap-northeast-1";
            } else if ("eu-west".equals(regionSetting) || "eu-west-1".equals(regionSetting)) {
                region = "eu-west-1";
            } else if ("eu-central".equals(regionSetting) || "eu-central-1".equals(regionSetting)) {
                region = "eu-central-1";
            } else if ("sa-east".equals(regionSetting) || "sa-east-1".equals(regionSetting)) {
                region = "sa-east-1";
            } else if ("cn-north".equals(regionSetting) || "cn-north-1".equals(regionSetting)) {
                region = "cn-north-1";
            }
        }
        boolean serverSideEncryption = repositorySettings.settings().getAsBoolean("server_side_encryption", this.componentSettings.getAsBoolean("server_side_encryption", Boolean.valueOf(false)));
        ByteSizeValue bufferSize = repositorySettings.settings().getAsBytesSize("buffer_size", this.componentSettings.getAsBytesSize("buffer_size", null));
        Integer maxRetries = repositorySettings.settings().getAsInt("max_retries", this.componentSettings.getAsInt("max_retries", Integer.valueOf(3)));
        this.chunkSize = repositorySettings.settings().getAsBytesSize("chunk_size", this.componentSettings.getAsBytesSize("chunk_size", new ByteSizeValue(100L, ByteSizeUnit.MB)));
        this.compress = repositorySettings.settings().getAsBoolean("compress", this.componentSettings.getAsBoolean("compress", Boolean.valueOf(false)));
        this.logger.debug("using bucket [{}], region [{}], endpoint [{}], protocol [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], max_retries [{}]", new Object[]{bucket, region, endpoint, protocol, this.chunkSize, serverSideEncryption, bufferSize, maxRetries});
        this.blobStore = new S3BlobStore(this.settings, s3Service.client(endpoint, protocol, region, repositorySettings.settings().get("access_key"), repositorySettings.settings().get("secret_key"), maxRetries), bucket, region, serverSideEncryption, bufferSize, maxRetries);
        String basePath = repositorySettings.settings().get("base_path", null);
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : Strings.splitStringToArray((CharSequence)basePath, (char)'/')) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
    }

    protected BlobStore blobStore() {
        return this.blobStore;
    }

    protected BlobPath basePath() {
        return this.basePath;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }
}

