/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import org.elasticsearch.Version;
import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.ec2.AwsEc2UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class Ec2Discovery
extends ZenDiscovery {
    @Inject
    public Ec2Discovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, ZenPingService pingService, DiscoveryNodeService discoveryNodeService, AwsEc2Service ec2Service, DiscoverySettings discoverySettings, ElectMasterService electMasterService, @ClusterDynamicSettings DynamicSettings dynamicSettings, Version version) {
        super(settings, clusterName, threadPool, transportService, clusterService, nodeSettingsService, discoveryNodeService, pingService, electMasterService, discoverySettings, dynamicSettings);
        if (settings.getAsBoolean("cloud.enabled", Boolean.valueOf(true)).booleanValue()) {
            ImmutableList zenPings = pingService.zenPings();
            UnicastZenPing unicastZenPing = null;
            for (ZenPing zenPing : zenPings) {
                if (!(zenPing instanceof UnicastZenPing)) continue;
                unicastZenPing = (UnicastZenPing)zenPing;
                break;
            }
            if (unicastZenPing != null) {
                unicastZenPing.addHostsProvider((UnicastHostsProvider)new AwsEc2UnicastHostsProvider(settings, transportService, ec2Service.client(), version));
                pingService.zenPings(ImmutableList.of((Object)unicastZenPing));
            } else {
                this.logger.warn("failed to apply ec2 unicast discovery, no unicast ping found", new Object[0]);
            }
        }
    }
}

