/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class AwsEc2UnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final TransportService transportService;
    private final AmazonEC2 client;
    private final Version version;
    private final boolean bindAnyGroup;
    private final ImmutableSet<String> groups;
    private final ImmutableMap<String, String> tags;
    private final ImmutableSet<String> availabilityZones;
    private final HostType hostType;

    @Inject
    public AwsEc2UnicastHostsProvider(Settings settings, TransportService transportService, AmazonEC2 client, Version version) {
        super(settings);
        this.transportService = transportService;
        this.client = client;
        this.version = version;
        this.hostType = HostType.valueOf(this.componentSettings.get("host_type", "private_ip").toUpperCase());
        this.bindAnyGroup = this.componentSettings.getAsBoolean("any_group", Boolean.valueOf(true));
        this.groups = ImmutableSet.copyOf((Object[])this.componentSettings.getAsArray("groups"));
        this.tags = this.componentSettings.getByPrefix("tag.").getAsMap();
        HashSet availabilityZones = Sets.newHashSet((Object[])this.componentSettings.getAsArray("availability_zones"));
        if (this.componentSettings.get("availability_zones") != null) {
            availabilityZones.addAll(Strings.commaDelimitedListToSet((String)this.componentSettings.get("availability_zones")));
        }
        this.availabilityZones = ImmutableSet.copyOf((Collection)availabilityZones);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using host_type [{}], tags [{}], groups [{}] with any_group [{}], availability_zones [{}]", new Object[]{this.hostType, this.tags, this.groups, this.bindAnyGroup, availabilityZones});
        }
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        DescribeInstancesResult descInstances;
        ArrayList discoNodes = Lists.newArrayList();
        try {
            descInstances = this.client.describeInstances(this.buildDescribeInstancesRequest());
        }
        catch (AmazonClientException e) {
            this.logger.info("Exception while retrieving instance list from AWS API: {}", new Object[]{e.getMessage()});
            this.logger.debug("Full exception:", (Throwable)e, new Object[0]);
            return discoNodes;
        }
        this.logger.trace("building dynamic unicast discovery nodes...", new Object[0]);
        for (Reservation reservation : descInstances.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                if (!this.groups.isEmpty()) {
                    List instanceSecurityGroups = instance.getSecurityGroups();
                    ArrayList<String> securityGroupNames = new ArrayList<String>();
                    ArrayList<String> securityGroupIds = new ArrayList<String>();
                    for (GroupIdentifier sg : instanceSecurityGroups) {
                        securityGroupNames.add(sg.getGroupName());
                        securityGroupIds.add(sg.getGroupId());
                    }
                    if (this.bindAnyGroup) {
                        if (Collections.disjoint(securityGroupNames, this.groups) && Collections.disjoint(securityGroupIds, this.groups)) {
                            this.logger.trace("filtering out instance {} based on groups {}, not part of {}", new Object[]{instance.getInstanceId(), instanceSecurityGroups, this.groups});
                            continue;
                        }
                    } else if (!securityGroupNames.containsAll((Collection<?>)this.groups) && !securityGroupIds.containsAll((Collection<?>)this.groups)) {
                        this.logger.trace("filtering out instance {} based on groups {}, does not include all of {}", new Object[]{instance.getInstanceId(), instanceSecurityGroups, this.groups});
                        continue;
                    }
                }
                String address = null;
                switch (this.hostType) {
                    case PRIVATE_DNS: {
                        address = instance.getPrivateDnsName();
                        break;
                    }
                    case PRIVATE_IP: {
                        address = instance.getPrivateIpAddress();
                        break;
                    }
                    case PUBLIC_DNS: {
                        address = instance.getPublicDnsName();
                        break;
                    }
                    case PUBLIC_IP: {
                        address = instance.getPublicIpAddress();
                    }
                }
                if (address != null) {
                    try {
                        TransportAddress[] addresses = this.transportService.addressesFromString(address);
                        for (int i = 0; i < addresses.length && i < 1; ++i) {
                            this.logger.trace("adding {}, address {}, transport_address {}", new Object[]{instance.getInstanceId(), address, addresses[i]});
                            discoNodes.add(new DiscoveryNode("#cloud-" + instance.getInstanceId() + "-" + i, addresses[i], this.version.minimumCompatibilityVersion()));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.warn("failed ot add {}, address {}", (Throwable)e, new Object[]{instance.getInstanceId(), address});
                        continue;
                    }
                }
                this.logger.trace("not adding {}, address is null, host_type {}", new Object[]{instance.getInstanceId(), this.hostType});
            }
        }
        this.logger.debug("using dynamic discovery nodes {}", new Object[]{discoNodes});
        return discoNodes;
    }

    private DescribeInstancesRequest buildDescribeInstancesRequest() {
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("instance-state-name").withValues(new String[]{"running", "pending"})});
        for (Map.Entry tagFilter : this.tags.entrySet()) {
            describeInstancesRequest.withFilters(new Filter[]{new Filter("tag:" + (String)tagFilter.getKey()).withValues(new String[]{(String)tagFilter.getValue()})});
        }
        if (!this.availabilityZones.isEmpty()) {
            describeInstancesRequest.withFilters(new Filter[]{new Filter("availability-zone").withValues(this.availabilityZones)});
        }
        return describeInstancesRequest;
    }

    private static enum HostType {
        PRIVATE_IP,
        PUBLIC_IP,
        PRIVATE_DNS,
        PUBLIC_DNS;

    }
}

