/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.blobstore;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import org.elasticsearch.cloud.aws.blobstore.S3BlobContainer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class S3BlobStore
extends AbstractComponent
implements BlobStore {
    public static final ByteSizeValue MIN_BUFFER_SIZE = new ByteSizeValue(5L, ByteSizeUnit.MB);
    private final AmazonS3 client;
    private final String bucket;
    private final String region;
    private final ByteSizeValue bufferSize;
    private final boolean serverSideEncryption;
    private final int numberOfRetries;

    public S3BlobStore(Settings settings, AmazonS3 client, String bucket, @Nullable String region, boolean serverSideEncryption, ByteSizeValue bufferSize, int maxRetries) {
        super(settings);
        this.client = client;
        this.bucket = bucket;
        this.region = region;
        this.serverSideEncryption = serverSideEncryption;
        ByteSizeValue byteSizeValue = this.bufferSize = bufferSize != null ? bufferSize : MIN_BUFFER_SIZE;
        if (this.bufferSize.getBytes() < MIN_BUFFER_SIZE.getBytes()) {
            throw new BlobStoreException("Detected a buffer_size for the S3 storage lower than [" + MIN_BUFFER_SIZE + "]");
        }
        this.numberOfRetries = maxRetries;
        if (!client.doesBucketExist(bucket)) {
            if (region != null) {
                client.createBucket(bucket, region);
            } else {
                client.createBucket(bucket);
            }
        }
    }

    public String toString() {
        return (this.region == null ? "" : this.region + "/") + this.bucket;
    }

    public AmazonS3 client() {
        return this.client;
    }

    public String bucket() {
        return this.bucket;
    }

    public boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public int bufferSizeInBytes() {
        return this.bufferSize.bytesAsInt();
    }

    public int numberOfRetries() {
        return this.numberOfRetries;
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new S3BlobContainer(path, this);
    }

    public void delete(BlobPath path) {
        ObjectListing prevListing = null;
        DeleteObjectsRequest multiObjectDeleteRequest = null;
        ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        while (true) {
            ObjectListing list;
            if (prevListing != null) {
                list = this.client.listNextBatchOfObjects(prevListing);
            } else {
                String keyPath = path.buildAsString("/");
                if (!keyPath.isEmpty()) {
                    keyPath = keyPath + "/";
                }
                list = this.client.listObjects(this.bucket, keyPath);
                multiObjectDeleteRequest = new DeleteObjectsRequest(list.getBucketName());
            }
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                if (keys.size() <= 500) continue;
                multiObjectDeleteRequest.setKeys(keys);
                this.client.deleteObjects(multiObjectDeleteRequest);
                multiObjectDeleteRequest = new DeleteObjectsRequest(list.getBucketName());
                keys.clear();
            }
            if (!list.isTruncated()) break;
            prevListing = list;
        }
        if (!keys.isEmpty()) {
            multiObjectDeleteRequest.setKeys(keys);
            this.client.deleteObjects(multiObjectDeleteRequest);
        }
    }

    protected boolean shouldRetry(AmazonClientException e) {
        AmazonS3Exception s3e;
        if (e instanceof AmazonS3Exception && (s3e = (AmazonS3Exception)e).getStatusCode() == 400 && "RequestTimeout".equals(s3e.getErrorCode())) {
            return true;
        }
        return e.isRetryable();
    }

    public void close() {
    }
}

