/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.blobstore;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.cloud.aws.blobstore.DefaultS3OutputStream;
import org.elasticsearch.cloud.aws.blobstore.S3BlobStore;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;

public class S3BlobContainer
extends AbstractBlobContainer {
    protected final S3BlobStore blobStore;
    protected final String keyPath;

    public S3BlobContainer(BlobPath path, S3BlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        String keyPath = path.buildAsString("/");
        if (!keyPath.isEmpty()) {
            keyPath = keyPath + "/";
        }
        this.keyPath = keyPath;
    }

    public boolean blobExists(String blobName) {
        try {
            this.blobStore.client().getObjectMetadata(this.blobStore.bucket(), this.buildKey(blobName));
            return true;
        }
        catch (AmazonS3Exception e) {
            return false;
        }
        catch (Throwable e) {
            throw new BlobStoreException("failed to check if blob exists", e);
        }
    }

    public boolean deleteBlob(String blobName) throws IOException {
        this.blobStore.client().deleteObject(this.blobStore.bucket(), this.buildKey(blobName));
        return true;
    }

    public InputStream openInput(String blobName) throws IOException {
        for (int retry = 0; retry <= this.blobStore.numberOfRetries(); ++retry) {
            try {
                S3Object s3Object = this.blobStore.client().getObject(this.blobStore.bucket(), this.buildKey(blobName));
                return s3Object.getObjectContent();
            }
            catch (AmazonClientException e) {
                if (this.blobStore.shouldRetry(e) && retry < this.blobStore.numberOfRetries()) {
                    continue;
                }
                if (e instanceof AmazonS3Exception && 404 == ((AmazonS3Exception)((Object)e)).getStatusCode()) {
                    throw new FileNotFoundException("Blob object [" + blobName + "] not found: " + e.getMessage());
                }
                throw e;
            }
        }
        throw new BlobStoreException("retries exhausted while attempting to access blob object [name:" + blobName + ", bucket:" + this.blobStore.bucket() + "]");
    }

    public OutputStream createOutput(String blobName) throws IOException {
        return new DefaultS3OutputStream(this.blobStore, this.blobStore.bucket(), this.buildKey(blobName), this.blobStore.bufferSizeInBytes(), this.blobStore.numberOfRetries(), this.blobStore.serverSideEncryption());
    }

    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(@Nullable String blobNamePrefix) throws IOException {
        ImmutableMap.Builder blobsBuilder = ImmutableMap.builder();
        ObjectListing prevListing = null;
        while (true) {
            ObjectListing list = prevListing != null ? this.blobStore.client().listNextBatchOfObjects(prevListing) : (blobNamePrefix != null ? this.blobStore.client().listObjects(this.blobStore.bucket(), this.buildKey(blobNamePrefix)) : this.blobStore.client().listObjects(this.blobStore.bucket(), this.keyPath));
            for (S3ObjectSummary summary : list.getObjectSummaries()) {
                String name = summary.getKey().substring(this.keyPath.length());
                blobsBuilder.put((Object)name, (Object)new PlainBlobMetaData(name, summary.getSize()));
            }
            if (!list.isTruncated()) break;
            prevListing = list;
        }
        return blobsBuilder.build();
    }

    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        return this.listBlobsByPrefix(null);
    }

    protected String buildKey(String blobName) {
        return this.keyPath + blobName;
    }
}

