/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.AwsSettingsFilter;
import org.elasticsearch.cloud.aws.AwsSigner;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;

public class InternalAwsS3Service
extends AbstractLifecycleComponent<AwsS3Service>
implements AwsS3Service {
    private Map<Tuple<String, String>, AmazonS3Client> clients = new HashMap<Tuple<String, String>, AmazonS3Client>();

    @Inject
    public InternalAwsS3Service(Settings settings, SettingsFilter settingsFilter) {
        super(settings);
        settingsFilter.addFilter((SettingsFilter.Filter)new AwsSettingsFilter());
    }

    @Override
    public synchronized AmazonS3 client() {
        String endpoint = this.getDefaultEndpoint();
        String account = this.componentSettings.get("access_key", this.settings.get("cloud.account"));
        String key = this.componentSettings.get("secret_key", this.settings.get("cloud.key"));
        return this.getClient(endpoint, null, account, key, null);
    }

    @Override
    public AmazonS3 client(String endpoint, String protocol, String region, String account, String key) {
        return this.client(endpoint, protocol, region, account, key, null);
    }

    @Override
    public synchronized AmazonS3 client(String endpoint, String protocol, String region, String account, String key, Integer maxRetries) {
        if (region != null && endpoint == null) {
            endpoint = InternalAwsS3Service.getEndpoint(region);
            this.logger.debug("using s3 region [{}], with endpoint [{}]", new Object[]{region, endpoint});
        } else if (endpoint == null) {
            endpoint = this.getDefaultEndpoint();
        }
        if (account == null || key == null) {
            account = this.componentSettings.get("access_key", this.settings.get("cloud.account"));
            key = this.componentSettings.get("secret_key", this.settings.get("cloud.key"));
        }
        return this.getClient(endpoint, protocol, account, key, maxRetries);
    }

    private synchronized AmazonS3 getClient(String endpoint, String protocol, String account, String key, Integer maxRetries) {
        String awsSigner;
        Tuple clientDescriptor = new Tuple((Object)endpoint, (Object)account);
        AmazonS3Client client = this.clients.get(clientDescriptor);
        if (client != null) {
            return client;
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        if (protocol == null) {
            protocol = this.componentSettings.get("protocol", "https").toLowerCase();
            protocol = this.componentSettings.get("s3.protocol", protocol).toLowerCase();
        }
        if ("http".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTP);
        } else if ("https".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTPS);
        } else {
            throw new ElasticsearchIllegalArgumentException("No protocol supported [" + protocol + "], can either be [http] or [https]");
        }
        String proxyHost = this.settings.get("cloud.aws.proxy_host");
        proxyHost = this.settings.get("cloud.aws.s3.proxy_host", proxyHost);
        if (proxyHost != null) {
            Integer proxyPort;
            String portString = this.settings.get("cloud.aws.proxy_port", "80");
            portString = this.settings.get("cloud.aws.s3.proxy_port", portString);
            try {
                proxyPort = Integer.parseInt(portString, 10);
            }
            catch (NumberFormatException ex) {
                throw new ElasticsearchIllegalArgumentException("The configured proxy port value [" + portString + "] is invalid", (Throwable)ex);
            }
            clientConfiguration.withProxyHost(proxyHost).setProxyPort(proxyPort.intValue());
        }
        if (maxRetries != null) {
            clientConfiguration.setMaxErrorRetry(maxRetries.intValue());
        }
        if ((awsSigner = this.settings.get("cloud.aws.s3.signer", this.settings.get("cloud.aws.signer"))) != null) {
            this.logger.debug("using AWS API signer [{}]", new Object[]{awsSigner});
            try {
                AwsSigner.configureSigner(awsSigner, clientConfiguration);
            }
            catch (ElasticsearchIllegalArgumentException e) {
                this.logger.warn("wrong signer set for [cloud.aws.s3.signer] or [cloud.aws.signer]: [{}]", new Object[]{awsSigner});
            }
        }
        AWSCredentialsProviderChain credentials = account == null && key == null ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new InstanceProfileCredentialsProvider()}) : new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(account, key))});
        client = new AmazonS3Client((AWSCredentialsProvider)credentials, clientConfiguration);
        if (endpoint != null) {
            client.setEndpoint(endpoint);
        }
        this.clients.put((Tuple<String, String>)clientDescriptor, client);
        return client;
    }

    private String getDefaultEndpoint() {
        String endpoint = null;
        if (this.componentSettings.get("s3.endpoint") != null) {
            endpoint = this.componentSettings.get("s3.endpoint");
            this.logger.debug("using explicit s3 endpoint [{}]", new Object[]{endpoint});
        } else if (this.componentSettings.get("region") != null) {
            String region = this.componentSettings.get("region").toLowerCase();
            endpoint = InternalAwsS3Service.getEndpoint(region);
            this.logger.debug("using s3 region [{}], with endpoint [{}]", new Object[]{region, endpoint});
        }
        return endpoint;
    }

    private static String getEndpoint(String region) {
        if ("us-east".equals(region) || "us-east-1".equals(region)) {
            return "s3.amazonaws.com";
        }
        if ("us-west".equals(region) || "us-west-1".equals(region)) {
            return "s3-us-west-1.amazonaws.com";
        }
        if ("us-west-2".equals(region)) {
            return "s3-us-west-2.amazonaws.com";
        }
        if ("ap-southeast".equals(region) || "ap-southeast-1".equals(region)) {
            return "s3-ap-southeast-1.amazonaws.com";
        }
        if ("ap-southeast-2".equals(region)) {
            return "s3-ap-southeast-2.amazonaws.com";
        }
        if ("ap-northeast".equals(region) || "ap-northeast-1".equals(region)) {
            return "s3-ap-northeast-1.amazonaws.com";
        }
        if ("eu-west".equals(region) || "eu-west-1".equals(region)) {
            return "s3-eu-west-1.amazonaws.com";
        }
        if ("eu-central".equals(region) || "eu-central-1".equals(region)) {
            return "s3.eu-central-1.amazonaws.com";
        }
        if ("sa-east".equals(region) || "sa-east-1".equals(region)) {
            return "s3-sa-east-1.amazonaws.com";
        }
        if ("cn-north".equals(region) || "cn-north-1".equals(region)) {
            return "s3.cn-north-1.amazonaws.com.cn";
        }
        throw new ElasticsearchIllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        for (AmazonS3Client client : this.clients.values()) {
            client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

