/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cloud.aws.AwsS3Service;
import org.elasticsearch.cloud.aws.InternalAwsS3Service;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;

public class AwsModule
extends AbstractModule {
    private final Settings settings;
    public static final String S3_SERVICE_TYPE_KEY = "cloud.aws.s3service.type";

    public AwsModule(Settings settings) {
        this.settings = settings;
    }

    protected void configure() {
        this.bind(AwsS3Service.class).to(AwsModule.getS3ServiceClass(this.settings)).asEagerSingleton();
        this.bind(AwsEc2Service.class).asEagerSingleton();
    }

    public static Class<? extends AwsS3Service> getS3ServiceClass(Settings settings) {
        return settings.getAsClass(S3_SERVICE_TYPE_KEY, InternalAwsS3Service.class);
    }
}

