/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jorphan.util.JMeterException;

public class ClassTools {
    public static Object construct(String className) throws JMeterException {
        Object instance = null;
        try {
            instance = ClassUtils.getClass((String)className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JMeterException(e);
        }
        catch (InstantiationException e) {
            throw new JMeterException(e);
        }
        catch (IllegalAccessException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static Object construct(String className, int parameter) throws JMeterException {
        Object instance = null;
        try {
            Class clazz = ClassUtils.getClass((String)className);
            clazz.getConstructor(Integer.TYPE);
            instance = ClassUtils.getClass((String)className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JMeterException(e);
        }
        catch (InstantiationException e) {
            throw new JMeterException(e);
        }
        catch (IllegalAccessException e) {
            throw new JMeterException(e);
        }
        catch (SecurityException e) {
            throw new JMeterException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static Object construct(String className, String parameter) throws JMeterException {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            instance = constructor.newInstance(parameter);
        }
        catch (ClassNotFoundException e) {
            throw new JMeterException(e);
        }
        catch (InstantiationException e) {
            throw new JMeterException(e);
        }
        catch (IllegalAccessException e) {
            throw new JMeterException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JMeterException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JMeterException(e);
        }
        catch (InvocationTargetException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static void invoke(Object instance, String methodName) throws SecurityException, IllegalArgumentException, JMeterException {
        try {
            Method m = ClassUtils.getPublicMethod(instance.getClass(), (String)methodName, (Class[])new Class[0]);
            m.invoke(instance, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new JMeterException(e);
        }
        catch (IllegalAccessException e) {
            throw new JMeterException(e);
        }
        catch (InvocationTargetException e) {
            throw new JMeterException(e);
        }
    }
}

