/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfiguration
implements Serializable {
    private String launchConfigurationName;
    private String launchConfigurationARN;
    private String imageId;
    private String keyName;
    private ListWithAutoConstructFlag<String> securityGroups;
    private String userData;
    private String instanceType;
    private String kernelId;
    private String ramdiskId;
    private ListWithAutoConstructFlag<BlockDeviceMapping> blockDeviceMappings;
    private InstanceMonitoring instanceMonitoring;
    private String spotPrice;
    private String iamInstanceProfile;
    private Date createdTime;
    private Boolean ebsOptimized;
    private Boolean associatePublicIpAddress;
    private String placementTenancy;

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public LaunchConfiguration withLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
        return this;
    }

    public String getLaunchConfigurationARN() {
        return this.launchConfigurationARN;
    }

    public void setLaunchConfigurationARN(String launchConfigurationARN) {
        this.launchConfigurationARN = launchConfigurationARN;
    }

    public LaunchConfiguration withLaunchConfigurationARN(String launchConfigurationARN) {
        this.launchConfigurationARN = launchConfigurationARN;
        return this;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public LaunchConfiguration withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public LaunchConfiguration withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ListWithAutoConstructFlag();
            this.securityGroups.setAutoConstruct(true);
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public LaunchConfiguration withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public LaunchConfiguration withSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public LaunchConfiguration withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public LaunchConfiguration withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public LaunchConfiguration withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public LaunchConfiguration withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ListWithAutoConstructFlag();
            this.blockDeviceMappings.setAutoConstruct(true);
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public LaunchConfiguration withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public LaunchConfiguration withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public InstanceMonitoring getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    public void setInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
    }

    public LaunchConfiguration withInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
        return this;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public LaunchConfiguration withSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public LaunchConfiguration withIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public LaunchConfiguration withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public LaunchConfiguration withEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
        return this;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public LaunchConfiguration withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
        return this;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public String getPlacementTenancy() {
        return this.placementTenancy;
    }

    public void setPlacementTenancy(String placementTenancy) {
        this.placementTenancy = placementTenancy;
    }

    public LaunchConfiguration withPlacementTenancy(String placementTenancy) {
        this.placementTenancy = placementTenancy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLaunchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: " + this.getLaunchConfigurationName() + ",");
        }
        if (this.getLaunchConfigurationARN() != null) {
            sb.append("LaunchConfigurationARN: " + this.getLaunchConfigurationARN() + ",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: " + this.getImageId() + ",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: " + this.getKeyName() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: " + this.getUserData() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: " + this.getKernelId() + ",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: " + this.getRamdiskId() + ",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: " + this.getBlockDeviceMappings() + ",");
        }
        if (this.getInstanceMonitoring() != null) {
            sb.append("InstanceMonitoring: " + this.getInstanceMonitoring() + ",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: " + this.getSpotPrice() + ",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: " + this.getIamInstanceProfile() + ",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: " + this.getCreatedTime() + ",");
        }
        if (this.isEbsOptimized() != null) {
            sb.append("EbsOptimized: " + this.isEbsOptimized() + ",");
        }
        if (this.isAssociatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: " + this.isAssociatePublicIpAddress() + ",");
        }
        if (this.getPlacementTenancy() != null) {
            sb.append("PlacementTenancy: " + this.getPlacementTenancy());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationARN() == null ? 0 : this.getLaunchConfigurationARN().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMonitoring() == null ? 0 : this.getInstanceMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.isEbsOptimized() == null ? 0 : this.isEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.isAssociatePublicIpAddress() == null ? 0 : this.isAssociatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementTenancy() == null ? 0 : this.getPlacementTenancy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getLaunchConfigurationARN() == null ^ this.getLaunchConfigurationARN() == null) {
            return false;
        }
        if (other.getLaunchConfigurationARN() != null && !other.getLaunchConfigurationARN().equals(this.getLaunchConfigurationARN())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getInstanceMonitoring() == null ^ this.getInstanceMonitoring() == null) {
            return false;
        }
        if (other.getInstanceMonitoring() != null && !other.getInstanceMonitoring().equals(this.getInstanceMonitoring())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.isEbsOptimized() == null ^ this.isEbsOptimized() == null) {
            return false;
        }
        if (other.isEbsOptimized() != null && !other.isEbsOptimized().equals(this.isEbsOptimized())) {
            return false;
        }
        if (other.isAssociatePublicIpAddress() == null ^ this.isAssociatePublicIpAddress() == null) {
            return false;
        }
        if (other.isAssociatePublicIpAddress() != null && !other.isAssociatePublicIpAddress().equals(this.isAssociatePublicIpAddress())) {
            return false;
        }
        if (other.getPlacementTenancy() == null ^ this.getPlacementTenancy() == null) {
            return false;
        }
        return other.getPlacementTenancy() == null || other.getPlacementTenancy().equals(this.getPlacementTenancy());
    }
}

