/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import tyrex.naming.MemoryBinding;
import tyrex.tm.impl.ThreadContext;

public abstract class RuntimeContext {
    public abstract Context getEnvContext();

    public abstract Transaction getTransaction();

    public abstract Subject getSubject();

    public abstract void cleanup();

    public static RuntimeContext newRuntimeContext(Context context, Subject subject) throws NamingException {
        return new ThreadContext(context, subject);
    }

    public static RuntimeContext newRuntimeContext() {
        return new ThreadContext(null);
    }

    public static RuntimeContext getRuntimeContext() {
        return ThreadContext.getThreadContext();
    }

    public static void setRuntimeContext(RuntimeContext runtimeContext) {
        if (runtimeContext == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        if (!(runtimeContext instanceof ThreadContext)) {
            throw new IllegalArgumentException("Argument context is not a valid runtime context");
        }
        ThreadContext.setThreadContext((ThreadContext)runtimeContext);
    }

    public static RuntimeContext unsetRuntimeContext() {
        return ThreadContext.unsetThreadContext();
    }

    public static void cleanup(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument thread is null");
        }
        ThreadContext.cleanup(thread);
    }

    public static Context newEnvContext() {
        return new MemoryBinding().getContext();
    }
}

