/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource;

public class PoolMetrics {
    private long _accumUsedTime;
    private long _accumUnusedTime;
    private int _accumCreated;
    private int _accumUsed;
    private int _accumUnused;
    private int _accumDiscarded;
    private int _accumErrors;
    protected int _total;
    protected int _available;

    public int getTotalCreated() {
        return this._accumCreated;
    }

    public int getTotalUsed() {
        return this._accumUsed;
    }

    public int getTotalDiscarded() {
        return this._accumDiscarded;
    }

    public int getTotalErrors() {
        return this._accumErrors;
    }

    public synchronized int getCurrentUsed() {
        return this._total - this._available;
    }

    public int getCurrentUnused() {
        return this._available;
    }

    public synchronized float getUsedAvgDuration() {
        return (float)this._accumUsedTime / (float)this._accumUsed / 10000.0f;
    }

    public synchronized float getUnusedAvgDuration() {
        return (float)this._accumUnusedTime / (float)this._accumUnused / 10000.0f;
    }

    public int getTotal() {
        return this._total;
    }

    public int getAvailable() {
        return this._available;
    }

    public synchronized void reset() {
        this._accumUsedTime = 0L;
        this._accumUnusedTime = 0L;
        this._accumCreated = 0;
        this._accumUsed = 0;
        this._accumUnused = 0;
        this._accumDiscarded = 0;
        this._accumErrors = 0;
    }

    protected synchronized void recordCreated() {
        ++this._accumCreated;
        ++this._total;
    }

    protected synchronized void recordDiscard() {
        ++this._accumDiscarded;
        --this._total;
    }

    protected synchronized void recordError() {
        ++this._accumErrors;
        --this._total;
    }

    protected synchronized void recordUsedDuration(int n) {
        ++this._accumUsed;
        this._accumUsedTime += (long)n;
    }

    protected synchronized void recordUnusedDuration(int n) {
        ++this._accumUnused;
        this._accumUnusedTime += (long)n;
    }
}

