/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass
public class FormData
extends SimpleScriptable {
    private final List<NameValuePair> requestParameters_ = new ArrayList<NameValuePair>();

    public FormData() {
    }

    @JsxConstructor
    public FormData(Object formObj) {
        if (formObj instanceof HTMLFormElement) {
            HTMLFormElement form = (HTMLFormElement)formObj;
            this.requestParameters_.addAll(form.getHtmlForm().getParameterListForSubmit(null));
        }
    }

    @JsxFunction
    public void append(String name, Object value, Object filename) {
        if (value instanceof File) {
            File file = (File)value;
            String fileName = null;
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            this.requestParameters_.add(new KeyDataPair(name, file.getFile(), fileName, file.getType(), null));
        } else {
            this.requestParameters_.add(new NameValuePair(name, Context.toString((Object)value)));
        }
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setEncodingType(FormEncodingType.MULTIPART);
        webRequest.setRequestParameters(this.requestParameters_);
    }
}

