/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Locale;

@JsxClass(domClass=HtmlBody.class)
public class HTMLBodyElement
extends HTMLElement {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLBodyElement() {
    }

    public void createEventHandlerFromAttribute(String attributeName, String value) {
        if (attributeName.toLowerCase(Locale.ROOT).startsWith("on")) {
            this.createEventHandler(attributeName, value);
        }
    }

    @Override
    public EventListenersContainer getEventListenersContainer() {
        return this.getWindow().getEventListenersContainer();
    }

    @Override
    public void setDefaults(ComputedCSSStyleDeclaration style) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BODY_MARGINS_8)) {
            style.setDefaultLocalStyleAttribute("margin", "8px");
            style.setDefaultLocalStyleAttribute("padding", "0px");
        } else {
            style.setDefaultLocalStyleAttribute("margin-left", "8px");
            style.setDefaultLocalStyleAttribute("margin-right", "8px");
            style.setDefaultLocalStyleAttribute("margin-top", "8px");
            style.setDefaultLocalStyleAttribute("margin-bottom", "8px");
        }
    }

    @Override
    public HTMLElement getOffsetParent_js() {
        return null;
    }

    @JsxGetter
    public String getALink() {
        return this.getDomNodeOrDie().getAttribute("aLink");
    }

    @JsxSetter
    public void setALink(String aLink) {
        this.setColorAttribute("aLink", aLink);
    }

    @JsxGetter
    public String getBackground() {
        HtmlElement node = this.getDomNodeOrDie();
        return node.getAttribute("background");
    }

    @JsxSetter
    public void setBackground(String background) {
        this.getDomNodeOrDie().setAttribute("background", background);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public String getLink() {
        return this.getDomNodeOrDie().getAttribute("link");
    }

    @JsxSetter
    public void setLink(String link) {
        this.setColorAttribute("link", link);
    }

    @JsxGetter
    public String getText() {
        return this.getDomNodeOrDie().getAttribute("text");
    }

    @JsxSetter
    public void setText(String text) {
        this.setColorAttribute("text", text);
    }

    @JsxGetter
    public String getVLink() {
        return this.getDomNodeOrDie().getAttribute("vLink");
    }

    @JsxSetter
    public void setVLink(String vLink) {
        this.setColorAttribute("vLink", vLink);
    }
}

