/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.typetools;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.jodah.typetools.TypeDescriptor;
import sun.reflect.ConstantPool;

public final class TypeResolver {
    private static final Map<Class<?>, Reference<Map<TypeVariable<?>, Type>>> typeVariableCache = Collections.synchronizedMap(new WeakHashMap());
    private static volatile int METHOD_REF_OFFSET = -1;
    private static volatile boolean CACHE_ENABLED = true;
    private static boolean SUPPORTS_LAMBDAS;
    private static Method GET_CONSTANT_POOL;
    private static Map<String, Method> OBJECT_METHODS;

    private TypeResolver() {
    }

    public static void enableCache() {
        CACHE_ENABLED = true;
    }

    public static void disableCache() {
        typeVariableCache.clear();
        CACHE_ENABLED = false;
    }

    public static <T, S extends T> Class<?> resolveRawArgument(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArgument(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?> resolveRawArgument(Type genericType, Class<?> subType) {
        Class<?>[] arguments = TypeResolver.resolveRawArguments(genericType, subType);
        if (arguments == null) {
            return Unknown.class;
        }
        if (arguments.length != 1) {
            throw new IllegalArgumentException("Expected 1 argument for generic type " + genericType + " but found " + arguments.length);
        }
        return arguments[0];
    }

    public static <T, S extends T> Class<?>[] resolveRawArguments(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArguments(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?>[] resolveRawArguments(Type genericType, Class<?> subType) {
        Class[] result;
        block5: {
            Class functionalInterface;
            block6: {
                block4: {
                    result = null;
                    functionalInterface = null;
                    if (SUPPORTS_LAMBDAS && subType.isSynthetic()) {
                        Class fi;
                        Class clazz = genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getRawType() instanceof Class ? (Class)((ParameterizedType)genericType).getRawType() : (fi = genericType instanceof Class ? (Class)genericType : null);
                        if (fi != null && fi.isInterface()) {
                            functionalInterface = fi;
                        }
                    }
                    if (!(genericType instanceof ParameterizedType)) break block4;
                    ParameterizedType paramType = (ParameterizedType)genericType;
                    Type[] arguments = paramType.getActualTypeArguments();
                    result = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        result[i] = TypeResolver.resolveRawClass(arguments[i], subType, functionalInterface);
                    }
                    break block5;
                }
                if (!(genericType instanceof TypeVariable)) break block6;
                result = new Class[]{TypeResolver.resolveRawClass(genericType, subType, functionalInterface)};
                break block5;
            }
            if (!(genericType instanceof Class)) break block5;
            TypeVariable<Class<T>>[] typeParams = ((Class)genericType).getTypeParameters();
            result = new Class[typeParams.length];
            for (int i = 0; i < typeParams.length; ++i) {
                result[i] = TypeResolver.resolveRawClass(typeParams[i], subType, functionalInterface);
            }
        }
        return result;
    }

    public static Type resolveGenericType(Class<?> type, Type subType) {
        Type superClass;
        Type result;
        Class rawType = subType instanceof ParameterizedType ? (Class)((ParameterizedType)subType).getRawType() : (Class)subType;
        if (type.equals(rawType)) {
            return subType;
        }
        if (type.isInterface()) {
            for (Type superInterface : rawType.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || (result = TypeResolver.resolveGenericType(type, superInterface)) == null) continue;
                return result;
            }
        }
        if ((superClass = rawType.getGenericSuperclass()) != null && !superClass.equals(Object.class) && (result = TypeResolver.resolveGenericType(type, superClass)) != null) {
            return result;
        }
        return null;
    }

    public static Class<?> resolveRawClass(Type genericType, Class<?> subType) {
        return TypeResolver.resolveRawClass(genericType, subType, null);
    }

    private static Class<?> resolveRawClass(Type genericType, Class<?> subType, Class<?> functionalInterface) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return TypeResolver.resolveRawClass(((ParameterizedType)genericType).getRawType(), subType, functionalInterface);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> compoment = TypeResolver.resolveRawClass(arrayType.getGenericComponentType(), subType, functionalInterface);
            return Array.newInstance(compoment, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = TypeResolver.getTypeVariableMap(subType, functionalInterface).get(variable);
            genericType = genericType == null ? TypeResolver.resolveBound(variable) : TypeResolver.resolveRawClass(genericType, subType, functionalInterface);
        }
        return genericType instanceof Class ? (Class)genericType : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType, Class<?> functionalInterface) {
        Map<TypeVariable<?>, Type> map;
        Reference<Map<TypeVariable<?>, Type>> ref = typeVariableCache.get(targetType);
        Map<TypeVariable<?>, Type> map2 = map = ref != null ? ref.get() : null;
        if (map == null) {
            Class<?> type;
            map = new HashMap();
            if (functionalInterface != null) {
                TypeResolver.populateLambdaArgs(functionalInterface, targetType, map);
            }
            TypeResolver.populateSuperTypeArgs(targetType.getGenericInterfaces(), map, functionalInterface != null);
            Type genericType = targetType.getGenericSuperclass();
            for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.populateTypeArgs((ParameterizedType)genericType, map, false);
                }
                TypeResolver.populateSuperTypeArgs(type.getGenericInterfaces(), map, false);
                genericType = type.getGenericSuperclass();
            }
            type = targetType;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.populateTypeArgs((ParameterizedType)genericType, map, functionalInterface != null);
                }
                type = type.getEnclosingClass();
            }
            if (CACHE_ENABLED) {
                typeVariableCache.put(targetType, new WeakReference(map));
            }
        }
        return map;
    }

    private static void populateLambdaArgs(Class<?> functionalInterface, Class<?> lambdaType, Map<TypeVariable<?>, Type> map) {
        if (GET_CONSTANT_POOL != null) {
            try {
                for (Method m : functionalInterface.getMethods()) {
                    Class<?> returnType;
                    Method objectMethod;
                    if (m.isDefault() || Modifier.isStatic(m.getModifiers()) || m.isBridge() || (objectMethod = OBJECT_METHODS.get(m.getName())) != null && Arrays.equals(m.getTypeParameters(), objectMethod.getTypeParameters())) continue;
                    Type returnTypeVar = m.getGenericReturnType();
                    Type[] paramTypeVars = m.getGenericParameterTypes();
                    ConstantPool constantPool = (ConstantPool)GET_CONSTANT_POOL.invoke(lambdaType, new Object[0]);
                    String[] methodRefInfo = constantPool.getMemberRefInfoAt(constantPool.getSize() - TypeResolver.resolveMethodRefOffset(constantPool, lambdaType));
                    if (methodRefInfo[1].equals("valueOf") && constantPool.getSize() > 22) {
                        try {
                            methodRefInfo = constantPool.getMemberRefInfoAt(constantPool.getSize() - TypeResolver.resolveAutoboxedMethodRefOffset(constantPool, lambdaType));
                        }
                        catch (MethodRefOffsetResolutionFailed methodRefOffsetResolutionFailed) {
                            // empty catch block
                        }
                    }
                    if (returnTypeVar instanceof TypeVariable && !(returnType = TypeDescriptor.getReturnType(methodRefInfo[2]).getType(lambdaType.getClassLoader())).equals(Void.class)) {
                        map.put((TypeVariable)returnTypeVar, returnType);
                    }
                    TypeDescriptor[] arguments = TypeDescriptor.getArgumentTypes(methodRefInfo[2]);
                    int offset = 0;
                    if (paramTypeVars[0] instanceof TypeVariable && paramTypeVars.length == arguments.length + 1) {
                        Class<?> instanceType = TypeDescriptor.getObjectType(methodRefInfo[0]).getType(lambdaType.getClassLoader());
                        map.put((TypeVariable)paramTypeVars[0], instanceType);
                        offset = 1;
                    }
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!(paramTypeVars[i + offset] instanceof TypeVariable)) continue;
                        map.put((TypeVariable)paramTypeVars[i + offset], arguments[i].getType(lambdaType.getClassLoader()));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void populateSuperTypeArgs(Type[] types, Map<TypeVariable<?>, Type> map, boolean depthFirst) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                Type rawType;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (!depthFirst) {
                    TypeResolver.populateTypeArgs(parameterizedType, map, depthFirst);
                }
                if ((rawType = parameterizedType.getRawType()) instanceof Class) {
                    TypeResolver.populateSuperTypeArgs(((Class)rawType).getGenericInterfaces(), map, depthFirst);
                }
                if (!depthFirst) continue;
                TypeResolver.populateTypeArgs(parameterizedType, map, depthFirst);
                continue;
            }
            if (!(type instanceof Class)) continue;
            TypeResolver.populateSuperTypeArgs(((Class)type).getGenericInterfaces(), map, depthFirst);
        }
    }

    private static void populateTypeArgs(ParameterizedType type, Map<TypeVariable<?>, Type> map, boolean depthFirst) {
        if (type.getRawType() instanceof Class) {
            Type owner;
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            if (type.getOwnerType() != null && (owner = type.getOwnerType()) instanceof ParameterizedType) {
                TypeResolver.populateTypeArgs((ParameterizedType)owner, map, depthFirst);
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                Type existingType;
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                if (depthFirst && (existingType = map.get(variable)) != null) {
                    map.put(typeVariableArgument, existingType);
                    continue;
                }
                Type resolvedType = map.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = TypeResolver.resolveBound(typeVariableArgument);
                }
                map.put(variable, resolvedType);
            }
        }
    }

    public static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = TypeResolver.resolveBound((TypeVariable)bound);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    private static int resolveMethodRefOffset(ConstantPool constantPool, Class<?> lambdaType) {
        int offset = METHOD_REF_OFFSET;
        if (offset == -1) {
            int constantPoolSize = constantPool.getSize();
            for (int i = 0; i < constantPoolSize; ++i) {
                try {
                    constantPool.getMemberRefInfoAt(constantPoolSize - i);
                    offset = i;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
            }
            METHOD_REF_OFFSET = offset;
        }
        if (offset >= 0) {
            return offset;
        }
        throw new MethodRefOffsetResolutionFailed();
    }

    private static int resolveAutoboxedMethodRefOffset(ConstantPool constantPool, Class<?> lambdaType) {
        int constantPoolSize = constantPool.getSize();
        for (int i = TypeResolver.resolveMethodRefOffset(constantPool, lambdaType) + 1; i < constantPoolSize; ++i) {
            try {
                if (constantPool.getMemberRefInfoAt(constantPoolSize - i)[1].equals("<init>")) continue;
                return i;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new MethodRefOffsetResolutionFailed();
    }

    static {
        OBJECT_METHODS = new HashMap<String, Method>();
        boolean bl = SUPPORTS_LAMBDAS = Double.valueOf(System.getProperty("java.version").substring(0, 3)) >= 1.8;
        if (SUPPORTS_LAMBDAS) {
            for (Method method : Object.class.getDeclaredMethods()) {
                OBJECT_METHODS.put(method.getName(), method);
            }
            try {
                GET_CONSTANT_POOL = Class.class.getDeclaredMethod("getConstantPool", new Class[0]);
                GET_CONSTANT_POOL.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (GET_CONSTANT_POOL == null) {
                SUPPORTS_LAMBDAS = false;
            }
        }
    }

    private static final class MethodRefOffsetResolutionFailed
    extends RuntimeException {
        private MethodRefOffsetResolutionFailed() {
        }
    }

    public static final class Unknown {
        private Unknown() {
        }
    }
}

