/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.typetools;

final class TypeDescriptor {
    public static final int ARRAY = 9;
    public static final int BOOLEAN = 1;
    public static final TypeDescriptor BOOLEAN_TYPE = new TypeDescriptor(1, null, 1509950721, 1);
    public static final int BYTE = 3;
    public static final TypeDescriptor BYTE_TYPE = new TypeDescriptor(3, null, 1107297537, 1);
    public static final int CHAR = 2;
    public static final TypeDescriptor CHAR_TYPE = new TypeDescriptor(2, null, 1124075009, 1);
    public static final int DOUBLE = 8;
    public static final TypeDescriptor DOUBLE_TYPE = new TypeDescriptor(8, null, 1141048066, 1);
    public static final int FLOAT = 6;
    public static final TypeDescriptor FLOAT_TYPE = new TypeDescriptor(6, null, 1174536705, 1);
    public static final int INT = 5;
    public static final TypeDescriptor INT_TYPE = new TypeDescriptor(5, null, 1224736769, 1);
    public static final int LONG = 7;
    public static final TypeDescriptor LONG_TYPE = new TypeDescriptor(7, null, 1241579778, 1);
    public static final int METHOD = 11;
    public static final int OBJECT = 10;
    public static final int SHORT = 4;
    public static final TypeDescriptor SHORT_TYPE = new TypeDescriptor(4, null, 1392510721, 1);
    public static final int VOID = 0;
    public static final TypeDescriptor VOID_TYPE = new TypeDescriptor(0, null, 0x56050000, 1);
    private final char[] buf;
    private final int len;
    private final int off;
    private final int sort;

    private TypeDescriptor(int sort, char[] buf, int off, int len) {
        this.sort = sort;
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    public static TypeDescriptor getInternalType(String internalType) {
        return TypeDescriptor.getType(internalType.toCharArray(), 0);
    }

    public static TypeDescriptor getObjectType(String internalName) {
        char[] buf = internalName.toCharArray();
        return new TypeDescriptor(buf[0] == '[' ? 9 : 10, buf, 0, buf.length);
    }

    public static TypeDescriptor[] getArgumentTypes(String methodDescriptor) {
        char car;
        char[] buf = methodDescriptor.toCharArray();
        int off = 1;
        int size = 0;
        while ((car = buf[off++]) != ')') {
            if (car == 'L') {
                while (buf[off++] != ';') {
                }
                ++size;
                continue;
            }
            if (car == '[') continue;
            ++size;
        }
        TypeDescriptor[] args = new TypeDescriptor[size];
        off = 1;
        size = 0;
        while (buf[off] != ')') {
            args[size] = TypeDescriptor.getType(buf, off);
            off += args[size].len + (args[size].sort == 10 ? 2 : 0);
            ++size;
        }
        return args;
    }

    public static TypeDescriptor getReturnType(String methodDescriptor) {
        char[] buf = methodDescriptor.toCharArray();
        return TypeDescriptor.getType(buf, methodDescriptor.indexOf(41) + 1);
    }

    private static TypeDescriptor getType(char[] buf, int off) {
        switch (buf[off]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int len = 1;
                while (buf[off + len] == '[') {
                    ++len;
                }
                if (buf[off + len] == 'L') {
                    ++len;
                    while (buf[off + len] != ';') {
                        ++len;
                    }
                }
                return new TypeDescriptor(9, buf, off, len + 1);
            }
            case 'L': {
                int len = 1;
                while (buf[off + len] != ';') {
                    ++len;
                }
                return new TypeDescriptor(10, buf, off + 1, len - 1);
            }
        }
        return new TypeDescriptor(11, buf, off, buf.length - off);
    }

    public Class<?> getType() {
        return this.getType(null);
    }

    public Class<?> getType(ClassLoader loader) {
        try {
            switch (this.sort) {
                case 0: {
                    return Void.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Character.class;
                }
                case 3: {
                    return Byte.class;
                }
                case 4: {
                    return Short.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 6: {
                    return Float.class;
                }
                case 7: {
                    return Long.class;
                }
                case 8: {
                    return Double.class;
                }
                case 9: {
                    TypeDescriptor elementType = this.getElementType();
                    StringBuilder sb = new StringBuilder();
                    for (int i = this.getDimensions(); i > 0; --i) {
                        sb.append("[");
                    }
                    sb.append('L').append(elementType.getType().getName()).append(';');
                    return loader == null ? Class.forName(sb.toString()) : loader.loadClass(sb.toString());
                }
                case 10: {
                    String clazz = new String(this.buf, this.off, this.len).replace('/', '.');
                    return loader == null ? Class.forName(clazz) : loader.loadClass(clazz);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getDimensions() {
        int i = 1;
        while (this.buf[this.off + i] == '[') {
            ++i;
        }
        return i;
    }

    public TypeDescriptor getElementType() {
        return TypeDescriptor.getType(this.buf, this.off + this.getDimensions());
    }

    public String toString() {
        return this.getType().getName();
    }
}

