/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import play.core.netty.utils.Cookie;
import play.core.netty.utils.CookieEncoder;
import play.core.netty.utils.CookieUtil;
import play.core.netty.utils.DefaultCookie;
import play.core.netty.utils.HttpHeaderDateFormat;

public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    private ServerCookieEncoder(boolean bl) {
        super(bl);
    }

    public String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        String string = cookie.name();
        String string2 = cookie.value() != null ? cookie.value() : "";
        this.validateCookie(string, string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, string, string2);
        } else {
            CookieUtil.add(stringBuilder, string, string2);
        }
        if (cookie.maxAge() != Integer.MIN_VALUE) {
            CookieUtil.add(stringBuilder, "Max-Age", cookie.maxAge());
            Date date = new Date((long)cookie.maxAge() * 1000L + System.currentTimeMillis());
            CookieUtil.add(stringBuilder, "Expires", HttpHeaderDateFormat.get().format(date));
        }
        if (cookie.sameSite() != null) {
            CookieUtil.add(stringBuilder, "SameSite", cookie.sameSite());
        }
        if (cookie.path() != null) {
            CookieUtil.add(stringBuilder, "Path", cookie.path());
        }
        if (cookie.domain() != null) {
            CookieUtil.add(stringBuilder, "Domain", cookie.domain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(stringBuilder, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(stringBuilder, "HTTPOnly");
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    public List<String> encode(Cookie ... cookieArray) {
        if (cookieArray == null) {
            throw new NullPointerException("cookies");
        }
        if (cookieArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
        for (Cookie cookie : cookieArray) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }

    public List<String> encode(Collection<? extends Cookie> collection) {
        if (collection == null) {
            throw new NullPointerException("cookies");
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Cookie cookie : collection) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }

    public List<String> encode(Iterable<? extends Cookie> iterable) {
        if (iterable == null) {
            throw new NullPointerException("cookies");
        }
        if (iterable.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cookie cookie : iterable) {
            if (cookie == null) break;
            arrayList.add(this.encode(cookie));
        }
        return arrayList;
    }
}

