/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.core.netty.utils.CookieUtil;
import play.core.netty.utils.DefaultCookie;

abstract class CookieDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean bl) {
        this.strict = bl;
    }

    protected DefaultCookie initCookie(String string, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        if (n == -1 || n == n2) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (n3 == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(string, n3, n4);
        CharSequence charSequence = CookieUtil.unwrapValue(charBuffer);
        if (charSequence == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '" + charBuffer + "'");
            }
            return null;
        }
        String string2 = string.substring(n, n2);
        if (this.strict && (n5 = CookieUtil.firstInvalidCookieNameOctet(string2)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '" + string2 + "' contains invalid char '" + string2.charAt(n5) + "'");
            }
            return null;
        }
        boolean bl2 = bl = charSequence.length() != n4 - n3;
        if (this.strict && (n5 = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '" + charSequence + "' contains invalid char '" + charSequence.charAt(n5) + "'");
            }
            return null;
        }
        DefaultCookie defaultCookie = new DefaultCookie(string2, charSequence.toString());
        defaultCookie.setWrap(bl);
        return defaultCookie;
    }
}

