/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import java.util.Iterator;
import play.core.netty.utils.Cookie;
import play.core.netty.utils.CookieEncoder;
import play.core.netty.utils.CookieUtil;
import play.core.netty.utils.DefaultCookie;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);

    private ClientCookieEncoder(boolean bl) {
        super(bl);
    }

    public String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.encode(stringBuilder, cookie);
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    public String encode(Cookie ... cookieArray) {
        if (cookieArray == null) {
            throw new NullPointerException("cookies");
        }
        if (cookieArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Cookie cookie : cookieArray) {
            if (cookie == null) break;
            this.encode(stringBuilder, cookie);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(stringBuilder);
    }

    public String encode(Iterable<? extends Cookie> iterable) {
        Cookie cookie;
        if (iterable == null) {
            throw new NullPointerException("cookies");
        }
        Iterator<? extends Cookie> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext() && (cookie = iterator.next()) != null) {
            this.encode(stringBuilder, cookie);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(stringBuilder);
    }

    private void encode(StringBuilder stringBuilder, Cookie cookie) {
        String string = cookie.name();
        String string2 = cookie.value() != null ? cookie.value() : "";
        this.validateCookie(string, string2);
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, string, string2);
        } else {
            CookieUtil.add(stringBuilder, string, string2);
        }
    }
}

