/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import java.text.ParsePosition;
import java.util.Date;
import play.core.netty.utils.Cookie;
import play.core.netty.utils.CookieDecoder;
import play.core.netty.utils.DefaultCookie;
import play.core.netty.utils.HttpHeaderDateFormat;

public final class ClientCookieDecoder
extends CookieDecoder {
    public static final ClientCookieDecoder STRICT = new ClientCookieDecoder(true);
    public static final ClientCookieDecoder LAX = new ClientCookieDecoder(false);

    private ClientCookieDecoder(boolean bl) {
        super(bl);
    }

    public Cookie decode(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException("header");
        }
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int n3 = 0;
        while (n3 != n2 && (n = string.charAt(n3)) != 44) {
            Object object;
            int n4;
            int n5;
            int n6;
            block13: {
                if (n == 9 || n == 10 || n == 11 || n == 12 || n == 13 || n == 32 || n == 59) {
                    ++n3;
                    continue;
                }
                n = n3;
                n6 = n3;
                n5 = -1;
                n4 = -1;
                if (n3 != n2) {
                    do {
                        char c;
                        if ((c = string.charAt(n3)) == ';') {
                            n6 = n3;
                            n4 = -1;
                            n5 = -1;
                        } else {
                            if (c != '=') continue;
                            n6 = n3++;
                            if (n3 == n2) {
                                n4 = 0;
                                n5 = 0;
                            } else {
                                n5 = n3;
                                int n7 = string.indexOf(59, n3);
                                n3 = n7 > 0 ? n7 : n2;
                                n4 = n3;
                            }
                        }
                        break block13;
                    } while (++n3 != n2);
                    n6 = n2;
                    n4 = -1;
                    n5 = -1;
                }
            }
            if (n4 > 0 && string.charAt(n4 - 1) == ',') {
                --n4;
            }
            if (cookieBuilder == null) {
                object = this.initCookie(string, n, n6, n5, n4);
                if (object == null) {
                    return null;
                }
                cookieBuilder = new CookieBuilder((DefaultCookie)object);
                continue;
            }
            object = n5 == -1 ? null : string.substring(n5, n4);
            cookieBuilder.appendAttribute(string, n, n6, (String)object);
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private final DefaultCookie cookie;
        private String domain;
        private String path;
        private int maxAge = Integer.MIN_VALUE;
        private String expires;
        private boolean secure;
        private boolean httpOnly;
        private String sameSite;

        public CookieBuilder(DefaultCookie defaultCookie) {
            this.cookie = defaultCookie;
        }

        private int mergeMaxAgeAndExpire(int n, String string) {
            Date date;
            if (n != Integer.MIN_VALUE) {
                return n;
            }
            if (string != null && (date = HttpHeaderDateFormat.get().parse(string, new ParsePosition(0))) != null) {
                long l = date.getTime() - System.currentTimeMillis();
                return (int)(l / 1000L + (long)(l % 1000L != 0L ? 1 : 0));
            }
            return Integer.MIN_VALUE;
        }

        public Cookie cookie() {
            this.cookie.setDomain(this.domain);
            this.cookie.setPath(this.path);
            this.cookie.setMaxAge(this.mergeMaxAgeAndExpire(this.maxAge, this.expires));
            this.cookie.setSecure(this.secure);
            this.cookie.setHttpOnly(this.httpOnly);
            this.cookie.setSameSite(this.sameSite);
            return this.cookie;
        }

        public void appendAttribute(String string, int n, int n2, String string2) {
            this.setCookieAttribute(string, n, n2, string2);
        }

        private void setCookieAttribute(String string, int n, int n2, String string2) {
            int n3 = n2 - n;
            if (n3 == 4) {
                this.parse4(string, n, string2);
            } else if (n3 == 6) {
                this.parse6(string, n, string2);
            } else if (n3 == 7) {
                this.parse7(string, n, string2);
            } else if (n3 == 8) {
                this.parse8(string, n, string2);
            }
        }

        private void parse4(String string, int n, String string2) {
            if (string.regionMatches(true, n, "Path", 0, 4)) {
                this.path = string2;
            }
        }

        private void parse6(String string, int n, String string2) {
            if (string.regionMatches(true, n, "Domain", 0, 5)) {
                this.domain = string2.length() > 0 ? string2.toString() : null;
            } else if (string.regionMatches(true, n, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        private void setExpire(String string) {
            this.expires = string;
        }

        private void setMaxAge(String string) {
            try {
                this.maxAge = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void parse7(String string, int n, String string2) {
            if (string.regionMatches(true, n, "Expires", 0, 7)) {
                this.setExpire(string2);
            } else if (string.regionMatches(true, n, "Max-Age", 0, 7)) {
                this.setMaxAge(string2);
            }
        }

        private void parse8(String string, int n, String string2) {
            if (string.regionMatches(true, n, "HTTPOnly", 0, 8)) {
                this.httpOnly = true;
            } else if (string.regionMatches(true, n, "SameSite", 0, 8)) {
                this.setSameSite(string2);
            }
        }

        private void setSameSite(String string) {
            this.sameSite = string;
        }
    }
}

