/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapStoreConfigReadOnly;
import com.hazelcast.util.ValidationUtil;
import java.util.Map;
import java.util.Properties;

public class MapStoreConfig {
    public static final int DEFAULT_WRITE_DELAY_SECONDS = 0;
    public static final int DEFAULT_WRITE_BATCH_SIZE = 1;
    public static final boolean DEFAULT_WRITE_COALESCING = true;
    private boolean enabled = true;
    private boolean writeCoalescing = true;
    private String className;
    private String factoryClassName;
    private int writeDelaySeconds = 0;
    private int writeBatchSize = 1;
    private Object implementation;
    private Object factoryImplementation;
    private Properties properties = new Properties();
    private MapStoreConfigReadOnly readOnly;
    private InitialLoadMode initialLoadMode = InitialLoadMode.LAZY;

    public MapStoreConfig() {
    }

    public MapStoreConfig(MapStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.implementation = config.getImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.writeDelaySeconds = config.getWriteDelaySeconds();
        this.writeBatchSize = config.getWriteBatchSize();
        this.initialLoadMode = config.getInitialLoadMode();
        this.writeCoalescing = config.isWriteCoalescing();
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    public MapStoreConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MapStoreConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getClassName() {
        return this.className;
    }

    public MapStoreConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public MapStoreConfig setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
        return this;
    }

    public int getWriteDelaySeconds() {
        return this.writeDelaySeconds;
    }

    public MapStoreConfig setWriteDelaySeconds(int writeDelaySeconds) {
        this.writeDelaySeconds = writeDelaySeconds;
        return this;
    }

    public int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    public MapStoreConfig setWriteBatchSize(int writeBatchSize) {
        if (writeBatchSize < 1) {
            throw new IllegalArgumentException("Write batch size should be at least 1");
        }
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MapStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MapStoreConfig setImplementation(Object implementation) {
        this.implementation = implementation;
        return this;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public MapStoreConfig setFactoryImplementation(Object factoryImplementation) {
        this.factoryImplementation = factoryImplementation;
        return this;
    }

    public Object getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public MapStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MapStoreConfig setProperties(Properties properties) {
        ValidationUtil.isNotNull(properties, "properties");
        this.properties = properties;
        return this;
    }

    public InitialLoadMode getInitialLoadMode() {
        return this.initialLoadMode;
    }

    public MapStoreConfig setInitialLoadMode(InitialLoadMode initialLoadMode) {
        this.initialLoadMode = initialLoadMode;
        return this;
    }

    public boolean isWriteCoalescing() {
        return this.writeCoalescing;
    }

    public void setWriteCoalescing(boolean writeCoalescing) {
        this.writeCoalescing = writeCoalescing;
    }

    public String toString() {
        return "MapStoreConfig{enabled=" + this.enabled + ", className='" + this.className + '\'' + ", factoryClassName='" + this.factoryClassName + '\'' + ", writeDelaySeconds=" + this.writeDelaySeconds + ", writeBatchSize=" + this.writeBatchSize + ", implementation=" + this.implementation + ", factoryImplementation=" + this.factoryImplementation + ", properties=" + this.properties + ", readOnly=" + this.readOnly + ", initialLoadMode=" + (Object)((Object)this.initialLoadMode) + ", writeCoalescing=" + this.writeCoalescing + '}';
    }

    public static enum InitialLoadMode {
        LAZY,
        EAGER;

    }
}

