/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.query.BucketKeyMapReduce;
import com.basho.riak.client.query.LinkWalkStep;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.NodeStats;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.query.functions.Function;
import com.basho.riak.client.query.functions.JSSourceFunction;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.JSONErrorParser;
import com.basho.riak.client.raw.MatchFoundException;
import com.basho.riak.client.raw.ModifiedException;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import com.basho.riak.client.raw.StoreMeta;
import com.basho.riak.client.raw.Transport;
import com.basho.riak.client.raw.http.ResultCapture;
import com.basho.riak.client.raw.pbc.ConversionUtil;
import com.basho.riak.client.raw.query.LinkWalkSpec;
import com.basho.riak.client.raw.query.MapReduceSpec;
import com.basho.riak.client.raw.query.MapReduceTimeoutException;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import com.basho.riak.client.raw.query.indexes.IndexWriter;
import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.pbc.FetchResponse;
import com.basho.riak.pbc.IRequestMeta;
import com.basho.riak.pbc.KeySource;
import com.basho.riak.pbc.MapReduceResponseSource;
import com.basho.riak.pbc.RequestMeta;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakError;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBClientAdapter
implements RawClient {
    private static final Object MATCH_FOUND = "match_found";
    private static final Object MODIFIED = "modified";
    private final RiakClient client;

    public PBClientAdapter(String host, int port) throws IOException {
        this.client = new RiakClient(host, port);
    }

    public PBClientAdapter(RiakClient delegate) {
        this.client = delegate;
    }

    @Override
    public RiakResponse head(String bucket, String key, FetchMeta fm) throws IOException {
        fm = fm != null ? FetchMeta.Builder.from(fm).headOnly(true).build() : FetchMeta.head();
        return this.fetch(bucket, key, fm);
    }

    @Override
    public RiakResponse fetch(String bucket, String key) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        return ConversionUtil.convert(this.client.fetch(bucket, key));
    }

    @Override
    public RiakResponse fetch(String bucket, String key, int readQuorum) throws IOException {
        return this.fetch(bucket, key, FetchMeta.withR(readQuorum));
    }

    @Override
    public RiakResponse fetch(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        FetchResponse fr = this.client.fetch(bucket, key, ConversionUtil.convert(fetchMeta));
        return ConversionUtil.convert(fr);
    }

    @Override
    public RiakResponse store(IRiakObject riakObject, StoreMeta storeMeta) throws IOException {
        if (riakObject == null || riakObject.getBucket() == null) {
            throw new IllegalArgumentException("object cannot be null, object's key cannot be null, object's bucket cannot be null");
        }
        try {
            return ConversionUtil.convert(this.client.store(ConversionUtil.convert(riakObject), (IRequestMeta)ConversionUtil.convert(storeMeta, riakObject)));
        }
        catch (RiakError e) {
            if (MATCH_FOUND.equals(e.getMessage())) {
                throw new MatchFoundException();
            }
            if (MODIFIED.equals(e.getMessage())) {
                throw new ModifiedException(e);
            }
            throw e;
        }
    }

    @Override
    public void store(IRiakObject object) throws IOException {
        this.store(object, StoreMeta.empty());
    }

    @Override
    public void delete(String bucket, String key) throws IOException {
        this.client.delete(bucket, key);
    }

    @Override
    public void delete(String bucket, String key, int deleteQuorum) throws IOException {
        this.client.delete(bucket, key, deleteQuorum);
    }

    @Override
    public void delete(String bucket, String key, DeleteMeta deleteMeta) throws IOException {
        this.client.delete(bucket, key, ConversionUtil.convert(deleteMeta));
    }

    @Override
    public Set<String> listBuckets() throws IOException {
        ByteString[] buckets;
        HashSet<String> response = new HashSet<String>();
        for (ByteString b : buckets = this.client.listBuckets()) {
            response.add(b.toStringUtf8());
        }
        return response;
    }

    @Override
    public BucketProperties fetchBucket(String bucketName) throws IOException {
        if (bucketName == null || bucketName.trim().equals("")) {
            throw new IllegalArgumentException("bucketName cannot be null, empty or all whitespace");
        }
        com.basho.riak.pbc.BucketProperties properties = this.client.getBucketProperties(ByteString.copyFromUtf8((String)bucketName));
        return ConversionUtil.convert(properties);
    }

    @Override
    public void updateBucket(String name, BucketProperties bucketProperties) throws IOException {
        com.basho.riak.pbc.BucketProperties properties = ConversionUtil.convert(bucketProperties);
        this.client.setBucketProperties(ByteString.copyFromUtf8((String)name), properties);
    }

    @Override
    public Iterable<String> listKeys(String bucketName) throws IOException {
        if (bucketName == null || bucketName.trim().equals("")) {
            throw new IllegalArgumentException("bucketName cannot be null, empty or all whitespace");
        }
        final KeySource keySource = this.client.listKeys(ByteString.copyFromUtf8((String)bucketName));
        final Iterator<String> i = new Iterator<String>(){
            private final Iterator<ByteString> delegate;
            {
                this.delegate = keySource.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public String next() {
                return ConversionUtil.nullSafeToStringUtf8(this.delegate.next());
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        };
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return i;
            }
        };
    }

    @Override
    public WalkResult linkWalk(LinkWalkSpec linkWalkSpec) throws IOException {
        MapReduceResult firstPhaseResult = this.linkWalkFirstPhase(linkWalkSpec);
        MapReduceResult secondPhaseResult = this.linkWalkSecondPhase(firstPhaseResult);
        WalkResult result = ConversionUtil.convert(secondPhaseResult);
        return result;
    }

    private MapReduceResult linkWalkFirstPhase(LinkWalkSpec linkWalkSpec) throws IOException {
        BucketKeyMapReduce mr = new BucketKeyMapReduce(this);
        mr.addInput(linkWalkSpec.getStartBucket(), linkWalkSpec.getStartKey());
        int size = linkWalkSpec.size();
        int cnt = 0;
        for (LinkWalkStep step : linkWalkSpec) {
            boolean keep = ConversionUtil.linkAccumulateToLinkPhaseKeep(step.getKeep(), ++cnt == size);
            mr.addLinkPhase(step.getBucket(), step.getTag(), keep);
        }
        try {
            return mr.execute();
        }
        catch (RiakException e) {
            throw (IOException)e.getCause();
        }
    }

    private MapReduceResult linkWalkSecondPhase(MapReduceResult firstPhaseResult) throws IOException {
        try {
            Collection<LinkedList> bkeys = firstPhaseResult.getResult(LinkedList.class);
            BucketKeyMapReduce mr = new BucketKeyMapReduce(this);
            int stepCnt = 0;
            for (LinkedList step : bkeys) {
                ++stepCnt;
                for (List input : step) {
                    mr.addInput((String)input.get(0), (String)input.get(1), Integer.toString(stepCnt));
                }
            }
            mr.addReducePhase((Function)new NamedErlangFunction("riak_kv_mapreduce", "reduce_set_union"), false);
            mr.addMapPhase((Function)new JSSourceFunction("function(v, keyData) { return [{\"step\": keyData, \"v\": v}]; }"), true);
            return mr.execute();
        }
        catch (ConversionException e) {
            throw new IOException(e.getMessage());
        }
        catch (RiakException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public MapReduceResult mapReduce(MapReduceSpec spec) throws IOException, MapReduceTimeoutException {
        RequestMeta meta = new RequestMeta();
        meta.contentType("application/json");
        try {
            MapReduceResponseSource resp = this.client.mapReduce(spec.getJSON(), (IRequestMeta)meta);
            return ConversionUtil.convert(resp);
        }
        catch (RiakError e) {
            if (JSONErrorParser.isTimeoutException(e.getMessage())) {
                throw new MapReduceTimeoutException();
            }
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public List<String> fetchIndex(IndexQuery indexQuery) throws IOException {
        final ResultCapture res = new ResultCapture();
        IndexWriter executor = new IndexWriter(){

            public void write(String bucket, String index, String from, String to) throws IOException {
                res.capture(PBClientAdapter.this.client.index(bucket, index, from, to));
            }

            public void write(String bucket, String index, String value) throws IOException {
                res.capture(PBClientAdapter.this.client.index(bucket, index, value));
            }

            public void write(String bucket, String index, long value) throws IOException {
                res.capture(PBClientAdapter.this.client.index(bucket, index, value));
            }

            public void write(String bucket, String index, long from, long to) throws IOException {
                res.capture(PBClientAdapter.this.client.index(bucket, index, from, to));
            }
        };
        indexQuery.write(executor);
        return (List)res.get();
    }

    @Override
    public byte[] generateAndSetClientId() throws IOException {
        this.client.prepareClientID();
        return CharsetUtils.utf8StringToBytes(this.client.getClientID());
    }

    @Override
    public void setClientId(byte[] clientId) throws IOException {
        if (clientId == null || clientId.length != 4) {
            throw new IllegalArgumentException("clientId must be 4 bytes. generateAndSetClientId() can do this for you");
        }
        this.client.setClientID(ByteString.copyFrom((byte[])clientId));
    }

    @Override
    public byte[] getClientId() throws IOException {
        String clientId = this.client.getClientID();
        if (clientId != null) {
            return CharsetUtils.utf8StringToBytes(clientId);
        }
        throw new IOException("null clientId returned by client");
    }

    @Override
    public void ping() throws IOException {
        this.client.ping();
    }

    @Override
    public Transport getTransport() {
        return Transport.PB;
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    @Override
    public NodeStats stats() {
        throw new UnsupportedOperationException("Not supported using protobuffer protocol.");
    }
}

