/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.cap.ClientId;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.response.BucketResponse;
import com.basho.riak.client.http.response.FetchResponse;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.IndexResponse;
import com.basho.riak.client.http.response.ListBucketsResponse;
import com.basho.riak.client.http.response.MapReduceResponse;
import com.basho.riak.client.http.response.StoreResponse;
import com.basho.riak.client.http.response.WithBodyResponse;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.NodeStats;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.MatchFoundException;
import com.basho.riak.client.raw.ModifiedException;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import com.basho.riak.client.raw.StoreMeta;
import com.basho.riak.client.raw.Transport;
import com.basho.riak.client.raw.http.ConversionUtil;
import com.basho.riak.client.raw.http.KeySource;
import com.basho.riak.client.raw.http.ResultCapture;
import com.basho.riak.client.raw.query.LinkWalkSpec;
import com.basho.riak.client.raw.query.MapReduceSpec;
import com.basho.riak.client.raw.query.MapReduceTimeoutException;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import com.basho.riak.client.raw.query.indexes.IndexWriter;
import com.basho.riak.client.util.CharsetUtils;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPClientAdapter
implements RawClient {
    private final RiakClient client;

    public HTTPClientAdapter(RiakClient client) {
        this.client = client;
    }

    public HTTPClientAdapter(String url) {
        this(new RiakClient(url));
    }

    @Override
    public RiakResponse head(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null and bucket.getName() must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        fetchMeta = fetchMeta == null ? FetchMeta.head() : new FetchMeta(fetchMeta.getR(), fetchMeta.getPr(), fetchMeta.getNotFoundOK(), fetchMeta.getBasicQuorum(), (Boolean)true, fetchMeta.getReturnDeletedVClock(), fetchMeta.getIfModifiedSince(), fetchMeta.getIfModifiedVClock());
        RequestMeta rm = ConversionUtil.convert(fetchMeta);
        FetchResponse resp = this.client.fetchMeta(bucket, key, rm);
        return this.handleBodyResponse(resp);
    }

    @Override
    public RiakResponse fetch(String bucket, String key) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null and bucket.getName() must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        FetchResponse resp = this.client.fetch(bucket, key);
        return this.handleBodyResponse(resp);
    }

    @Override
    public RiakResponse fetch(String bucket, String key, int readQuorum) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null and bucket.getName() must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        FetchResponse resp = this.client.fetch(bucket, key, RequestMeta.readParams(readQuorum));
        return this.handleBodyResponse(resp);
    }

    @Override
    public RiakResponse fetch(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        if (bucket == null || bucket.trim().equals("")) {
            throw new IllegalArgumentException("bucket must not be null and bucket.getName() must not be null or empty or just whitespace.");
        }
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key cannot be null or empty or just whitespace");
        }
        RequestMeta rm = ConversionUtil.convert(fetchMeta);
        FetchResponse resp = this.client.fetch(bucket, key, rm);
        return this.handleBodyResponse(resp);
    }

    private RiakResponse handleBodyResponse(WithBodyResponse resp) {
        boolean unmodified = resp.getStatusCode() == 304;
        RiakResponse response = RiakResponse.empty(unmodified);
        IRiakObject[] values = new IRiakObject[]{};
        if (resp.hasSiblings()) {
            values = ConversionUtil.convert(resp.getSiblings());
        } else if (resp.hasObject() && !unmodified) {
            values = new IRiakObject[]{ConversionUtil.convert(resp.getObject())};
        }
        if (values.length > 0) {
            response = new RiakResponse(CharsetUtils.utf8StringToBytes(resp.getVclock()), values);
        }
        return response;
    }

    @Override
    public RiakResponse store(IRiakObject object, StoreMeta storeMeta) throws IOException {
        RequestMeta requestMeta;
        if (object == null || object.getBucket() == null) {
            throw new IllegalArgumentException("cannot store a null RiakObject, or a RiakObject without a bucket");
        }
        RiakResponse response = RiakResponse.empty();
        RiakObject riakObject = ConversionUtil.convert(object, this.client);
        StoreResponse resp = this.client.store(riakObject, requestMeta = ConversionUtil.convert(storeMeta));
        if (!resp.isSuccess()) {
            if (resp.getStatusCode() == 412) {
                if (storeMeta.hasIfNoneMatch() && storeMeta.getIfNoneMatch().booleanValue()) {
                    throw new MatchFoundException();
                }
                if (storeMeta.hasIfNotModified() && storeMeta.getIfNotModified().booleanValue()) {
                    throw new ModifiedException();
                }
            }
            throw new IOException(resp.getStatusCode() + " " + resp.getBodyAsString());
        }
        if (storeMeta.hasReturnBody() && storeMeta.getReturnBody().booleanValue()) {
            response = this.handleBodyResponse(resp);
        } else if (storeMeta.hasReturnHead() && storeMeta.getReturnHead().booleanValue()) {
            FetchResponse fr = this.client.fetchMeta(object.getBucket(), object.getKey());
            response = this.handleBodyResponse(fr);
        }
        return response;
    }

    @Override
    public void store(IRiakObject object) throws IOException {
        this.store(object, StoreMeta.empty());
    }

    @Override
    public void delete(String bucket, String key) throws IOException {
        HttpResponse resp = this.client.delete(bucket, key);
        if (!resp.isSuccess()) {
            throw new IOException(resp.getBodyAsString());
        }
    }

    @Override
    public void delete(String bucket, String key, int deleteQuorum) throws IOException {
        HttpResponse resp = this.client.delete(bucket, key, RequestMeta.deleteParams(deleteQuorum));
        if (!resp.isSuccess()) {
            throw new IOException(resp.getBodyAsString());
        }
    }

    @Override
    public void delete(String bucket, String key, DeleteMeta deleteMeta) throws IOException {
        HttpResponse resp = this.client.delete(bucket, key, ConversionUtil.convert(deleteMeta));
        if (!resp.isSuccess()) {
            throw new IOException(resp.getBodyAsString());
        }
    }

    @Override
    public Set<String> listBuckets() throws IOException {
        ListBucketsResponse lbr = this.client.listBuckets();
        if (!lbr.isSuccess()) {
            throw new IOException("List Buckets failed with status code: " + lbr.getStatusCode());
        }
        return new HashSet<String>(lbr.getBuckets());
    }

    @Override
    public BucketProperties fetchBucket(String bucketName) throws IOException {
        if (bucketName == null || bucketName.trim().equals("")) {
            throw new IllegalArgumentException("bucketName cannot be null, empty or all whitespace");
        }
        BucketResponse response = this.client.getBucketSchema(bucketName, null);
        return ConversionUtil.convert(response);
    }

    @Override
    public void updateBucket(String name, BucketProperties bucketProperties) throws IOException {
        HttpResponse response = this.client.setBucketSchema(name, ConversionUtil.convert(bucketProperties));
        if (!response.isSuccess()) {
            throw new IOException(response.getBodyAsString());
        }
    }

    @Override
    public Iterable<String> listKeys(String bucketName) throws IOException {
        BucketResponse bucketResponse = this.client.streamBucket(bucketName);
        if (bucketResponse.isSuccess()) {
            final KeySource keyStream = new KeySource(bucketResponse);
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return keyStream;
                }
            };
        }
        throw new IOException("stream keys for bucket " + bucketName + " failed with response code : " + bucketResponse.getStatusCode() + ", body: " + bucketResponse.getBodyAsString());
    }

    @Override
    public WalkResult linkWalk(LinkWalkSpec linkWalkSpec) throws IOException {
        String walkSpecString = ConversionUtil.convert(linkWalkSpec);
        return ConversionUtil.convert(this.client.walk(linkWalkSpec.getStartBucket(), linkWalkSpec.getStartKey(), walkSpecString));
    }

    @Override
    public MapReduceResult mapReduce(MapReduceSpec spec) throws IOException, MapReduceTimeoutException {
        MapReduceResponse resp = this.client.mapReduce(spec.getJSON());
        return ConversionUtil.convert(resp);
    }

    @Override
    public byte[] generateAndSetClientId() throws IOException {
        this.setClientId(ClientId.generate());
        return this.client.getClientId();
    }

    @Override
    public void setClientId(byte[] clientId) throws IOException {
        if (clientId == null || clientId.length != 4) {
            throw new IllegalArgumentException("clientId must be 4 bytes. generateAndSetClientId() can do this for you");
        }
        this.client.setClientId(CharsetUtils.asString(clientId, CharsetUtils.ISO_8859_1));
    }

    @Override
    public byte[] getClientId() throws IOException {
        return this.client.getClientId();
    }

    @Override
    public void ping() throws IOException {
        HttpResponse resp = this.client.ping();
        if (!resp.isSuccess()) {
            throw new IOException(resp.getBodyAsString());
        }
    }

    @Override
    public List<String> fetchIndex(IndexQuery indexQuery) throws IOException {
        final ResultCapture res = new ResultCapture();
        IndexWriter executor = new IndexWriter(){

            public void write(String bucket, String index, String from, String to) throws IOException {
                res.capture(HTTPClientAdapter.this.client.index(bucket, index, from, to));
            }

            public void write(String bucket, String index, String value) throws IOException {
                res.capture(HTTPClientAdapter.this.client.index(bucket, index, value));
            }

            public void write(String bucket, String index, long value) throws IOException {
                res.capture(HTTPClientAdapter.this.client.index(bucket, index, value));
            }

            public void write(String bucket, String index, long from, long to) throws IOException {
                res.capture(HTTPClientAdapter.this.client.index(bucket, index, from, to));
            }
        };
        indexQuery.write(executor);
        return ConversionUtil.convert((IndexResponse)res.get());
    }

    @Override
    public Transport getTransport() {
        return Transport.HTTP;
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    @Override
    public NodeStats stats() throws IOException {
        HttpResponse r = this.client.stats();
        if (!r.isSuccess()) {
            throw new IOException("stats failed with status code: " + r.getStatusCode());
        }
        try {
            NodeStats.UndefinedStatDeserializer usd = new NodeStats.UndefinedStatDeserializer();
            SimpleModule module = new SimpleModule("UndefinedStatDeserializer", new Version(1, 0, 0, null, null, null));
            module.addDeserializer(BigInteger.class, (JsonDeserializer)usd);
            return (NodeStats)new ObjectMapper().registerModule((Module)module).readValue(r.getBodyAsString(), NodeStats.class);
        }
        catch (IOException e) {
            throw new IOException("Could not parse stats JSON response, body: " + r.getBodyAsString(), e);
        }
    }

    public RiakConfig getConfig() {
        return this.client.getConfig();
    }
}

