/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw;

import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Quorum;
import java.util.Date;

public class StoreMeta {
    private static final StoreMeta EMPTY = new StoreMeta(null, null, null, false, null, null);
    private final Quorum w;
    private final Quorum dw;
    private final Quorum pw;
    private final Boolean returnBody;
    private final Boolean returnHead;
    private final Boolean ifNoneMatch;
    private final Boolean ifNotModified;
    private String[] etags;
    private Long lastModified;

    public StoreMeta(Integer w, Integer dw, Integer pw, Boolean returnBody, Boolean ifNoneMatch, Boolean ifNotModified) {
        this(null == w ? null : new Quorum(w), null == dw ? null : new Quorum(dw), null == pw ? null : new Quorum(pw), returnBody, null, ifNoneMatch, ifNotModified);
    }

    public StoreMeta(Integer w, Integer dw, Integer pw, Boolean returnBody, Boolean returnHead, Boolean ifNoneMatch, Boolean ifNotModified) {
        this(null == w ? null : new Quorum(w), null == dw ? null : new Quorum(dw), null == pw ? null : new Quorum(pw), returnBody, returnHead, ifNoneMatch, ifNotModified);
    }

    public StoreMeta(Quorum w, Quorum dw, Quorum pw, Boolean returnBody, Boolean returnHead, Boolean ifNoneMatch, Boolean ifNotModified) {
        this.w = w;
        this.dw = dw;
        this.pw = pw;
        this.returnBody = returnBody;
        this.returnHead = returnHead;
        this.ifNoneMatch = ifNoneMatch;
        this.ifNotModified = ifNotModified;
    }

    public Quorum getW() {
        return this.w;
    }

    public boolean hasW() {
        return this.w != null;
    }

    public Quorum getDw() {
        return this.dw;
    }

    public boolean hasDw() {
        return this.dw != null;
    }

    public boolean hasReturnBody() {
        return this.returnBody != null;
    }

    public Boolean getReturnBody() {
        return this.returnBody;
    }

    public boolean hasPw() {
        return this.pw != null;
    }

    public Quorum getPw() {
        return this.pw;
    }

    public boolean hasIfNoneMatch() {
        return this.ifNoneMatch != null;
    }

    public Boolean getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public boolean isIfNoneMatch() {
        return this.hasIfNoneMatch() && this.ifNoneMatch != false;
    }

    public boolean hasIfNotModified() {
        return this.ifNotModified != null;
    }

    public Boolean getIfNotModified() {
        return this.ifNotModified;
    }

    public boolean isIfNotModified() {
        return this.hasIfNotModified() && this.ifNotModified != false;
    }

    public static StoreMeta empty() {
        return EMPTY;
    }

    public boolean hasReturnHead() {
        return this.returnHead != null;
    }

    public Boolean getReturnHead() {
        return this.returnHead;
    }

    public synchronized StoreMeta etags(String[] etags) {
        if (etags != null) {
            this.etags = (String[])etags.clone();
        }
        return this;
    }

    public synchronized String[] getEtags() {
        if (this.etags != null) {
            return (String[])this.etags.clone();
        }
        return null;
    }

    public synchronized Date getLastModified() {
        if (this.lastModified != null) {
            return new Date(this.lastModified);
        }
        return null;
    }

    public synchronized StoreMeta lastModified(Date lastModified) {
        if (lastModified != null) {
            this.lastModified = lastModified.getTime();
        }
        return this;
    }

    public static StoreMeta headOnly() {
        return new StoreMeta((Quorum)null, null, null, null, (Boolean)true, null, null);
    }

    public static class Builder {
        private Quorum w;
        private Quorum dw;
        private Quorum pw;
        private Boolean returnBody;
        private Boolean returnHead;
        private Boolean ifNotModified;
        private Boolean ifNoneMatch;

        public StoreMeta build() {
            return new StoreMeta(this.w, this.dw, this.pw, this.returnBody, this.returnHead, this.ifNoneMatch, this.ifNotModified);
        }

        public Builder w(int w) {
            this.w = new Quorum(w);
            return this;
        }

        public Builder w(Quora w) {
            this.w = new Quorum(w);
            return this;
        }

        public Builder w(Quorum w) {
            this.w = w;
            return this;
        }

        public Builder dw(int dw) {
            this.dw = new Quorum(dw);
            return this;
        }

        public Builder dw(Quora dw) {
            this.dw = new Quorum(dw);
            return this;
        }

        public Builder dw(Quorum dw) {
            this.dw = dw;
            return this;
        }

        public Builder pw(int pw) {
            this.pw = new Quorum(pw);
            return this;
        }

        public Builder pw(Quora pw) {
            this.pw = new Quorum(pw);
            return this;
        }

        public Builder pw(Quorum pw) {
            this.pw = pw;
            return this;
        }

        public Builder returnBody(boolean returnBody) {
            this.returnBody = returnBody;
            return this;
        }

        public Builder returnHead(boolean returnHead) {
            this.returnHead = returnHead;
            return this;
        }

        public Builder ifNotModified(boolean ifNotModified) {
            this.ifNotModified = ifNotModified;
            return this;
        }

        public Builder ifNoneMatch(boolean ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }
    }
}

