/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query.indexes;

import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.IntIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakIndexes {
    private final ConcurrentMap<BinIndex, Set<String>> binIndexes = new ConcurrentHashMap<BinIndex, Set<String>>();
    private final ConcurrentMap<IntIndex, Set<Integer>> intIndexes = new ConcurrentHashMap<IntIndex, Set<Integer>>();

    public RiakIndexes(Map<BinIndex, Set<String>> binIndexes, Map<IntIndex, Set<Integer>> intIndexes) {
        Set<Object> v;
        for (Map.Entry<BinIndex, Set<String>> entry : binIndexes.entrySet()) {
            v = entry.getValue();
            if (v == null) continue;
            this.binIndexes.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<RiakIndex, Set<Object>> entry : intIndexes.entrySet()) {
            v = entry.getValue();
            if (v == null) continue;
            this.intIndexes.put((IntIndex)entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    public RiakIndexes() {
    }

    public Map<BinIndex, Set<String>> getBinIndexes() {
        return new HashMap<BinIndex, Set<String>>(this.binIndexes);
    }

    public Map<IntIndex, Set<Integer>> getIntIndexes() {
        return new HashMap<IntIndex, Set<Integer>>(this.intIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes add(String index, String value) {
        String lock;
        BinIndex key = BinIndex.named(index);
        String string = lock = key.getFullname().intern();
        synchronized (string) {
            HashSet<String> values = (HashSet<String>)this.binIndexes.get(key);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.add(value);
            this.binIndexes.put(key, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes addBinSet(String index, Set<String> newValues) {
        String lock;
        BinIndex key = BinIndex.named(index);
        String string = lock = key.getFullname().intern();
        synchronized (string) {
            HashSet<String> values = (HashSet<String>)this.binIndexes.get(key);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.addAll(newValues);
            this.binIndexes.put(key, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes add(String index, int value) {
        String lock;
        IntIndex key = IntIndex.named(index);
        String string = lock = key.getFullname().intern();
        synchronized (string) {
            HashSet<Integer> values = (HashSet<Integer>)this.intIndexes.get(key);
            if (values == null) {
                values = new HashSet<Integer>();
            }
            values.add(value);
            this.intIndexes.put(key, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes addIntSet(String index, Set<Integer> newValues) {
        String lock;
        IntIndex key = IntIndex.named(index);
        String string = lock = key.getFullname().intern();
        synchronized (string) {
            HashSet<Integer> values = (HashSet<Integer>)this.intIndexes.get(key);
            if (values == null) {
                values = new HashSet<Integer>();
            }
            values.addAll(newValues);
            this.intIndexes.put(key, values);
        }
        return this;
    }

    public RiakIndexes removeAll(BinIndex index) {
        this.binIndexes.remove(index);
        return this;
    }

    public RiakIndexes removeAll(IntIndex index) {
        this.intIndexes.remove(index);
        return this;
    }

    public static RiakIndexes from(RiakIndexes indexes) {
        return new RiakIndexes(indexes.getBinIndexes(), indexes.getIntIndexes());
    }

    public Set<String> getBinIndex(String name) {
        Set values = (Set)this.binIndexes.get(BinIndex.named(name));
        if (values == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(values);
    }

    public Set<Integer> getIntIndex(String name) {
        Set values = (Set)this.intIndexes.get(IntIndex.named(name));
        if (values == null) {
            return new HashSet<Integer>();
        }
        return new HashSet<Integer>(values);
    }
}

